from xlrxldeploy import *
import xldeploy
from xldeploy.domain.ConfigurationItem import ConfigurationItem
from com.xebialabs.deployit import ServerConfiguration
from com.xebialabs.xlrelease.script import EncryptionHelper

if not connectionServer:
    raise Exception("Deploy server connection must be provided to script")

if not connection:
    raise Exception("Deploy webhook connection definition must be provided to script")

server = {}
for entry in connectionServer.entrySet():
    server[entry.key] = entry.value
server = ObjectView(server)

connectionConf = {}
for entry in connection.entrySet():
    connectionConf[entry.key] = entry.value
connectionConf = ObjectView(connectionConf)

serverConf = ServerConfiguration.getInstance()
serverUrl = serverConf.getServerUrl()

config = get_client_config(xld_server=server, task=None, username=None, password=None)
client = xldeploy.Client(config)

endpointPath = serverUrl + "webhooks/" + connectionConf.eventSource.path()

filteredFolders = []
for folder in connection['filteredFolders']:
    filteredFolders.append(folder)


params = {'webhookServerURL': endpointPath, 'filteredFolders': filteredFolders}
if connectionConf.eventSource.authentication().type.toString() == 'events.TokenAuthentication':
    authentication = connectionConf.eventSource.authentication()
    EncryptionHelper.decrypt(authentication)
    params['tokenHeader'] = 'X-Release-Webhook-Token'
    params['tokenValue'] = authentication.webhookToken()
else:
    params['noAuthentication'] = 'true'

ci = ConfigurationItem("Configuration/" + connectionConf.eventSource.title, "webhook.WebhookServer", params)

if bool(client.repository.exists(ci.id)):
    client.repository.update_ci(ci)
else:
    client.repository.create_ci(ci)

data = None
