from xlrxldeploy import *
import xldeploy
from xldeploy.domain.ConfigurationItem import ConfigurationItem
from com.xebialabs.xlrelease.status.service.script import AutoconfigResult
from com.xebialabs.deployit import ServerConfiguration
from com.xebialabs.xlrelease.script import EncryptionHelper

if not connectionServer:
    raise Exception("Deploy server connection must be provided to script")

if not webhook:
    raise Exception("Webhook definition must be provided to script")

server = {}
for entry in connectionServer.entrySet():
    server[entry.key] = entry.value
server = ObjectView(server)

webhookConf = {}
for entry in webhook.entrySet():
    webhookConf[entry.key] = entry.value
webhookConf = ObjectView(webhookConf)

serverConf = ServerConfiguration.getInstance()
serverUrl = serverConf.getServerUrl()

config = get_client_config(xld_server=server, task=None, username=None, password=None)
client = xldeploy.Client(config)

endpointPath = serverUrl + "webhooks/" + webhookConf.eventSource.path()

params = {'webhookServerURL': endpointPath}
if webhookConf.eventSource.authentication().type.toString() == 'events.TokenAuthentication':
    authentication = webhookConf.eventSource.authentication()
    EncryptionHelper.decrypt(authentication)
    params['tokenHeader'] = 'X-Release-Webhook-Token'
    params['tokenValue'] = authentication.webhookToken()
else:
    params['noAuthentication'] = 'true'

ci = ConfigurationItem("Configuration/" + webhookConf.eventSource.title, "webhook.WebhookServer", params)

if bool(client.repository.exists(ci.id)):
    client.repository.update_ci(ci)
else:
    client.repository.create_ci(ci)

sourceServerUrl = webhookConf.sourceServer.url.rstrip("/")
url = sourceServerUrl + "/#/explorer?ciId=" + ci.id

data = AutoconfigResult("Successfully created Webhook configuration on Deploy Server. {0} was created for {1}. Use "
                        " below link to review the configuration. ".format(ci.id, server.title), "", url)
