from xlrxldeploy import query_xld_repository
from xldeploy.domain.QueryBuilder import QueryBuilder

page_size = 9
query_builder = QueryBuilder().type("udm.Version").result_per_page(page_size)
if request.query['namePattern']:
    query_builder = query_builder.name_pattern("%{0}%".format(request.query['namePattern']))
if request.query['parent']:
    query_builder = query_builder.parent(request.query['parent'])
if 'page' in request.query:
    query_builder = query_builder.page(request.query['page'])

params = query_builder.build()
xld_response = query_xld_repository(securityApi, configurationApi, taskApi, request, params)

output = list(map((lambda (version): version['ref'][version['ref'].rfind('/') + 1:]), xld_response))
# add more link if max page size returned
if len(output) == page_size:
    output.append('--more--')

response.entity = output

