/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.apiclient;

import com.versionone.apiclient.CookieData;
import com.versionone.apiclient.CookieKey;
import com.versionone.apiclient.interfaces.ICookiesManager;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

public class CookiesManager
extends HashMap<String, CookieData>
implements ICookiesManager {
    private static final long serialVersionUID = -5115415390702250886L;
    private static final String SET_COOKIE_PARAM = "Set-Cookie";
    private static final String COOKIE_PARAM = "Cookie";
    private static final String COOKIES_DATA_DELIMITER = ";";
    private static final String COOKIES_SEPARATOR = "; ";
    private static final String NAME_VALUE_SEPARATOR = "=";
    private static final String EXPIRES = "expires";
    private static final DateFormat dateFormat = new SimpleDateFormat("EEE, dd-MMM-yyyy hh:mm:ss z", Locale.US);
    private static Map<CookieKey, CookiesManager> cookiesManagers = new HashMap<CookieKey, CookiesManager>();

    private CookiesManager() {
    }

    private CookiesManager(int size) {
        super(size);
    }

    public static CookiesManager getCookiesManager(String path) {
        return CookiesManager.getCookiesManager(path, null, null);
    }

    public static CookiesManager getCookiesManager(String path, String userName, String password) {
        CookieKey key = new CookieKey(CookiesManager.getDomenToken(path), userName, password);
        if (!cookiesManagers.containsKey(key)) {
            cookiesManagers.put(key, new CookiesManager());
        }
        return cookiesManagers.get(key);
    }

    public static String getDomenToken(String url) {
        String token = url;
        try {
            URL urlData = new URL(url);
            token = urlData.getHost();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (token.startsWith("www.")) {
            token = token.replaceFirst("www.", "");
        }
        return token;
    }

    private void addCookie(String cookie) {
        StringTokenizer cookieData;
        if (cookie != null && !cookie.equals("") && (cookieData = new StringTokenizer(cookie, COOKIES_DATA_DELIMITER)).hasMoreTokens()) {
            String data = cookieData.nextToken();
            String name = data.substring(0, data.indexOf(NAME_VALUE_SEPARATOR));
            String value = data.substring(data.indexOf(NAME_VALUE_SEPARATOR) + 1, data.length());
            Date expires = null;
            while (cookieData.hasMoreTokens()) {
                data = cookieData.nextToken();
                String[] attibutesData = data.split(NAME_VALUE_SEPARATOR);
                if (!attibutesData[0].trim().equals(EXPIRES)) continue;
                try {
                    expires = dateFormat.parse(attibutesData[1].trim());
                }
                catch (ParseException ex) {
                    System.out.println("incorrect data:" + ex.getMessage());
                }
            }
            this.addCookie(name, value, expires);
        }
    }

    public String getCookies() {
        String cookies = "";
        if (this.size() > 0) {
            boolean isFirst = true;
            ArrayList<String> cookiesForDelite = new ArrayList<String>();
            for (String name : this.keySet()) {
                CookieData cookiesData = (CookieData)this.get(name);
                if (this.isNotExpired(cookiesData.getExpire())) {
                    if (!isFirst) {
                        cookies = cookies + COOKIES_SEPARATOR;
                    } else {
                        isFirst = false;
                    }
                    cookies = cookies + cookiesData.getName() + NAME_VALUE_SEPARATOR + cookiesData.getValue();
                    continue;
                }
                cookiesForDelite.add(name);
            }
            this.deleteCookies(cookiesForDelite);
        }
        return cookies != "" ? cookies : null;
    }

    private void deleteCookies(List<String> cookiesForDelite) {
        for (String name : cookiesForDelite) {
            this.deleteCookie(name);
        }
    }

    @Override
    public void deleteCookie(String name) {
        this.remove(name);
    }

    public void addCookie(Map<String, List<String>> headerData) {
        List<String> listCookies = headerData.get(SET_COOKIE_PARAM);
        if (listCookies != null && listCookies.size() > 0) {
            for (String cookie : listCookies) {
                this.addCookie(cookie);
            }
        }
    }

    @Override
    public void addCookie(String name, String value, Date expires) {
        this.put(name, new CookieData(name, value, expires));
    }

    private boolean isNotExpired(Date expiresDate) {
        if (expiresDate == null) {
            return true;
        }
        Date now = new Date();
        return now.compareTo(expiresDate) <= 0;
    }

    protected void addCookiesToRequest(HttpURLConnection request) {
        if (request == null) {
            return;
        }
        String cookies = this.getCookies();
        if (cookies != null) {
            request.setRequestProperty(COOKIE_PARAM, cookies);
        }
    }

    @Override
    public String getCookie(String name) {
        if (this.containsKey(name)) {
            return ((CookieData)this.get(name)).getValue();
        }
        return null;
    }

    @Override
    public void deleteAllCookies() {
        this.clear();
    }
}

