/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.apiclient;

import com.versionone.apiclient.ProxyProvider;
import com.versionone.apiclient.exceptions.ConnectionException;
import com.versionone.apiclient.exceptions.V1Exception;
import com.versionone.utils.V1Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.WinHttpClients;
import org.apache.http.message.BasicHeader;

public class V1Connector {
    private final String contentType = "text/xml";
    private CredentialsProvider credsProvider = new BasicCredentialsProvider();
    private CloseableHttpResponse httpResponse = null;
    private HttpClientBuilder httpclientBuilder = HttpClientBuilder.create();
    private CloseableHttpClient httpclient;
    private Header[] headerArray = new Header[0];
    private HttpPost httpPost;
    private boolean isWindowsAuth = false;
    private final Map<String, OutputStream> _pendingStreams = new HashMap<String, OutputStream>();
    private final Map<String, String> _pendingContentTypes = new HashMap<String, String>();
    URL INSTANCE_URL;
    String _endpoint = "";
    String _user_agent_header = "";
    String _upstreamUserAgent = "";
    private static final String META_API_ENDPOINT = "meta.v1/";
    private static final String DATA_API_ENDPOINT = "rest-1.v1/Data/";
    private static final String NEW_API_ENDPOINT = "rest-1.v1/New/";
    private static final String HISTORY_API_ENDPOINT = "rest-1.v1/Hist/";
    private static final String QUERY_API_ENDPOINT = "query.v1/";
    private static final String LOC_API_ENDPOINT = "loc.v1/";
    private static final String LOC2_API_ENDPOINT = "loc-2.v1/";
    private static final String CONFIG_API_ENDPOINT = "config.v1/";
    private static final String ATTACHMENT_API_ENDPOINT = "attachment.img/";
    private static final String EMBEDDED_API_ENDPOINT = "embedded.img/";

    protected V1Connector(String instanceUrl) throws V1Exception, MalformedURLException {
        URL urlData;
        if (V1Util.isNullOrEmpty(instanceUrl)) {
            throw new NullPointerException("The VersionOne instance URL cannot be null or empty.");
        }
        if (!StringUtils.endsWith(instanceUrl, "/")) {
            instanceUrl = instanceUrl + "/";
        }
        this.INSTANCE_URL = urlData = new URL(instanceUrl);
    }

    public static ISetUserAgentMakeRequest withInstanceUrl(String instanceUrl) throws V1Exception, MalformedURLException {
        return new Builder(instanceUrl);
    }

    protected Reader getData() throws ConnectionException {
        return this.getData("");
    }

    protected Reader getData(String path) throws ConnectionException {
        InputStreamReader data = null;
        HttpEntity entity = this.setGETMethod(path);
        int errorCode = this.httpResponse.getStatusLine().getStatusCode();
        String errorMessage = "\n" + this.httpResponse.getStatusLine() + " error code: " + errorCode;
        if (errorCode == 200) {
            try {
                data = new InputStreamReader(entity.getContent());
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.manageErrors(errorCode, errorMessage);
        }
        return data;
    }

    protected InputStream getAttachment(String path) throws ConnectionException {
        InputStream data = null;
        HttpEntity entity = this.setGETMethod(path);
        int errorCode = this.httpResponse.getStatusLine().getStatusCode();
        String errorMessage = "\n" + this.httpResponse.getStatusLine() + " error code: " + errorCode;
        if (errorCode == 200) {
            try {
                data = entity.getContent();
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.manageErrors(errorCode, errorMessage);
        }
        return data;
    }

    private HttpEntity setGETMethod(String path) {
        String url = V1Util.isNullOrEmpty(path) ? this.INSTANCE_URL + this._endpoint : this.INSTANCE_URL + this._endpoint + path;
        HttpGet request = new HttpGet(url);
        this.setDefaultHeaderValue();
        request.setHeaders(this.headerArray);
        if (!this.isWindowsAuth) {
            this.httpclient = this.httpclientBuilder.build();
        }
        try {
            this.httpResponse = this.httpclient.execute(request);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HttpEntity entity = this.httpResponse.getEntity();
        return entity;
    }

    private void manageErrors(int errorCode, String errorMessage) throws ConnectionException {
        switch (errorCode) {
            case 400: {
                throw new ConnectionException(errorMessage + " VersionOne could not process the request.");
            }
            case 401: {
                throw new ConnectionException(errorMessage + " Could not authenticate. The VersionOne credentials may be incorrect or the access tokens may have expired.");
            }
            case 404: {
                throw new ConnectionException(errorMessage + " The requested item may not exist, or the VersionOne server is unavailable.");
            }
            case 405: {
                throw new ConnectionException(errorMessage + " Only GET and POST methods are supported by VersionOne.");
            }
            case 500: {
                throw new ConnectionException(errorMessage + " VersionOne encountered an unexpected error occurred while processing the request.");
            }
        }
        throw new ConnectionException(errorMessage);
    }

    private void setDefaultHeaderValue() {
        String localeName = Locale.getDefault().toString();
        localeName = localeName.replace("_", "-");
        boolean uniqueValue = true;
        BasicHeader header = new BasicHeader("Accept-Language", localeName);
        for (Header header2 : this.headerArray) {
            if (!header2.getValue().equals(header.getValue()) || !header2.getName().equals(header.getName())) continue;
            uniqueValue = false;
            break;
        }
        if (uniqueValue) {
            this.headerArray = (Header[])ArrayUtils.add(this.headerArray, header);
        }
    }

    protected Reader sendData(String path, Object data) throws ConnectionException {
        return this.sendData(path, data, "text/xml");
    }

    private HttpPost setPostHeader(String path, String contentType) {
        String url = V1Util.isNullOrEmpty(path) ? this.INSTANCE_URL + this._endpoint : this.INSTANCE_URL + this._endpoint + path;
        HttpPost httpPost = new HttpPost(url);
        String localeName = Locale.getDefault().toString();
        localeName = localeName.replace("_", "-");
        BasicHeader header = new BasicHeader("Accept-Language", localeName);
        BasicHeader header2 = new BasicHeader("Content-Type", contentType);
        httpPost.setHeaders((Header[])ArrayUtils.addAll(this.headerArray, new Header[]{header, header2}));
        return httpPost;
    }

    public String stringSendData(String data, String contentType) {
        String resultStream = null;
        StringEntity xmlPayload = null;
        this.httpPost = this.setPostHeader("", contentType);
        try {
            xmlPayload = new StringEntity(data);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.httpPost.setEntity(xmlPayload);
        if (!this.isWindowsAuth) {
            this.httpclient = this.httpclientBuilder.build();
        }
        try {
            this.httpResponse = this.httpclient.execute(this.httpPost);
            resultStream = IOUtils.toString(this.httpResponse.getEntity().getContent());
        }
        catch (IOException ex) {
            int code;
            try {
                code = this.httpResponse.getStatusLine().getStatusCode();
            }
            catch (Exception e1) {
                code = -1;
            }
            try {
                throw new ConnectionException("Error writing to output stream", code, ex);
            }
            catch (ConnectionException e) {
                e.printStackTrace();
            }
        }
        return resultStream;
    }

    public Reader sendData(String key, Object data, String contentType) {
        InputStreamReader resultStream = null;
        Object newData = null;
        AbstractHttpEntity xmlPayload = null;
        this.httpPost = this.setPostHeader(key, contentType);
        if (data instanceof byte[]) {
            newData = (byte[])data;
            xmlPayload = new ByteArrayEntity((byte[])newData);
            this.httpPost.setEntity(xmlPayload);
        } else if (data instanceof String) {
            newData = (String)data;
            try {
                xmlPayload = new StringEntity((String)newData);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            this.httpPost.setEntity(xmlPayload);
        }
        if (!this.isWindowsAuth) {
            this.httpclient = this.httpclientBuilder.build();
        }
        try {
            this.httpResponse = this.httpclient.execute(this.httpPost);
            resultStream = new InputStreamReader(this.httpResponse.getEntity().getContent());
        }
        catch (IOException ex) {
            int code;
            try {
                code = this.httpResponse.getStatusLine().getStatusCode();
            }
            catch (Exception e1) {
                code = -1;
            }
            try {
                throw new ConnectionException("Error writing to output stream", code, ex);
            }
            catch (ConnectionException e) {
                e.printStackTrace();
            }
        }
        return resultStream;
    }

    protected OutputStream beginRequest(String path, String contentType) throws ConnectionException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this._pendingStreams.put(path, outputStream);
        return outputStream;
    }

    protected InputStream endRequest(String path) throws ConnectionException {
        OutputStream os = this._pendingStreams.get(path);
        this._pendingStreams.remove(path);
        String ct = this._pendingContentTypes.get(path);
        this._pendingContentTypes.remove(path);
        byte[] data = ((ByteArrayOutputStream)os).toByteArray();
        this.sendData(path, data, ct);
        return null;
    }

    public void useMetaAPI() {
        this._endpoint = META_API_ENDPOINT;
    }

    public void useDataAPI() {
        this._endpoint = DATA_API_ENDPOINT;
    }

    public void useNewAPI() {
        this._endpoint = NEW_API_ENDPOINT;
    }

    public void useHistoryAPI() {
        this._endpoint = HISTORY_API_ENDPOINT;
    }

    public void useQueryAPI() {
        this._endpoint = QUERY_API_ENDPOINT;
    }

    public void useLocAPI() {
        this._endpoint = LOC_API_ENDPOINT;
    }

    public void useLoc2API() {
        this._endpoint = LOC2_API_ENDPOINT;
    }

    public void useConfigAPI() {
        this._endpoint = CONFIG_API_ENDPOINT;
    }

    public void useAttachmentApi() {
        this._endpoint = ATTACHMENT_API_ENDPOINT;
    }

    public void useEmbeddedApi() {
        this._endpoint = EMBEDDED_API_ENDPOINT;
    }

    static /* synthetic */ Header[] access$002(V1Connector x0, Header[] x1) {
        x0.headerArray = x1;
        return x1;
    }

    private static class Builder
    implements ISetUserAgentMakeRequest,
    IAuthenticationMethods,
    IsetProxyOrEndPointOrConnector,
    IsetProxyOrConnector,
    IsetEndPointOrConnector {
        private V1Connector v1Connector_instance;

        public Builder(String url) throws V1Exception, MalformedURLException {
            this.v1Connector_instance = new V1Connector(url);
        }

        @Override
        public IAuthenticationMethods withUserAgentHeader(String name, String version) throws V1Exception {
            if (V1Util.isNullOrEmpty(name) || V1Util.isNullOrEmpty(version)) {
                throw new NullPointerException("UserAgent header values cannot be null or empty.");
            }
            Package p = this.getClass().getPackage();
            String headerString = "Java/" + System.getProperty("java.version") + " " + p.getImplementationTitle() + "/" + p.getImplementationVersion();
            BasicHeader header = new BasicHeader("User-Agent", headerString);
            V1Connector.access$002(this.v1Connector_instance, (Header[])ArrayUtils.add(this.v1Connector_instance.headerArray, header));
            this.v1Connector_instance.isWindowsAuth = false;
            return this;
        }

        @Override
        public IsetProxyOrEndPointOrConnector withUsernameAndPassword(String username, String password) throws V1Exception {
            if (V1Util.isNullOrEmpty(username) || V1Util.isNullOrEmpty(username)) {
                throw new NullPointerException("Username and password values cannot be null or empty.");
            }
            this.v1Connector_instance.credsProvider.setCredentials(new AuthScope(this.v1Connector_instance.INSTANCE_URL.getHost(), this.v1Connector_instance.INSTANCE_URL.getPort()), new UsernamePasswordCredentials(username, password));
            this.v1Connector_instance.httpclientBuilder.setDefaultCredentialsProvider(this.v1Connector_instance.credsProvider);
            this.v1Connector_instance.isWindowsAuth = false;
            return this;
        }

        @Override
        public IsetProxyOrEndPointOrConnector withAccessToken(String accessToken) throws V1Exception {
            if (V1Util.isNullOrEmpty(accessToken)) {
                throw new NullPointerException("Access token value cannot be null or empty.");
            }
            BasicHeader header = new BasicHeader("Authorization", "Bearer " + accessToken);
            V1Connector.access$002(this.v1Connector_instance, (Header[])ArrayUtils.add(this.v1Connector_instance.headerArray, header));
            this.v1Connector_instance.isWindowsAuth = false;
            return this;
        }

        @Override
        public IsetProxyOrEndPointOrConnector withWindowsIntegrated() throws V1Exception {
            this.v1Connector_instance.httpclient = WinHttpClients.createDefault();
            this.v1Connector_instance.isWindowsAuth = true;
            return this;
        }

        @Override
        public IsetEndPointOrConnector withProxy(ProxyProvider proxyProvider) {
            if (null == proxyProvider) {
                throw new NullPointerException("ProxyProvider value cannot be null or empty.");
            }
            this.v1Connector_instance.credsProvider.setCredentials(new AuthScope(proxyProvider.getAddress().getHost(), proxyProvider.getAddress().getPort()), new UsernamePasswordCredentials(proxyProvider.getUserName(), proxyProvider.getPassword()));
            HttpHost proxy = new HttpHost(proxyProvider.getAddress().getHost(), proxyProvider.getAddress().getPort());
            this.v1Connector_instance.httpclientBuilder.setDefaultCredentialsProvider(this.v1Connector_instance.credsProvider).setProxy(proxy);
            this.v1Connector_instance.isWindowsAuth = false;
            return this;
        }

        @Override
        public IsetProxyOrConnector useEndpoint(String endpoint) {
            if (V1Util.isNullOrEmpty(endpoint)) {
                throw new NullPointerException("Endpoint value cannot be null or empty.");
            }
            this.v1Connector_instance._endpoint = endpoint;
            return this;
        }

        @Override
        public V1Connector build() {
            return this.v1Connector_instance;
        }
    }

    public static interface IBuild {
        public V1Connector build();
    }

    public static interface IProxy
    extends IBuild {
        public IBuild withProxy(ProxyProvider var1) throws V1Exception;
    }

    public static interface IAuthenticationMethods {
        public IsetProxyOrEndPointOrConnector withUsernameAndPassword(String var1, String var2) throws V1Exception;

        public IsetProxyOrEndPointOrConnector withWindowsIntegrated() throws V1Exception;

        public IsetProxyOrEndPointOrConnector withAccessToken(String var1) throws V1Exception;
    }

    public static interface ISetUserAgentMakeRequest {
        public IAuthenticationMethods withUserAgentHeader(String var1, String var2) throws V1Exception;
    }

    public static interface IsetProxyOrEndPointOrConnector
    extends IsetEndpoint,
    IBuild {
        public IsetEndPointOrConnector withProxy(ProxyProvider var1);
    }

    public static interface IsetEndPointOrConnector
    extends IBuild {
        public IBuild useEndpoint(String var1);
    }

    public static interface IsetProxyOrConnector
    extends IBuild {
        public IBuild withProxy(ProxyProvider var1);
    }

    public static interface IsetEndpoint {
        @Deprecated
        public IsetProxyOrConnector useEndpoint(String var1);
    }
}

