/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.gpg;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.gpg.AbstractGpgSigner;
import org.apache.maven.plugin.gpg.GpgSigner;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractGpgMojo
extends AbstractMojo {
    @Parameter(property="gpg.homedir")
    private File homedir;
    @Parameter(property="gpg.passphrase")
    private String passphrase;
    @Parameter(property="gpg.keyname")
    private String keyname;
    @Parameter(property="gpg.useagent", defaultValue="true")
    private boolean useAgent;
    @Parameter(defaultValue="${settings.interactiveMode}", readonly=true)
    private boolean interactive;
    @Parameter(property="gpg.executable")
    private String executable;
    @Parameter(property="gpg.defaultKeyring", defaultValue="true")
    private boolean defaultKeyring;
    @Parameter(property="gpg.secretKeyring")
    private String secretKeyring;
    @Parameter(property="gpg.publicKeyring")
    private String publicKeyring;
    @Parameter(property="gpg.lockMode")
    private String lockMode;
    @Parameter
    private List<String> gpgArguments;

    AbstractGpgSigner newSigner(MavenProject project) throws MojoExecutionException, MojoFailureException {
        GpgSigner signer = new GpgSigner(this.executable);
        signer.setLog(this.getLog());
        signer.setInteractive(this.interactive);
        signer.setKeyName(this.keyname);
        signer.setUseAgent(this.useAgent);
        signer.setHomeDirectory(this.homedir);
        signer.setDefaultKeyring(this.defaultKeyring);
        signer.setSecretKeyring(this.secretKeyring);
        signer.setPublicKeyring(this.publicKeyring);
        signer.setLockMode(this.lockMode);
        signer.setArgs(this.gpgArguments);
        signer.setPassPhrase(this.passphrase);
        if (null == this.passphrase && !this.useAgent) {
            if (!this.interactive) {
                throw new MojoFailureException("Cannot obtain passphrase in batch mode");
            }
            try {
                signer.setPassPhrase(signer.getPassphrase(project));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Exception reading passphrase", e);
            }
        }
        return signer;
    }
}

