/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.apiclient;

import com.versionone.apiclient.CookiesManager;
import com.versionone.apiclient.ProxyProvider;
import com.versionone.apiclient.exceptions.ConnectionException;
import com.versionone.apiclient.exceptions.SecurityException;
import com.versionone.apiclient.interfaces.IAPIConnector;
import com.versionone.apiclient.interfaces.ICookiesManager;
import com.versionone.utils.V1Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import sun.net.www.protocol.http.AuthCache;
import sun.net.www.protocol.http.AuthCacheImpl;
import sun.net.www.protocol.http.AuthCacheValue;

@Deprecated
public class V1APIConnector
implements IAPIConnector {
    private static final String UTF8 = "UTF-8";
    private final CookiesManager cookiesManager;
    private String _url = null;
    private ProxyProvider proxy = null;
    private final Map<String, HttpURLConnection> _requests = new HashMap<String, HttpURLConnection>();
    public final Map<String, String> customHttpHeaders = new HashMap<String, String>();
    private String _user_agent_header = "";
    private static String _app_name;
    private static String _app_version;

    public V1APIConnector(String url) {
        this(url, null, null, null);
    }

    public V1APIConnector(String url, ProxyProvider proxy) {
        this(url, null, null, proxy);
    }

    public V1APIConnector(String url, String userName, String password) {
        this(url, userName, password, null);
    }

    public V1APIConnector(String url, String userName, String password, ProxyProvider proxy) {
        this.proxy = proxy;
        this._url = url;
        this.cookiesManager = CookiesManager.getCookiesManager(url, userName, password);
        if (userName != null) {
            AuthCacheValue.setAuthCache((AuthCache)new AuthCacheImpl());
            Authenticator.setDefault(new Credentials(userName, password));
        }
        this.setUserAgentHeader(null, null);
    }

    public void setUserAgentHeader(String name, String version) {
        _app_name = name;
        _app_version = version;
        String header = "";
        Package p = this.getClass().getPackage();
        header = "Java/" + System.getProperty("java.version") + " " + p.getImplementationTitle() + "/" + p.getImplementationVersion();
        if (!V1Util.isNullOrEmpty(_app_name) && !V1Util.isNullOrEmpty(_app_version)) {
            header = header + " " + _app_name + "/" + _app_version;
        }
        this._user_agent_header = header;
    }

    public String getUserAgentHeader() {
        return this._user_agent_header;
    }

    public ICookiesManager getCookiesJar() {
        return this.cookiesManager;
    }

    @Override
    public Reader getData() throws ConnectionException {
        return this.getData("");
    }

    @Override
    public Reader getData(String path) throws ConnectionException {
        HttpURLConnection connection = this.createConnection(this._url + path);
        try {
            switch (connection.getResponseCode()) {
                case 200: {
                    this.cookiesManager.addCookie(connection.getHeaderFields());
                    return new InputStreamReader(connection.getInputStream(), UTF8);
                }
                case 401: {
                    throw new SecurityException();
                }
            }
            StringBuffer message = new StringBuffer("Received Error ");
            message.append(connection.getResponseCode());
            message.append(" from URL ");
            message.append(connection.getURL().toString());
            throw new ConnectionException(message.toString(), connection.getResponseCode());
        }
        catch (IOException e) {
            throw new ConnectionException("Error processing result from URL " + this._url + path, e);
        }
    }

    @Override
    public InputStream getAttachment(String attachmentKey) throws ConnectionException {
        HttpURLConnection connection = this.createConnection(this._url + attachmentKey);
        try {
            switch (connection.getResponseCode()) {
                case 200: {
                    this.cookiesManager.addCookie(connection.getHeaderFields());
                    return connection.getInputStream();
                }
                case 401: {
                    throw new SecurityException();
                }
            }
            StringBuffer message = new StringBuffer("Received Error ");
            message.append(connection.getResponseCode());
            message.append(" from URL ");
            message.append(connection.getURL().toString());
            throw new ConnectionException(message.toString(), connection.getResponseCode());
        }
        catch (IOException e) {
            throw new ConnectionException("Error processing result from URL " + this._url + attachmentKey, e);
        }
    }

    @Override
    public Reader sendData(String path, String data) throws ConnectionException {
        HttpURLConnection connection = this.createConnection(this._url + path);
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "text/xml");
        OutputStreamWriter stream = null;
        InputStream resultStream = null;
        try {
            connection.setRequestMethod("POST");
            stream = new OutputStreamWriter(connection.getOutputStream(), UTF8);
            stream.write(data);
            stream.flush();
            resultStream = connection.getInputStream();
            this.cookiesManager.addCookie(connection.getHeaderFields());
        }
        catch (IOException e) {
            int code;
            try {
                code = connection.getResponseCode();
            }
            catch (Exception e1) {
                code = -1;
            }
            throw new ConnectionException("Error writing to output stream", code, e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
        return new InputStreamReader(resultStream);
    }

    @Override
    public OutputStream beginRequest(String path, String contentType) throws ConnectionException {
        OutputStream outputStream = null;
        HttpURLConnection req = this.createConnection(this._url + path);
        if (contentType != null) {
            try {
                req.setDoOutput(true);
                req.setDoInput(true);
                req.setUseCaches(false);
                req.setRequestProperty("Content-Type", contentType);
                req.setRequestMethod("POST");
                outputStream = req.getOutputStream();
            }
            catch (IOException e) {
                req.disconnect();
                throw new ConnectionException("Error writing to output stream", e);
            }
        }
        this._requests.put(path, req);
        return outputStream;
    }

    @Override
    public InputStream endRequest(String path) throws ConnectionException {
        InputStream resultStream = null;
        HttpURLConnection req = this._requests.remove(path);
        try {
            if (req.getDoOutput()) {
                OutputStream writeStream = req.getOutputStream();
                writeStream.flush();
            }
            resultStream = req.getInputStream();
            this.cookiesManager.addCookie(req.getHeaderFields());
        }
        catch (IOException e) {
            try {
                throw new ConnectionException("Error writing to output stream", req.getResponseCode(), e);
            }
            catch (IOException e1) {
                throw new ConnectionException("Error writing to output stream", e);
            }
        }
        return resultStream;
    }

    private HttpURLConnection createConnection(String path) throws ConnectionException {
        HttpURLConnection request;
        try {
            URL url = new URL(path);
            if (this.proxy == null) {
                request = (HttpURLConnection)url.openConnection();
            } else {
                request = (HttpURLConnection)url.openConnection(this.proxy.getProxyObject());
                this.proxy.addAuthorizationToHeader(request);
            }
            String localeName = Locale.getDefault().toString();
            localeName = localeName.replace("_", "-");
            request.setRequestProperty("Accept-Language", localeName);
            request.setRequestProperty("User-Agent", this._user_agent_header);
            this.cookiesManager.addCookiesToRequest(request);
            this.addHeaders(request);
        }
        catch (MalformedURLException e) {
            throw new ConnectionException("Invalid URL", e);
        }
        catch (IOException e) {
            throw new ConnectionException("Error Opening Connection", e);
        }
        return request;
    }

    private void addHeaders(HttpURLConnection request) {
        for (String key : this.customHttpHeaders.keySet()) {
            request.setRequestProperty(key, this.customHttpHeaders.get(key));
        }
    }

    private class Credentials
    extends Authenticator {
        PasswordAuthentication _value;

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return this._value;
        }

        Credentials(String userName, String password) {
            this._value = null == password ? new PasswordAuthentication(userName, "".toCharArray()) : new PasswordAuthentication(userName, password.toCharArray());
        }

        public String toString() {
            return this._value.getUserName() + ":" + String.valueOf(this._value.getPassword());
        }
    }
}

