#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import time, sys, datetime
from com.versionone.apiclient import V1Connector
from com.versionone.apiclient import Services
from com.versionone.apiclient import Query
from com.versionone import Oid

from versionone import add_plan_record
from versionone import convert_to_datetime
from versionone.VersionOneClient import VersionOneClient
from versionone.ListItemValues import ListItemValues

global versionOneServer, resource, taskReportingApi, task

print ("create issue.")
if versionOneServer is None:
    print("No VersionOne server provided.")
    sys.exit(1)

#conn = V1Connector()
#connector = conn.withInstanceUrl(versionOneServer['url']).withUserAgentHeader("XL Release", str(time.time())).withAccessToken(
connector = V1Connector.withInstanceUrl(versionOneServer['url']).withUserAgentHeader("XL Release", str(time.time())).withAccessToken(

    versionOneServer['accessToken']).build()
services = Services(connector)
v1Client = VersionOneClient.create_v1Client( versionOneServer )
listItems = ListItemValues()
data = {}
print("Received projectId=%s") %projectId
project_id = services.getOid(projectId)
print("project_id=%s, asset type=%s") % (project_id, assetType)

story_type = services.getMeta().getAssetType(assetType)
print("story_type=%s") % story_type
new_story = services.createNew(story_type, project_id)
print("new_story=%s") %new_story

#CoC data
title = ""
versonOneServerUrl = versionOneServer['url']
asset_type = assetType
ticket = ""
asset_url = ""
updatedDate = datetime.datetime.now()
updatedBy = versionOneServer['username']

for key, value in attributes.iteritems():
    print("key=%s, value=%s") %(key, value)
    if key == 'Tags' :
        key = "TaggedWith";

    attribute_definition = story_type.getAttributeDefinition(key)
    if(key == 'Name'):
        title = value
    if(attribute_definition.isMultiValue()):
        if value.count(",") > 0:
            numberVal = value.split(",")
            print("key=%s, MultiValue=%s") %(key,numberVal)
            for numberValValue in numberVal:
                numberValValue = numberValValue.strip()
                if numberValValue in listItems.oids :
                    oid = listItems.oids[numberValValue]
                    new_story.addAttributeValue(attribute_definition, oid)
                else:
                    if numberValValue.count(":") > 0 :
                        oid = Oid.fromToken(numberValValue, services.getMeta())
                        new_story.addAttributeValue(attribute_definition, oid)
                    else :
                        new_story.addAttributeValue(attribute_definition, numberValValue)
        else:
            if value in listItems.oids:
                oid = listItems.oids[value]
                new_story.addAttributeValue(attribute_definition, oid)
            else:
                if value.count(":") > 0 :
                    oid = Oid.fromToken(value, services.getMeta())
                    new_story.addAttributeValue(attribute_definition, oid)
                else :
                    new_story.addAttributeValue(attribute_definition, value)
    elif(v1Client.get_list_item_type(key)):
        token = ""
        if(key == "Priority"):
            token = "Workitem"+v1Client.get_list_item_type(key)
        elif(key == "Status"):
            token = "Story"+v1Client.get_list_item_type(key)
        else:
            token = v1Client.get_list_item_type(key)
        asstType = services.getMeta().getAssetType(token)
        newAsset = services.createNew(asstType, project_id)
        newAsset.setAttributeValue(asstType.getAttributeDefinition("Name"), value)
        if value.count(":") > 0 :
            newAsset.setOid(Oid.fromToken(value, services.getMeta()))
        else:
            newAsset.setOid(Oid.fromToken(listItems.oids[key+value], services.getMeta()))
        new_story.setAttributeValue(attribute_definition, newAsset.getOid())
    else:
        new_story.setAttributeValue(attribute_definition, value)

services.save(new_story)



_storyType = services.getMeta().getAssetType(assetType)
_query = Query(new_story.getOid())
_nameAttribute = _storyType.getAttributeDefinition("Name")
_numberAttribute = _storyType.getAttributeDefinition("Number")

_createDateAttribute = _storyType.getAttributeDefinition("CreateDate")
_createdByAttribute = _storyType.getAttributeDefinition("CreatedBy")

_query.getSelection().add(_nameAttribute)
_query.getSelection().add(_numberAttribute)
_query.getSelection().add(_createDateAttribute)
_query.getSelection().add(_createdByAttribute)

_result = services.retrieve(_query)
_story = _result.getAssets()[0]

_story_name = _story.getAttribute(_nameAttribute).value
_story_number = _story.getAttribute(_numberAttribute).value
_story_create_date_str = str(_story.getAttribute(_createDateAttribute).value)
_story_create_date = convert_to_datetime(_story_create_date_str)
_story_created_by = str(_story.getAttribute(_createdByAttribute).value)

_memberData = _story_created_by.split(":")
_memberId = _memberData[1]

# data = {}
# v1Client = VersionOneClient.create_v1Client(versionOneServer)
# whereClause="/'%s'" % "20"
# results = v1Client.getMember( whereClause )
# asset = results['Assets'][0]
# print("asset=%s") % asset
# data['Name'] = asset['Attributes']['Name']['value']
# data['Username'] = asset['Attributes']['Username']['value']
# data['Email'] = asset['Attributes']['Email']['value']
# print("data=%s" % data)


print("story number=%s, story name=%s, story create date=%s, story created by=%s") %(_story_number, _story_name, _story_create_date, _story_created_by)

print("new_story oid=%s, new_story=%s") %(new_story.getOid(), new_story)
token = new_story.getOid().getToken()
assetnumber = _story_number


ticket = ""
title = ""
ticketType = ""
ticketUrl = ""
updatedDate = datetime.datetime.now()
updatedBy = versionOneServer['username']


if not (token is None):
    data["Token"] = token
    data["AssetNumber"] = assetnumber
    print("Story token: [%s]\n" % token)
    print(data)
    tokenData = token.split(":")
    asset_type = tokenData[0]
    asset_oid = tokenData[1]
    asset_url = versonOneServerUrl + "/story.mvc/Summary?oidToken=" + asset_type + "%3A" + asset_oid
    print("asset_type=%s, asset_oid=%s, ticket_url=%s") %(asset_type, asset_oid, asset_url)

    for key, value in attributes.iteritems():
        print("Attribute key [%s] with value [%s]\n" % (key, value))

    add_plan_record(task_reporting_api=taskReportingApi, task=task,
                    versionOneServer=versionOneServer, ticket=_story_number,
                    title=_story_name, ticketType=asset_type, ticketUrl=asset_url, status="PASSED",
                    updatedDate=_story_create_date, updatedBy=_story_created_by)
else:
    add_plan_record(task_reporting_api=taskReportingApi, task=task,
                    versionOneServer=versionOneServer, ticket=ticket,
                    title=title, ticketType=asset_type, ticketUrl="Not Available", status="FAILED",
                    updatedDate=updatedDate, updatedBy=updatedBy)
