/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.apiclient.services;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ValueStringizer {
    private final String valueWrapper;

    public ValueStringizer() {
        this("'");
    }

    public ValueStringizer(String valueWrapper) {
        this.valueWrapper = valueWrapper;
    }

    public String stringize(Object value) {
        String valueString = value != null ? ValueStringizer.format(value) : "";
        valueString = valueString.replace("'", "''").replace("\"", "\"\"");
        try {
            valueString = URLEncoder.encode(valueString, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            valueString = valueString.replace("+", "%2B");
            valueString = valueString.replace(" ", "+");
            valueString = valueString.replace("&", "%26");
            valueString = valueString.replace("#", "%23");
        }
        return String.format("%1$s%2$s%1$s", this.valueWrapper, valueString);
    }

    private static String format(Object value) {
        if (value instanceof Date) {
            Date date = (Date)value;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            return dateFormat.format((Object)date);
        }
        return value.toString();
    }
}

