#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import sys
import urllib2
import base64
import com.xebialabs.xlrelease.plugin.topaz.RemoteScript as RemoteScript
import com.xebialabs.xlrelease.script.EncryptionHelper as EncryptionHelper


class APIClient:

    def __init__(self, topaz_client_config):
        host = None
        isUnix = False
        hostSelected = topaz_client_config.get('clientHost')
        print ("Host Selected is: %s " % (hostSelected))
        if hostSelected == "Windows":
            host = topaz_client_config.get('windowsClientHost')
        else:
            host = topaz_client_config.get('unixClientHost')
            isUnix = True

        EncryptionHelper.decrypt(host)
        self.remote = RemoteScript(host)
        self.oc_path = topaz_client_config.get('topazPath')

    def runtest(self, config, project, scenario, targetencoding, jcl):
        isUnix = False if config.get('windowsClientHost') else True
        cmd = 'TotalTestCLI.sh' if isUnix else 'TotalTestCLI.bat'
        pathSep = "/" if isUnix else "\\"
        command = '"{}"{}{}'.format(self.oc_path, pathSep, cmd)
        command = ' {} -cmd="{}"'.format(command, "runtest")
        command = ' {} -h="{}"'.format(command, config.get('serverUrl'))
        command = ' {} -pt="{}"'.format(command, config.get("serverPort"))

        if config.get('encryptprotocol'):
            command = ' {} -encryptprotocol="{}"'.format(command, config.get('encryptprotocol'))

        command = ' {} -u="{}"'.format(command, config.get('username'))
        command = ' {} -pw="{}"'.format(command, config.get('password'))
        command = ' {} -p="{}"'.format(command, project)
        command = ' {} -ts="{}"'.format(command, scenario)
        command = ' {} -te="{}"'.format(command, targetencoding)
        command = ' {} -j="{}"'.format(command, jcl)

        print("Run command: %s" %(command))
        response = self.remote.executeScript(command)
        APIClient.print_logs(response)
        self.remote.cleanOutputHandlers()
        return response

    def logout(self):
        self.remote.cleanOutputHandlers()
        response = self.remote.executeScript('{}'.format('{} {}'.format(self.oc_path, 'logout')))
        APIClient.print_logs(response)

    def execute_topaz_command(self, command, cmd_params=None, process_exit=True):
        response = self.remote.executeScript('{} {} {}'.format(self.oc_path, command, cmd_params if cmd_params else ''))
        APIClient.print_logs(response, process_exit)
        return response

    def execute_topaz_command_only(self, command, cmd_params=None):
        response = self.remote.executeScript('{} {} {}'.format(self.oc_path, command, cmd_params if cmd_params else ''))
        return response

    def execute_command(self, command):
        response = self.remote.executeScript(command)
        APIClient.print_logs(response)
        return response

    @staticmethod
    def download_file(url, username, password):
        request = urllib2.Request(url)
        if (username is not None) and (password is not None):
            base64string = base64.encodestring('{}:{}'.format(username, password))[:-1]
            auth_header = "Basic {}".format(base64string)
            request.add_header("Authorization", auth_header)

        return urllib2.urlopen(request).read()

    @staticmethod
    def add_comment(comment):
        print "```"
        print comment
        print "```"

    @staticmethod
    def print_logs(response, process_exit=True):
        output = response.stdout
        error = response.stderr
        if response.rc == 0:
            print "```"
            print output
            print "```"
        else:
            print "Exit code: "
            print response.rc
            print
            print "#### Output:"
            print "```"
            print output
            print "```"

            print "----"
            print "#### Error stream:"
            print "```"
            print error
            print "```"
            print

            if process_exit:
                sys.exit(response.rc)
