#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

import requests
import org.slf4j.LoggerFactory as LoggerFactory

logger = LoggerFactory.getLogger("Teamforge")

# New Teamforge logic
# setup the request url
api_token_endpoint = "/oauth/auth/token"
url = configuration.url + "%s" % api_token_endpoint
scope="scope=urn:ctf:services:ctf urn:ctf:services:svn urn:ctf:services:gerrit urn:ctf:services:soap60"
grant_type = "grant_type=password"
client_id = "client_id=api-client"
username = "username=%s" % configuration.username
password = "password=%s" % configuration.password

# setup the request payload and headers
payload = grant_type + "&" + username + "&" + password + "&" + client_id + "&" + scope
headers = {
    'Content-Type': "application/x-www-form-urlencoded"
}

# send post request to services/oauth2/token endpoint
logger.error('Testing the Teamforge Server configuration...')
logger.error('Oauth2 url address is %s' % url)
logger.error('username: %s' % configuration.username)
logger.error('password: %s' % configuration.password)
logger.error('payload: %s' % payload)
logger.error('right before my actual request call')
r = requests.post(url, data=payload, headers=headers, verify=False)

logger.error('after post call - request call was successful.')

# check for good response
logger.info('Http Response code is %s' % r.status_code)
if r.status_code != 200:
    logger.error('response error code: %s' % r.status_code)
    logger.error('response error reason: %s' % r.reason)
    raise Exception(
        "Failed to connect to TeamForge Server. Reason: %s" % r.reason
    )
else:
    logger.error('Teamforge auth token: %s' % r.text)