#
# Copyright (c) 2019. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
import java
import sys
import yaml


class TaskHelper(object):

    @staticmethod
    def add_comment(comment):
        print "```"
        print comment
        print "```"

    @staticmethod
    def convert_to_datetime(from_date):
        # https://docs.python.org/2/library/datetime.html#strftime-strptime-behavior
        # return datetime.strptime(from_date, '%Y-%m-%dT%H:%M:%S%Z')
        sdf = java.text.SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ")
        return sdf.parse(from_date)

    @staticmethod
    def numbers_to_rating(rating):
        switcher = {
            1: "A",
            2: "B",
            3: "C",
            4: "D",
            5: "E"
        }
        return switcher.get(int(rating), None)

    @staticmethod
    def convert_metric_value(value, metric_type):
        if metric_type == "PERCENT":
            return "{}%".format(round(float(value), 2))
        elif metric_type == "RATING":
            return TaskHelper.numbers_to_rating(value)
        else:
            return value

    @staticmethod
    def add_code_compliance_facet(facet_api, task, sonar_server, project=None, project_url=None,
                                  outcome=None, compliance_data=None, analysis_date=None):
        try:
            facet = facet_api.newFacet("udm.CodeComplianceFacet")
            facet.targetId = task.id
            facet.serverUrl = sonar_server['url']
            facet.serverUser = sonar_server['username']
            facet.project = project
            facet.project_url = project_url
            facet.outcome = outcome
            facet.complianceData = yaml.dump(compliance_data, default_flow_style=False)
            facet.analysisDate = TaskHelper.convert_to_datetime(analysis_date)
            facet_api.createFacet(facet)
        except:
            exctype, value = sys.exc_info()[:2]
            print("{} occurred while creating `udm.CodeComplianceFacet` - {}".format(exctype, value))
