#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
import json
import org.apache.http.conn.HttpHostConnectException

from datetime import datetime
from xlrelease.HttpRequest import HttpRequest

PAGE_SIZE = 500

class SonarApiService(object):

    @staticmethod
    def format_sonar_api_date(date):
        return datetime.fromtimestamp(date / 1000.0).strftime('%Y-%m-%d')

    @staticmethod
    def get_data_by_path(sonar_server, api_path):
        http_request = HttpRequest(sonar_server)
        sonar_response = http_request.get(api_path)
        if sonar_response.isSuccessful():
            json_data = json.loads(sonar_response.getResponse())
            return json_data
        else:
            error = json.loads(sonar_response.getResponse())
            print error
            return {'error': error['errors']}

    @staticmethod
    def get_search_history(sonar_server, date_from_str, date_to_str, resource, metrics, page_number):
        search_history_api_url = "/api/measures/search_history?component={}&ps={}&p={}&from={}&to={}&metrics={}".format(
            resource, PAGE_SIZE, page_number, date_from_str, date_to_str, ','.join(metrics.keys()))
        return SonarApiService.get_data_by_path(sonar_server, search_history_api_url)

    @staticmethod
    def get_project_analyses(sonar_server, date_from_str, date_to_str, resource, page_number):
        project_analyses_api_url = "/api/project_analyses/search?project={}&p={}&ps={}&from={}&to={}&category=VERSION".format(
            resource, page_number, PAGE_SIZE, date_from_str, date_to_str)
        return SonarApiService.get_data_by_path(sonar_server, project_analyses_api_url)

    @staticmethod
    def paginate_sonar_request(request_func, filter_func):
        try:
            data = {'data': []}
            page = 1
            while page:
                sonar_response = request_func(page)
                data.get('data').extend(filter_func(sonar_response))
                if sonar_response.get("paging").get("total") <= page * PAGE_SIZE:
                    page=False
                else:
                    page+=1
        except org.apache.http.conn.HttpHostConnectException as e:
            print "Connection Failed : {0} ".format(str(e))
            data = {'error': [{'msg': e.getMessage()}]}
        return data
