#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from xlrelease.HttpRequest import HttpRequest
import json

sonar_server = securityApi.decrypt(configurationApi.getConfiguration(request.query['serverId']))

params = {'url': sonar_server.url, 'username': sonar_server.username, 'password': sonar_server.password,
          'proxyHost': sonar_server.proxyHost, 'proxyPort': sonar_server.proxyPort,
          'proxyUsername': sonar_server.proxyUsername, 'proxyPassword': sonar_server.proxyPassword}

http_request = HttpRequest(params)
sonar_response = http_request.get('/api/metrics/search?ps=999')
if sonar_response.isSuccessful():
    json_data = json.loads(sonar_response.getResponse())
    result={}
    for metric in json_data['metrics']:
        if not metric['hidden'] and not metric['custom']:
            result[metric['key']]=metric['name']
    response.entity = result
else:
    error = json.loads(sonar_response.getResponse())
    if 'Invalid table' in error['error']['message']:
        print "Invalid Table Name"
        data = {"Invalid table name"}
        sonar_response.errorDump()
    else:
        print "Failed to run query in Sonar"
        sonar_response.errorDump()
    sys.exit(1)


