from sonar.task import SonarService

if not sonarServer:
    raise Exception("Sonar server ID must be provided")

response = SonarService.get_project_metrics(sonarServer, resource)

project_status = response['projectStatus']['status']

SonarService.add_comment("Project Status : {}".format(project_status))
SonarService.add_comment("Analysis Date : {}".format(SonarService.get_analysis_date(sonarServer, resource)))

metrics = SonarService.get_sonar_metrics(sonarServer)

status = ""
if len(response['projectStatus']['conditions']) > 0:
    response['projectStatus']['conditions'] = sorted(response['projectStatus']['conditions'],
                                                     key=lambda condition: metrics[condition['metricKey']]['name'])
    status = "| Metric         |      Value       |  Threshold    |   Status  | \n"
    status += "|--------------- |:----------------:|:--------------:|:-------------:| \n"

for item in response['projectStatus']['conditions']:
    status += '|' + metrics[item['metricKey']]['name'] + '|' + item['actualValue'] + '|'\
              + (item['errorThreshold'] if 'errorThreshold' in item else '-') + '|' + \
              item['status'] + '| \n'

print status

if project_status == 'ERROR' or project_status == 'NONE':
    raise Exception("Code compliance check(s) failed")

print "Code compliance checks verified."
