import json
from xlrelease.HttpRequest import HttpRequest
import org.apache.http.conn.HttpHostConnectException;
from sonar.task import SonarService

if not sonarServer:
    raise Exception("Sonar server ID must be provided")

try:
    sonar_url = sonarServer['url']
    sonar_server_api_url = '/api/measures/component?componentKey=%s&metricKeys=%s' % (
    resource, ','.join(metrics.keys()))
    http_request = HttpRequest(sonarServer)
    sonar_response = http_request.get(sonar_server_api_url)
    if sonar_response.isSuccessful():
        json_data = json.loads(sonar_response.getResponse())
        data1 = {}
        data1['id'] = json_data['component']['id']
        data1['key'] = json_data['component']['key']
        data1['name'] = json_data['component']['name']
        data1['analysisDate'] = SonarService.get_analysis_date(sonarServer, resource)
        data1['sonarUrl'] = sonar_url
        for item in json_data['component']['measures']:
            data1[item['metric']] = item['value'] if 'value' in item else '-'
        data = data1
    else:
        error = json.loads(sonar_response.getResponse())
        print error
        data = {'error': error['errors']}
except org.apache.http.conn.HttpHostConnectException as e:
    print "Connection Failed : {0} ".format(str(e))
    data = {'error': [{'msg': e.getMessage()}]}
