#
# Copyright (c) 2019. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import json
from sonar import SonarApiService
global sonarServer, resource

if not sonarServer:
    raise Exception("Sonar server ID must be provided")

sonar_response = SonarApiService.search_project_analysis(sonarServer, resource, branch, pullRequest)

if not sonar_response.isSuccessful():
    raise Exception("Failed to get Sonarqube data. Server return [%s], with content [%s]" % (sonar_response.status, sonar_response.response))
json_data = json.loads(sonar_response.getResponse())
event_key = None
analysis_key = json_data["analyses"][0]["key"]
for event in json_data["analyses"][0]["events"]:
    if event["category"] == "VERSION":
        event_key = event["key"]

if event_key is not None:
    sonar_response = SonarApiService.updateEvent(sonarServer, event_key, version)
    if not sonar_response.isSuccessful():
        raise Exception("Failed to get Sonarqube data. Server return [%s], with content [%s]" % (sonar_response.status, sonar_response.response))
    print ("Updated Latest analysis version !! version=%s" % version)
else:
    sonar_response = SonarApiService.createEvent(sonarServer, analysis_key, version)
    if not sonar_response.isSuccessful():
        raise Exception("Failed to get Sonarqube data. Server return [%s], with content [%s]" % (sonar_response.status, sonar_response.response))
    print ("Created Latest analysis version !! version=%s" % version)