#
# Copyright (c) 2019. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import json
from sonar import SonarApiService
global sonarServer, resource

if not sonarServer:
    raise Exception("Sonar server ID must be provided")

response = SonarApiService.get_sonar_blocking_violation_metrics(sonarServer, resource, branch, pullRequest)

if response.status != 200:
    error = json.loads(response.getResponse())
    print ("Failed to retrieve metrics. Error : %s" % error)
    sys.exit(1)

json_data = json.loads(response.getResponse())

metrics_data = {}
for item in json_data['component']['measures']:
    metrics_data[item['metric']] = item['value']

blocker_violations = int(metrics_data.get('blocker_violations', 0))
critical_violations = int(metrics_data.get('critical_violations',0))
major_violations = int(metrics_data.get('major_violations', 0))

print "Metrics: blocker_violations=%s, critical_violations=%s, major_violations=%s" % (blocker_violations, critical_violations,
major_violations)

#
# blocker_violations 0
# critical_violations 0
# major_violations 0

if blockerViolations > -1 and blocker_violations > blockerViolations:
    print ("Failed because of blocker violations. Number of blocker violations: %s" % blocker_violations)
    sys.exit(1)
if criticalViolations > -1 and critical_violations > criticalViolations:
    print ("Failed because of critical violations. Number of critical violations: %s" % critical_violations)
    sys.exit(1)
if majorViolations > -1 and major_violations > majorViolations:
    print ("Failed because of major violations. Number of major violations: %s" % major_violations)
    sys.exit(1)
print ("Success! violations are in acceptable range")

