#
# Copyright (c) 2019. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import json
from sonar import SonarApiService

global sonarServer, resource

if not sonarServer:
    raise Exception("Sonar server ID must be provided")

response = SonarApiService.get_sonar_component_metrics(sonarServer, resource, branch, pullRequest)

if not response.isSuccessful():
    print ("Failed to get Sonar Measures. Server return [%s], with content [%s]" % (response.status, response.response))
    sys.exit(1)
json_data = json.loads(response.getResponse())
data = {}
for item in json_data['component']['measures']:
    data[item['metric']] = item['value']
error_message = ""
if lineCoverage > -1 and 'line_coverage' in data and lineCoverage > float(data["line_coverage"]):
    error_message += "+ Did not meet line coverage requirement. Received %s\n" % data["line_coverage"]
if complexity > -1 and 'complexity' in data and complexity < int(data["complexity"]):
    error_message += "+ Did not meet complexity requirement. Received %s\n" % data["complexity"]
if duplicatedLinesDensity > -1 and 'duplicated_lines_density' in data and duplicatedLinesDensity < float(data["duplicated_lines_density"]):
    error_message += "+ Did not meet duplicated lines density requirement. Received %s\n" % data["duplicated_lines_density"]
if violations > -1 and 'violations' in data and violations < int(data["violations"]):
    error_message += "+ Did not meet violations requirement. Received %s\n" % data["violations"]
if error_message:
    print ("Failed Code quality verifications:\n%s" % error_message)
    sys.exit(1)

print "Successfully verified code quality. Metrics are in the acceptable range"
