#
# Copyright (c) 2019. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from sonar import SonarApiService
from sonar.task import TaskHelper

global sonarServer, resource, taskReportingApi, task

if not sonarServer:
    raise Exception("Sonar server ID must be provided")

response = SonarApiService.get_project_metrics(sonarServer, resource)

project_status = response['projectStatus']['status']

analysis_date = SonarApiService.get_analysis_date(sonarServer, resource)

TaskHelper.add_comment("Project Status : {}".format(project_status))
TaskHelper.add_comment("Analysis Date : {}".format(analysis_date))

metrics = SonarApiService.get_sonar_metrics(sonarServer)

compliance_data = {}
status = ""
if len(response['projectStatus']['conditions']) > 0:
    response['projectStatus']['conditions'] = sorted(response['projectStatus']['conditions'],
                                                     key=lambda condition: metrics[condition['metricKey']]['name'])
    status = "| Metric         |      Value       |  Threshold    |   Status  | \n"
    status += "|--------------- |:----------------:|:--------------:|:-------------:| \n"

for item in response['projectStatus']['conditions']:
    metric_type = metrics[item['metricKey']]['type']
    value = TaskHelper.convert_metric_value(value=item['actualValue'], metric_type=metric_type)
    error_threshold = TaskHelper.convert_metric_value(value=item['errorThreshold'],
                                                      metric_type=metric_type) if 'errorThreshold' in item else '-'

    status += '|' + metrics[item['metricKey']]['name'] + '|' + value + '|' \
              + error_threshold + '|' + \
              item['status'] + '| \n'

    compliance_data[str(metrics[item['metricKey']]['name'])] = {
        "Value": str(value),
        "Threshold": str(error_threshold),
        "Status": str(item['status'])
    }

print status
print "\n"

project_url = "{}/dashboard?id={}".format(sonarServer['url'].strip('/'), resource)
outcome = "PASSED" if project_status == "OK" else "FAILED"

TaskHelper.add_code_compliance_record(task_reporting_api=taskReportingApi, task=task,
                                      sonar_server=sonarServer, project=resource,
                                      project_url=project_url, outcome=outcome,
                                      compliance_data=compliance_data, analysis_date=analysis_date)

if project_status == 'ERROR' or project_status == 'NONE':
    raise Exception("Code compliance check(s) failed")

print "Code compliance checks verified."
