#
# Copyright (c) 2019. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#

from servicenow import get_deep_link_url, add_code_compliance_record
from servicenow.client.ServiceNowClient import ServiceNowClient

import datetime

class ServiceNowCheckStatusClient(object):

    def __init__(self, task_vars, task_reporting_api, task):
        self.table_name = task_vars['tableName']
        self.task_vars = task_vars
        self.task_reporting_api = task_reporting_api
        self.task = task

    def process(self, data):
        add_code_compliance_record(table_name=self.table_name,
                                   task_reporting_api=self.task_reporting_api,
                                   task=self.task,
                                   service_now_server=self.task_vars['servicenowServer'],
                                   service_now_user=self.task_vars['username'],
                                   data=data,
                                   url=get_deep_link_url(servicenowServer['url'], self.table_name, data['sys_id']))


def parseWaitInputs(task_vars):
    try:
        if not task_vars['overrideServerWaitConfig']:
            servicenowServer = task_vars['servicenowServer']
            waitProgressionType = servicenowServer['waitProgressionType']
            maxTries = servicenowServer['maxTries']
            waitInterval = servicenowServer['waitInterval']
            waitIntervalIncrease = servicenowServer['waitIntervalIncrease']
            waitCustomList = servicenowServer['waitCustomList']
        else:
            waitProgressionType = task_vars['waitProgressionType']
            maxTries = task_vars['maxTries']
            waitInterval = task_vars['waitInterval']
            waitIntervalIncrease = task_vars['waitIntervalIncrease']
            waitCustomList = task_vars['waitCustomList']

        if waitProgressionType == "Exponential":
            return (maxTries, int(((float(waitIntervalIncrease)) ** numTries) * waitInterval))

        if waitProgressionType == "Custom list":
            waitKeyValueList = [{'tries': int((item.split(',')[0])), 'wait' : int(item.split(',')[1])} for item in waitCustomList]
            for entry in waitKeyValueList:
                if numTries <= entry['tries']:
                    return (max([item['tries'] for item in waitKeyValueList]), entry['wait'])
    except:
        print "Error in input properties\n"
        sys.exit(1)

if numTries:
    numTries = numTries + 1
else:
   numTries = 1

print "Attempt %d wait-for-status at %s\n" % (numTries, str(datetime.datetime.now()))

try:
    if not servicenowServer:
        print "ServiceNow server must be supplied\n"
        raise Exception
except:
    print "Error in input properties\n"
    sys.exit(1)

try:
    sn_client = ServiceNowClient.create_client(servicenowServer, username, password)
    query = "sys_id=%s" % sysId
    data = sn_client.query(tableName, query)
    status = data['%s' % (statusField)]
    task.setStatusLine("Current status is %s" % status)

    if status == checkForStatus:
        ticket = data['number']
        ServiceNowCheckStatusClient(locals(), task_reporting_api=taskReportingApi, task=task).process(data)
    else:
        (maxTries, nextWaitInterval) = parseWaitInputs(locals())
        if maxTries > 0 and numTries >= maxTries:
            print "Maximum number of attempts reached or exceeded\n"
            raise Exception
        else:
            task.schedule("servicenow/task/wait_for_status.py", nextWaitInterval)

except Exception, e:
    print "Error finding status for %s" % statusField
    sys.exit(1)
