#
# Copyright (c) 2019. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#

from servicenow import get_deep_link_url, add_code_compliance_record
from servicenow.client.ServiceNowClient import ServiceNowClient
from servicenow.helper.helper import assert_not_null
from servicenow.markdown.markdown_logger import MarkdownLogger as mdl


class ServiceNowRecordClient(object):

    def __init__(self, task_vars, task_reporting_api, task):
        self.table_name = task_vars['tableName']
        self.task_vars = task_vars
        self.task_reporting_api = task_reporting_api
        self.task = task
        assert_not_null(task_vars['servicenowServer'], "No server provided.")
        assert_not_null(task_vars['shortDescription'], "Short description is mandatory when creating a task.")
        self.sn_client = ServiceNowClient.create_client(task_vars['servicenowServer'], task_vars['username'],
                                                        task_vars['password'])
        if 'acceptanceCriteria' in self.task_vars.keys():
            assert_not_null(task_vars['acceptanceCriteria'], "Acceptance criteria are mandatory when creating a story.")

    def set_from_task_vars(self, source_name, target_object, target_name=None):
        if source_name in self.task_vars.keys() and self.task_vars[source_name]:
            if target_name is None:
                target_name = source_name
            target_object[target_name] = self.task_vars[source_name]

    def process_record(self):
        content = {}
        self.set_from_task_vars('shortDescription', content, 'short_description')
        self.set_from_task_vars('description', content)
        self.set_from_task_vars('assignmentGroup', content, 'assignment_group')
        self.set_from_task_vars('assignedTo', content, 'assigned_to')
        self.set_from_task_vars('priority', content)
        self.set_from_task_vars('state', content)
        self.set_from_task_vars('ciSysId', content, 'cmdb_ci')
        self.set_from_task_vars('comments', content, 'comments')

        self.set_from_task_vars('changeRequest', content, 'change_request')
        self.set_from_task_vars('workNotes', content, 'work_notes')
        self.set_from_task_vars('storyPoints', content, 'story_points')
        self.set_from_task_vars('epic', content, 'epic')
        self.set_from_task_vars('product', content)
        self.set_from_task_vars('sprint', content)
        self.set_from_task_vars('acceptanceCriteria', content, 'acceptance_criteria')
        self.set_from_task_vars('taskType', content, 'type')
        self.set_from_task_vars('plannedHours', content, 'planned_hours')
        self.set_from_task_vars('story', content)
        self.set_from_task_vars('impact', content)
        self.set_from_task_vars('urgency', content)

        # Also sending release info.
        content['x_xlbv_xl_release_identifier'] = str(release.id)
        content['x_xlbv_xl_release_state'] = str(release.status)

        for k, v in self.task_vars['additionalFields'].items():
            content[k] = v

        response = self.sn_client.create_record(self.table_name, content, getCurrentTask().getId())
        return response

    def print_links(self, sys_id, ticket, data):
        mdl.println("Created '{}' with sysId '{}' in Service Now. \n".format(ticket, sys_id))
        mdl.print_hr()
        mdl.print_header3("__Links__")
        url = get_deep_link_url(self.sn_client.service_now_url, self.table_name, sys_id)
        mdl.print_url("Record Form View", url)

    def process(self):
        response = self.process_record()
        sys_id = response['target_sys_id']
        data = self.sn_client.get_record(self.table_name, sys_id)
        self.print_links(sys_id, data['number'], data)

        add_code_compliance_record(table_name=self.table_name,
                                  task_reporting_api=self.task_reporting_api,
                                  task=self.task,
                                  service_now_server=self.task_vars['servicenowServer'],
                                  service_now_user=self.task_vars['username'],
                                  data=data,
                                  url=get_deep_link_url(self.sn_client.service_now_url, self.table_name, sys_id))

        return sys_id, data['number'], data


sysId, Ticket, data = ServiceNowRecordClient(locals(), task_reporting_api=taskReportingApi, task=task).process()
