/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.predictions.service;

import com.typesafe.config.Config;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.plugins.predictions.service.ModelsMetadata;
import com.xebialabs.xlrelease.plugins.predictions.service.ReleasePredictionService;
import com.xebialabs.xlrelease.plugins.predictions.service.package$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@Component
@DependsOn(value={"serviceStarter"})
@Autowired
@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u0001\u0003\u0001=\u0011\u0011\u0003\u0016:bS:LgnZ*dQ\u0016$W\u000f\\3s\u0015\t\u0019A!A\u0004tKJ4\u0018nY3\u000b\u0005\u00151\u0011a\u00039sK\u0012L7\r^5p]NT!a\u0002\u0005\u0002\u000fAdWoZ5og*\u0011\u0011BC\u0001\nq2\u0014X\r\\3bg\u0016T!a\u0003\u0007\u0002\u0013a,'-[1mC\n\u001c(\"A\u0007\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001\u0001b\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0003/qi\u0011\u0001\u0007\u0006\u00033i\tQa\u001d7gi)T\u0011aG\u0001\tOJL'P\u001f7fI&\u0011Q\u0004\u0007\u0002\b\u0019><w-\u001b8h\u0011!y\u0002A!A!\u0002\u0013\u0001\u0013!C:dQ\u0016$W\u000f\\3s!\t\ts%D\u0001#\u0015\ty2E\u0003\u0002%K\u0005A\u0001\u000f\\;nE&twM\u0003\u0002'\u0015\u0005AA-\u001a9m_fLG/\u0003\u0002)E\tI1k\u00195fIVdWM\u001d\u0005\tU\u0001\u0011\t\u0011)A\u0005W\u000511m\u001c8gS\u001e\u0004\"\u0001\f\u0018\u000e\u00035R!A\u000b\u0005\n\u0005=j#!\u0003-me\u000e{gNZ5h\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0014\u0001\u0007:fY\u0016\f7/\u001a)sK\u0012L7\r^5p]N+'O^5dKB\u00111\u0007N\u0007\u0002\u0005%\u0011QG\u0001\u0002\u0019%\u0016dW-Y:f!J,G-[2uS>t7+\u001a:wS\u000e,\u0007\"B\u001c\u0001\t\u0003A\u0014A\u0002\u001fj]&$h\b\u0006\u0003:umb\u0004CA\u001a\u0001\u0011\u0015yb\u00071\u0001!\u0011\u0015Qc\u00071\u0001,\u0011\u0015\td\u00071\u00013\u0011\u0015q\u0004\u0001\"\u0001@\u0003\u0011Ig.\u001b;\u0015\u0003\u0001\u0003\"!E!\n\u0005\t\u0013\"\u0001B+oSRD#!\u0010#\u0011\u0005\u0015SU\"\u0001$\u000b\u0005\u001dC\u0015AC1o]>$\u0018\r^5p]*\t\u0011*A\u0003kCZ\f\u00070\u0003\u0002L\r\ni\u0001k\\:u\u0007>t7\u000f\u001e:vGRDa!\u0014\u0001\u0005\u0002\tq\u0015!\u0005;sC&t\u0017I\u001c3M_\u001e,%O]8sgR\u0019\u0001iT-\t\u000bAc\u0005\u0019A)\u0002\u001b=\u0004H/[7ju\u0016,e/\u001a:z!\t\u0011v+D\u0001T\u0015\t!V+\u0001\u0005ekJ\fG/[8o\u0015\t1&#\u0001\u0006d_:\u001cWO\u001d:f]RL!\u0001W*\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\")!\f\u0014a\u0001#\u0006ar\u000e\u001d;j[&TX-\u00114uKJ4\u0015N]:u)J\f\u0017N\u001c#fY\u0006L\b\"\u0002/\u0001\t\u0013i\u0016\u0001\b3fG&$W-\u00134TQ>,H\u000eZ(qi&l\u0017N_3B]\u0012dun\u001a\u000b\u0005=\u0006|\u0007\u000f\u0005\u0002\u0012?&\u0011\u0001M\u0005\u0002\b\u0005>|G.Z1o\u0011\u0015\u00117\f1\u0001d\u0003AiW\r^1eCR\f'+Z:q_:\u001cX\rE\u0002eO&l\u0011!\u001a\u0006\u0003MJ\tA!\u001e;jY&\u0011\u0001.\u001a\u0002\u0004)JL\bcA\tkY&\u00111N\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005Mj\u0017B\u00018\u0003\u00059iu\u000eZ3mg6+G/\u00193bi\u0006DQ\u0001U.A\u0002ECQAW.A\u0002ECQA\u001d\u0001\u0005\nM\fQ\u0002\\8oO\u0016sw.^4i\u0003\u001e|Gc\u00010us\")Q/\u001da\u0001m\u0006IA/[7fgR\fW\u000e\u001d\t\u0003#]L!\u0001\u001f\n\u0003\t1{gn\u001a\u0005\u0006)F\u0004\r!\u0015\u0015\u0003\u0001m\u00042\u0001`A\u0007\u001b\u0005i(BA$\u007f\u0015\ry\u0018\u0011A\u0001\bM\u0006\u001cGo\u001c:z\u0015\u0011\t\u0019!!\u0002\u0002\u000b\t,\u0017M\\:\u000b\t\u0005\u001d\u0011\u0011B\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\u0011\u00111B\u0001\u0004_J<\u0017bAA\b{\nI\u0011)\u001e;po&\u0014X\r\u001a\u0015\b\u0001\u0005M\u0011\u0011EA\u0012!\u0011\t)\"!\b\u000e\u0005\u0005]!bA$\u0002\u001a)!\u00111DA\u0003\u0003\u001d\u0019wN\u001c;fqRLA!a\b\u0002\u0018\tIA)\u001a9f]\u0012\u001cxJ\\\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0003K\t#!a\n\u0002\u001dM,'O^5dKN#\u0018M\u001d;fe\"\u001a\u0001!a\u000b\u0011\t\u00055\u00121G\u0007\u0003\u0003_QA!!\r\u0002\u0006\u0005Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005U\u0012q\u0006\u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class TrainingScheduler
implements Logging {
    private final Scheduler scheduler;
    private final XlrConfig config;
    private final ReleasePredictionService releasePredictionService;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TrainingScheduler trainingScheduler = this;
        synchronized (trainingScheduler) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @PostConstruct
    public void init() {
        Config pluginConfig = this.config.getRootConfig().getConfig("xl.plugin.riskPredictions");
        Duration buildModelEvery = pluginConfig.getDuration("modelBuildPeriod");
        Duration initialDelay = pluginConfig.getDuration("modelBuildInitialDelay");
        Duration optimizeEvery = pluginConfig.getDuration("optimizeEvery");
        Duration optimizeAfterFirstTrainDelay = pluginConfig.getDuration("optimizeAfterFirstTrainDelay");
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Will start building prediction models every ", " after ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{buildModelEvery, initialDelay})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Optimization will be delayed by ", " and happen every ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{optimizeAfterFirstTrainDelay, optimizeEvery})));
        this.scheduler.scheduleAtFixedRate(() -> this.trainAndLogErrors(package$.MODULE$.JavaDuration(optimizeEvery).asScala(), package$.MODULE$.JavaDuration(optimizeAfterFirstTrainDelay).asScala()), initialDelay.toMillis(), buildModelEvery.toMillis(), TimeUnit.MILLISECONDS);
    }

    public void trainAndLogErrors(FiniteDuration optimizeEvery, FiniteDuration optimizeAfterFirstTrainDelay) {
        boolean shouldOptimize;
        boolean x$2 = shouldOptimize = this.decideIfShouldOptimizeAndLog(this.releasePredictionService.requestModelMetadata(), optimizeEvery, optimizeAfterFirstTrainDelay);
        boolean x$3 = this.releasePredictionService.train$default$1();
        Try<String> try_ = this.releasePredictionService.train(x$3, x$2);
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().error((Function0 & Serializable & scala.Serializable)() -> e.getMessage());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean decideIfShouldOptimizeAndLog(Try<Option<ModelsMetadata>> metadataResponse, FiniteDuration optimizeEvery, FiniteDuration optimizeAfterFirstTrainDelay) {
        Option option;
        Option option2;
        Some some;
        long lastOptimizeTs;
        Option option3;
        Some some2;
        long lastOptimizeTs2;
        Option option4;
        Tuple2 tuple2;
        Some some3;
        ModelsMetadata modelsMetadata;
        Try<Option<ModelsMetadata>> try_ = metadataResponse;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not get model metadata, but will try to train the models: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getMessage()})));
            return false;
        }
        if (!(try_ instanceof Success)) throw new MatchError(try_);
        Success success = (Success)try_;
        Option metadataOpt = (Option)success.value();
        Option option5 = metadataOpt;
        if (option5 instanceof Some && (modelsMetadata = (ModelsMetadata)(some3 = (Some)option5).value()) != null) {
            Option<Object> firstTrainTs = modelsMetadata.firstTrainTimestamp();
            Option<Object> lastOptimizeTs3 = modelsMetadata.lastOptimizeTimestamp();
            tuple2 = new Tuple2(firstTrainTs, lastOptimizeTs3);
        } else {
            if (!None$.MODULE$.equals(option5)) throw new MatchError((Object)option5);
            tuple2 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) throw new MatchError((Object)tuple22);
        Option firstTrainTimestampOpt = (Option)tuple22._1();
        Option lastOptimizeTimestampOpt = (Option)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)firstTrainTimestampOpt, (Object)lastOptimizeTimestampOpt);
        Tuple2 tuple24 = tuple23;
        Option firstTrainTimestampOpt2 = (Option)tuple24._1();
        Option lastOptimizeTimestampOpt2 = (Option)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)firstTrainTimestampOpt2, (Object)lastOptimizeTimestampOpt2);
        if (tuple25 != null && (option4 = (Option)tuple25._2()) instanceof Some && this.longEnoughAgo(lastOptimizeTs2 = BoxesRunTime.unboxToLong((Object)(some2 = (Some)option4).value()), optimizeEvery)) {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Last optimization was done on ", " which is more than ", " ago, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)lastOptimizeTs2), optimizeEvery})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"so training with optimization"})).s((Seq)Nil$.MODULE$));
            return true;
        }
        if (tuple25 != null && (option3 = (Option)tuple25._2()) instanceof Some && !this.longEnoughAgo(lastOptimizeTs = BoxesRunTime.unboxToLong((Object)(some = (Some)option3).value()), optimizeEvery)) {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Last optimization was done on ", " which is less than ", " ago, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)lastOptimizeTs), optimizeEvery})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"so training without optimization"})).s((Seq)Nil$.MODULE$));
            return false;
        }
        if (tuple25 != null && None$.MODULE$.equals(option2 = (Option)tuple25._1()) && optimizeAfterFirstTrainDelay.toMillis() > 0L) {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Training the models for the first time without optimization"})).s((Seq)Nil$.MODULE$));
            return false;
        }
        if (tuple25 != null && None$.MODULE$.equals(option = (Option)tuple25._1()) && optimizeAfterFirstTrainDelay.toMillis() == 0L) {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Training the models for the first time with optimization"})).s((Seq)Nil$.MODULE$));
            return true;
        }
        if (tuple25 != null) {
            Option option6 = (Option)tuple25._1();
            Option option7 = (Option)tuple25._2();
            if (option6 instanceof Some) {
                Some some4 = (Some)option6;
                long firstTrainTs = BoxesRunTime.unboxToLong((Object)some4.value());
                if (None$.MODULE$.equals(option7) && this.longEnoughAgo(firstTrainTs, optimizeAfterFirstTrainDelay)) {
                    this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"First training was done on ", " which is more than "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)firstTrainTs)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ago, so training with optimization"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{optimizeAfterFirstTrainDelay})));
                    return true;
                }
            }
        }
        if (tuple25 == null) throw new MatchError((Object)tuple25);
        Option option8 = (Option)tuple25._1();
        Option option9 = (Option)tuple25._2();
        if (!(option8 instanceof Some)) throw new MatchError((Object)tuple25);
        Some some5 = (Some)option8;
        long firstTrainTs = BoxesRunTime.unboxToLong((Object)some5.value());
        if (!None$.MODULE$.equals(option9)) throw new MatchError((Object)tuple25);
        if (this.longEnoughAgo(firstTrainTs, optimizeAfterFirstTrainDelay)) throw new MatchError((Object)tuple25);
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"First training was done on ", " which is less than "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)firstTrainTs)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ago, so training without optimization"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{optimizeAfterFirstTrainDelay})));
        return false;
    }

    private boolean longEnoughAgo(long timestamp, FiniteDuration duration) {
        return System.currentTimeMillis() - duration.toMillis() >= timestamp;
    }

    public TrainingScheduler(Scheduler scheduler, XlrConfig config, ReleasePredictionService releasePredictionService) {
        this.scheduler = scheduler;
        this.config = config;
        this.releasePredictionService = releasePredictionService;
        Logging.$init$((Logging)this);
    }
}

