/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.predictions.api;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.api.v1.ReleaseApi;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.plugins.predictions.service.ModelsMetadata;
import com.xebialabs.xlrelease.plugins.predictions.service.ReleasePredictionService;
import com.xebialabs.xlrelease.security.PermissionChecker;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Marker;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.LambdaDeserialize;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Path(value="/api/predictions")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
@ScalaSignature(bytes="\u0006\u0005\u0005}d\u0001B\u0005\u000b\u0001]A\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\t]\u0001\u0011\t\u0011)A\u0005_!AQ\u0007\u0001B\u0001B\u0003%a\u0007C\u0003=\u0001\u0011\u0005Q\bC\u0003D\u0001\u0011\u0005A\tC\u0003{\u0001\u0011\u00051\u0010C\u0004\u0002 \u0001!\t!!\t\t\u000f\u00055\u0002\u0001\"\u0003\u00020\tq\u0001K]3eS\u000e$\u0018n\u001c8t\u0003BL'BA\u0006\r\u0003\r\t\u0007/\u001b\u0006\u0003\u001b9\t1\u0002\u001d:fI&\u001cG/[8og*\u0011q\u0002E\u0001\ba2,x-\u001b8t\u0015\t\t\"#A\u0005yYJ,G.Z1tK*\u00111\u0003F\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011!F\u0001\u0004G>l7\u0001A\n\u0004\u0001aq\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"AB!osJ+g\r\u0005\u0002 I5\t\u0001E\u0003\u0002\"E\u0005)1\u000f\u001c45U*\t1%\u0001\u0005he&T(\u0010\\3e\u0013\t)\u0003EA\u0004M_\u001e<\u0017N\\4\u0002\u0015I,G.Z1tK\u0006\u0003\u0018\u000e\u0005\u0002)Y5\t\u0011F\u0003\u0002+W\u0005\u0011a/\r\u0006\u0003\u0017AI!!L\u0015\u0003\u0015I+G.Z1tK\u0006\u0003\u0018.\u0001\rsK2,\u0017m]3Qe\u0016$\u0017n\u0019;j_:\u001cVM\u001d<jG\u0016\u0004\"\u0001M\u001a\u000e\u0003ER!A\r\u0007\u0002\u000fM,'O^5dK&\u0011A'\r\u0002\u0019%\u0016dW-Y:f!J,G-[2uS>t7+\u001a:wS\u000e,\u0017!\u00059fe6L7o]5p]\u000eCWmY6feB\u0011qGO\u0007\u0002q)\u0011\u0011\bE\u0001\tg\u0016\u001cWO]5us&\u00111\b\u000f\u0002\u0012!\u0016\u0014X.[:tS>t7\t[3dW\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0003?\u0001\u0006\u0013\u0005CA \u0001\u001b\u0005Q\u0001\"\u0002\u0014\u0005\u0001\u00049\u0003\"\u0002\u0018\u0005\u0001\u0004y\u0003\"B\u001b\u0005\u0001\u00041\u0014!F4fiJ+G.Z1tKB\u0013X\rZ5di&|gn\u001d\u000b\u0003\u000bF\u0003\"AR(\u000e\u0003\u001dS!\u0001S%\u0002\t\r|'/\u001a\u0006\u0003\u0015.\u000b!A]:\u000b\u00051k\u0015AA<t\u0015\u0005q\u0015!\u00026bm\u0006D\u0018B\u0001)H\u0005!\u0011Vm\u001d9p]N,\u0007\"\u0002*\u0006\u0001\u0004\u0019\u0016!\u0003:fY\u0016\f7/Z%e!\t!6L\u0004\u0002V3B\u0011aKG\u0007\u0002/*\u0011\u0001LF\u0001\u0007yI|w\u000e\u001e \n\u0005iS\u0012A\u0002)sK\u0012,g-\u0003\u0002];\n11\u000b\u001e:j]\u001eT!A\u0017\u000e)\tE{6\r\u001a\t\u0003A\u0006l\u0011!S\u0005\u0003E&\u0013\u0011\u0002U1uQB\u000b'/Y7\u0002\u000bY\fG.^3\"\u0003IC#!\u00024\u0011\u0005\u001dtW\"\u00015\u000b\u0005%T\u0017AC1o]>$\u0018\r^5p]*\u00111\u000e\\\u0001\b[\u0016$(/[2t\u0015\tiG#\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\ty\u0007NA\u0003US6,G\r\u000b\u0003\u0006c\u000e$\bC\u00011s\u0013\t\u0019\u0018J\u0001\u0003QCRD\u0017%A;\u00021=\u0012X\r\\3bg\u0016|3P]3mK\u0006\u001cX-\u00133;])zT\u0010\u000b\u0002\u0006oB\u0011\u0001\r_\u0005\u0003s&\u00131aR#U\u0003-!(/Y5o\u001b>$W\r\\:\u0015\t\u0015c\u0018q\u0001\u0005\u0006{\u001a\u0001\raU\u0001\tm\u0006d\u0017\u000eZ1uK\"*Ap`2\u0002\u0006A\u0019\u0001-!\u0001\n\u0007\u0005\r\u0011J\u0001\u0006Rk\u0016\u0014\u0018\u0010U1sC6\f\u0013! \u0005\u0007\u0003\u00131\u0001\u0019A*\u0002\u0011=\u0004H/[7ju\u0016Dc!a\u0002\u0000G\u00065\u0011EAA\u0005Q\t1a\rK\u0003\u0007c\u000e\f\u0019\"\t\u0002\u0002\u0016\u00051q\u0006\u001e:bS:D3ABA\r!\r\u0001\u00171D\u0005\u0004\u0003;I%\u0001\u0002)P'R\u000b\u0001cZ3u\u001b>$W\r\\'fi\u0006$\u0017\r^1\u0016\u0003\u0015C#a\u00024)\u000b\u001d\t8-a\n\"\u0005\u0005%\u0012AB\u0018n_\u0012,G\u000e\u000b\u0002\bo\u0006Qq-\u001a;SK2,\u0017m]3\u0015\t\u0005E\u0012\u0011\n\t\u0007\u0003g\tI$!\u0010\u000e\u0005\u0005U\"bAA\u001c5\u0005!Q\u000f^5m\u0013\u0011\tY$!\u000e\u0003\u0007Q\u0013\u0018\u0010\u0005\u0003\u0002@\u0005\u0015SBAA!\u0015\r\t\u0019\u0005E\u0001\u0007I>l\u0017-\u001b8\n\t\u0005\u001d\u0013\u0011\t\u0002\b%\u0016dW-Y:f\u0011\u0015\u0011\u0006\u00021\u0001TQ\r\u0001\u0011Q\n\t\u0005\u0003\u001f\ni&\u0004\u0002\u0002R)!\u00111KA+\u0003)\u0019H/\u001a:f_RL\b/\u001a\u0006\u0005\u0003/\nI&A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\tY&A\u0002pe\u001eLA!a\u0018\u0002R\tI1i\\7q_:,g\u000e\u001e\u0015\u0007\u0001\u0005\r4-!\u001b\u0011\u0007\u0001\f)'C\u0002\u0002h%\u0013\u0001\u0002\u0015:pIV\u001cWm\u001d\u0017\u0003\u0003W\n#!!\u001c\u0002!\u0005\u0004\b\u000f\\5dCRLwN\\\u0018kg>t\u0007F\u0002\u0001\u0002r\r\f9\bE\u0002a\u0003gJ1!!\u001eJ\u0005!\u0019uN\\:v[\u0016\u001cHFAA6Q\u0015\u0001\u0011oYA>C\t\ti(\u0001\t0CBLw\u0006\u001d:fI&\u001cG/[8og\u0002")
public class PredictionsApi
implements Logging {
    public final ReleaseApi com$xebialabs$xlrelease$plugins$predictions$api$PredictionsApi$$releaseApi;
    private final ReleasePredictionService releasePredictionService;
    private final PermissionChecker permissionChecker;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        PredictionsApi predictionsApi = this;
        synchronized (predictionsApi) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Path(value="/release/{releaseId:.*?}")
    @Timed
    public Response getReleasePredictions(@PathParam(value="releaseId") String releaseId) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = this.getRelease(releaseId).flatMap((Function1 & Serializable)release -> $this.releasePredictionService.predictRaw((Release)release).map((Function1 & Serializable)predictionsData -> predictionsData));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String data = (String)success.value();
            return Response.ok((Object)data).type("application/json").build();
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof NotFoundException) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new StringBuilder(61).append("Could not find release by ID ").append(releaseId).append(" in active or archived databases").toString()).build();
            }
        }
        if (!bl) throw new MatchError((Object)try_);
        Throwable e = failure.exception();
        this.logger().error((Function0 & Serializable)() -> new StringBuilder(40).append("Could not get predictions for release ").append(releaseId).append(": ").append(e.getMessage()).toString(), (Function0 & Serializable)() -> e);
        return Response.serverError().entity((Object)e.getMessage()).build();
    }

    @POST
    @Path(value="/train")
    @Timed
    public Response trainModels(@QueryParam(value="validate") String validate, @QueryParam(value="optimize") String optimize) {
        Response response;
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        Try<String> try_ = this.releasePredictionService.train(Predef$.MODULE$.Boolean2boolean(Boolean.valueOf(validate)), Predef$.MODULE$.Boolean2boolean(Boolean.valueOf(optimize)));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String data = (String)success.value();
            response = Response.ok((Object)data).type("application/json").build();
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().error((Function0 & Serializable)() -> new StringBuilder(24).append("Could not train models: ").append(e.getMessage()).toString(), (Function0 & Serializable)() -> e);
            response = Response.serverError().entity((Object)e.getMessage()).build();
        } else {
            throw new MatchError(try_);
        }
        return response;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Path(value="/model")
    @Timed
    public Response getModelMetadata() {
        Option option;
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        boolean bl = false;
        Success success = null;
        Try<Option<ModelsMetadata>> try_ = this.releasePredictionService.requestModelMetadata();
        if (try_ instanceof Success) {
            bl = true;
            success = (Success)try_;
            Option option2 = (Option)success.value();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                ModelsMetadata metadata = (ModelsMetadata)some.value();
                return Response.ok(metadata.raw()).type("application/json").build();
            }
        }
        if (bl && None$.MODULE$.equals(option = (Option)success.value())) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Prediction models have not yet been trained").build();
        }
        if (!(try_ instanceof Failure)) throw new MatchError(try_);
        Failure failure = (Failure)try_;
        Throwable e = failure.exception();
        this.logger().error((Function0 & Serializable)() -> new StringBuilder(31).append("Could not get models metadata: ").append(e.getMessage()).toString(), (Function0 & Serializable)() -> e);
        return Response.serverError().entity((Object)e.getMessage()).build();
    }

    private Try<Release> getRelease(String releaseId) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> $this.com$xebialabs$xlrelease$plugins$predictions$api$PredictionsApi$$releaseApi.getRelease(releaseId)).recoverWith((PartialFunction)new Serializable(this, releaseId){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ PredictionsApi $outer;
            private final String releaseId$2;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1 instanceof NotFoundException ? Try$.MODULE$.apply((Function0 & Serializable)() -> $this.$outer.com$xebialabs$xlrelease$plugins$predictions$api$PredictionsApi$$releaseApi.getArchivedRelease($this.releaseId$2)) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof NotFoundException;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.releaseId$2 = releaseId$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.xebialabs.xlrelease.plugins.predictions.api.PredictionsApi$$anonfun$getRelease$2 )}, serializedLambda);
            }
        });
    }

    public PredictionsApi(ReleaseApi releaseApi, ReleasePredictionService releasePredictionService, PermissionChecker permissionChecker) {
        this.com$xebialabs$xlrelease$plugins$predictions$api$PredictionsApi$$releaseApi = releaseApi;
        this.releasePredictionService = releasePredictionService;
        this.permissionChecker = permissionChecker;
        Logging.$init$((Logging)this);
    }
}

