/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.predictions.service;

import com.typesafe.config.Config;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.plugins.predictions.service.ModelsMetadata;
import com.xebialabs.xlrelease.plugins.predictions.service.ReleasePredictionService;
import com.xebialabs.xlrelease.plugins.predictions.service.package$;
import com.xebialabs.xlrelease.plugins.predictions.service.package$JavaDuration$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@Component
@DependsOn(value={"serviceStarter"})
@Autowired
@ScalaSignature(bytes="\u0006\u0005\u0005]b\u0001B\u0005\u000b\u0001]A\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\ta\u0001\u0011\t\u0011)A\u0005c!Aa\u0007\u0001B\u0001B\u0003%q\u0007C\u0003<\u0001\u0011\u0005A\bC\u0003B\u0001\u0011\u0005!\t\u0003\u0004P\u0001\u0011\u0005!\u0002\u0015\u0005\u0006;\u0002!IA\u0018\u0005\u0006e\u0002!Ia\u001d\u0002\u0012)J\f\u0017N\\5oON\u001b\u0007.\u001a3vY\u0016\u0014(BA\u0006\r\u0003\u001d\u0019XM\u001d<jG\u0016T!!\u0004\b\u0002\u0017A\u0014X\rZ5di&|gn\u001d\u0006\u0003\u001fA\tq\u0001\u001d7vO&t7O\u0003\u0002\u0012%\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003'Q\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003U\t1aY8n\u0007\u0001\u00192\u0001\u0001\r\u001f!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u0019\te.\u001f*fMB\u0011q\u0004J\u0007\u0002A)\u0011\u0011EI\u0001\u0006g24GG\u001b\u0006\u0002G\u0005AqM]5{u2,G-\u0003\u0002&A\t9Aj\\4hS:<\u0017!C:dQ\u0016$W\u000f\\3s!\tAc&D\u0001*\u0015\t1#F\u0003\u0002,Y\u0005A\u0001\u000f\\;nE&twM\u0003\u0002.%\u0005AA-\u001a9m_fLG/\u0003\u00020S\tI1k\u00195fIVdWM]\u0001\u0007G>tg-[4\u0011\u0005I\"T\"A\u001a\u000b\u0005A\u0002\u0012BA\u001b4\u0005%AFN]\"p]\u001aLw-\u0001\rsK2,\u0017m]3Qe\u0016$\u0017n\u0019;j_:\u001cVM\u001d<jG\u0016\u0004\"\u0001O\u001d\u000e\u0003)I!A\u000f\u0006\u00031I+G.Z1tKB\u0013X\rZ5di&|gnU3sm&\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0005{yz\u0004\t\u0005\u00029\u0001!)a\u0005\u0002a\u0001O!)\u0001\u0007\u0002a\u0001c!)a\u0007\u0002a\u0001o\u0005!\u0011N\\5u)\u0005\u0019\u0005CA\rE\u0013\t)%D\u0001\u0003V]&$\bFA\u0003H!\tAU*D\u0001J\u0015\tQ5*\u0001\u0006b]:|G/\u0019;j_:T\u0011\u0001T\u0001\u0006U\u00064\u0018\r_\u0005\u0003\u001d&\u0013Q\u0002U8ti\u000e{gn\u001d;sk\u000e$\u0018!\u0005;sC&t\u0017I\u001c3M_\u001e,%O]8sgR\u00191)U.\t\u000bI3\u0001\u0019A*\u0002\u001b=\u0004H/[7ju\u0016,e/\u001a:z!\t!\u0016,D\u0001V\u0015\t1v+\u0001\u0005ekJ\fG/[8o\u0015\tA&$\u0001\u0006d_:\u001cWO\u001d:f]RL!AW+\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\")AL\u0002a\u0001'\u0006ar\u000e\u001d;j[&TX-\u00114uKJ4\u0015N]:u)J\f\u0017N\u001c#fY\u0006L\u0018\u0001\b3fG&$W-\u00134TQ>,H\u000eZ(qi&l\u0017N_3B]\u0012dun\u001a\u000b\u0005?\n\u0004\u0018\u000f\u0005\u0002\u001aA&\u0011\u0011M\u0007\u0002\b\u0005>|G.Z1o\u0011\u0015\u0019w\u00011\u0001e\u0003AiW\r^1eCR\f'+Z:q_:\u001cX\rE\u0002fQ*l\u0011A\u001a\u0006\u0003Oj\tA!\u001e;jY&\u0011\u0011N\u001a\u0002\u0004)JL\bcA\rl[&\u0011AN\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005ar\u0017BA8\u000b\u00059iu\u000eZ3mg6+G/\u00193bi\u0006DQAU\u0004A\u0002MCQ\u0001X\u0004A\u0002M\u000bQ\u0002\\8oO\u0016sw.^4i\u0003\u001e|GcA0us\")Q\u000f\u0003a\u0001m\u0006IA/[7fgR\fW\u000e\u001d\t\u00033]L!\u0001\u001f\u000e\u0003\t1{gn\u001a\u0005\u0006-\"\u0001\ra\u0015\u0015\u0003\u0001m\u00042\u0001`A\u0007\u001b\u0005i(B\u0001&\u007f\u0015\ry\u0018\u0011A\u0001\bM\u0006\u001cGo\u001c:z\u0015\u0011\t\u0019!!\u0002\u0002\u000b\t,\u0017M\\:\u000b\t\u0005\u001d\u0011\u0011B\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\u0011\u00111B\u0001\u0004_J<\u0017bAA\b{\nI\u0011)\u001e;po&\u0014X\r\u001a\u0015\b\u0001\u0005M\u0011\u0011EA\u0012!\u0011\t)\"!\b\u000e\u0005\u0005]!b\u0001&\u0002\u001a)!\u00111DA\u0003\u0003\u001d\u0019wN\u001c;fqRLA!a\b\u0002\u0018\tIA)\u001a9f]\u0012\u001cxJ\\\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0003K\t#!a\n\u0002\u001dM,'O^5dKN#\u0018M\u001d;fe\"\u001a\u0001!a\u000b\u0011\t\u00055\u00121G\u0007\u0003\u0003_QA!!\r\u0002\u0006\u0005Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005U\u0012q\u0006\u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class TrainingScheduler
implements Logging {
    private final Scheduler scheduler;
    private final XlrConfig config;
    private final ReleasePredictionService releasePredictionService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TrainingScheduler trainingScheduler = this;
        synchronized (trainingScheduler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @PostConstruct
    public void init() {
        Config pluginConfig = this.config.getRootConfig().getConfig("xl.plugin.riskPredictions");
        Duration buildModelEvery = pluginConfig.getDuration("modelBuildPeriod");
        Duration initialDelay = pluginConfig.getDuration("modelBuildInitialDelay");
        Duration optimizeEvery = pluginConfig.getDuration("optimizeEvery");
        Duration optimizeAfterFirstTrainDelay = pluginConfig.getDuration("optimizeAfterFirstTrainDelay");
        this.logger().info((Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(53).append("Will start building prediction models every ").append(buildModelEvery).append(" after ").append(initialDelay).append(". ").toString()).append(new StringBuilder(50).append("Optimization will be delayed by ").append(optimizeAfterFirstTrainDelay).append(" and happen every ").append(optimizeEvery).toString()).toString());
        this.scheduler.scheduleAtFixedRate(() -> this.trainAndLogErrors(package$JavaDuration$.MODULE$.asScala$extension(package$.MODULE$.JavaDuration(optimizeEvery)), package$JavaDuration$.MODULE$.asScala$extension(package$.MODULE$.JavaDuration(optimizeAfterFirstTrainDelay))), initialDelay.toMillis(), buildModelEvery.toMillis(), TimeUnit.MILLISECONDS);
    }

    public void trainAndLogErrors(FiniteDuration optimizeEvery, FiniteDuration optimizeAfterFirstTrainDelay) {
        boolean shouldOptimize;
        boolean x$1 = shouldOptimize = this.decideIfShouldOptimizeAndLog(this.releasePredictionService.requestModelMetadata(), optimizeEvery, optimizeAfterFirstTrainDelay);
        boolean x$2 = this.releasePredictionService.train$default$1();
        Try<String> try_ = this.releasePredictionService.train(x$2, x$1);
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().error((Function0 & Serializable)() -> e.getMessage());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean decideIfShouldOptimizeAndLog(Try<Option<ModelsMetadata>> metadataResponse, FiniteDuration optimizeEvery, FiniteDuration optimizeAfterFirstTrainDelay) {
        Option option;
        Option option2;
        Some some;
        long lastOptimizeTs;
        Option option3;
        Some some2;
        long lastOptimizeTs2;
        Option option4;
        Tuple2 tuple2;
        Some some3;
        ModelsMetadata modelsMetadata;
        Try<Option<ModelsMetadata>> try_ = metadataResponse;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().error((Function0 & Serializable)() -> new StringBuilder(64).append("Could not get model metadata, but will try to train the models: ").append(e.getMessage()).toString());
            return false;
        }
        if (!(try_ instanceof Success)) throw new MatchError(try_);
        Success success = (Success)try_;
        Option metadataOpt = (Option)success.value();
        Option option5 = metadataOpt;
        if (option5 instanceof Some && (modelsMetadata = (ModelsMetadata)(some3 = (Some)option5).value()) != null) {
            Option<Object> firstTrainTs = modelsMetadata.firstTrainTimestamp();
            Option<Object> lastOptimizeTs3 = modelsMetadata.lastOptimizeTimestamp();
            tuple2 = new Tuple2(firstTrainTs, lastOptimizeTs3);
        } else {
            if (!None$.MODULE$.equals(option5)) throw new MatchError((Object)option5);
            tuple2 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) throw new MatchError((Object)tuple22);
        Option firstTrainTimestampOpt = (Option)tuple22._1();
        Option lastOptimizeTimestampOpt = (Option)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)firstTrainTimestampOpt, (Object)lastOptimizeTimestampOpt);
        Tuple2 tuple24 = tuple23;
        Option firstTrainTimestampOpt2 = (Option)tuple24._1();
        Option lastOptimizeTimestampOpt2 = (Option)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)firstTrainTimestampOpt2, (Object)lastOptimizeTimestampOpt2);
        if (tuple25 != null && (option4 = (Option)tuple25._2()) instanceof Some && this.longEnoughAgo(lastOptimizeTs2 = BoxesRunTime.unboxToLong((Object)(some2 = (Some)option4).value()), optimizeEvery)) {
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(56).append("Last optimization was done on ").append(lastOptimizeTs2).append(" which is more than ").append(optimizeEvery).append(" ago, ").toString()).append("so training with optimization").toString());
            return true;
        }
        if (tuple25 != null && (option3 = (Option)tuple25._2()) instanceof Some && !this.longEnoughAgo(lastOptimizeTs = BoxesRunTime.unboxToLong((Object)(some = (Some)option3).value()), optimizeEvery)) {
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(56).append("Last optimization was done on ").append(lastOptimizeTs).append(" which is less than ").append(optimizeEvery).append(" ago, ").toString()).append("so training without optimization").toString());
            return false;
        }
        if (tuple25 != null && None$.MODULE$.equals(option2 = (Option)tuple25._1()) && optimizeAfterFirstTrainDelay.toMillis() > 0L) {
            this.logger().info((Function0 & Serializable)() -> "Training the models for the first time without optimization");
            return false;
        }
        if (tuple25 != null && None$.MODULE$.equals(option = (Option)tuple25._1()) && optimizeAfterFirstTrainDelay.toMillis() == 0L) {
            this.logger().info((Function0 & Serializable)() -> "Training the models for the first time with optimization");
            return true;
        }
        if (tuple25 != null) {
            Option option6 = (Option)tuple25._1();
            Option option7 = (Option)tuple25._2();
            if (option6 instanceof Some) {
                Some some4 = (Some)option6;
                long firstTrainTs = BoxesRunTime.unboxToLong((Object)some4.value());
                if (None$.MODULE$.equals(option7) && this.longEnoughAgo(firstTrainTs, optimizeAfterFirstTrainDelay)) {
                    this.logger().info((Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(47).append("First training was done on ").append(firstTrainTs).append(" which is more than ").toString()).append(new StringBuilder(35).append(optimizeAfterFirstTrainDelay).append(" ago, so training with optimization").toString()).toString());
                    return true;
                }
            }
        }
        if (tuple25 == null) throw new MatchError((Object)tuple25);
        Option option8 = (Option)tuple25._1();
        Option option9 = (Option)tuple25._2();
        if (!(option8 instanceof Some)) throw new MatchError((Object)tuple25);
        Some some5 = (Some)option8;
        long firstTrainTs = BoxesRunTime.unboxToLong((Object)some5.value());
        if (!None$.MODULE$.equals(option9)) throw new MatchError((Object)tuple25);
        if (this.longEnoughAgo(firstTrainTs, optimizeAfterFirstTrainDelay)) throw new MatchError((Object)tuple25);
        this.logger().info((Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(47).append("First training was done on ").append(firstTrainTs).append(" which is less than ").toString()).append(new StringBuilder(38).append(optimizeAfterFirstTrainDelay).append(" ago, so training without optimization").toString()).toString());
        return false;
    }

    private boolean longEnoughAgo(long timestamp, FiniteDuration duration) {
        return System.currentTimeMillis() - duration.toMillis() >= timestamp;
    }

    public TrainingScheduler(Scheduler scheduler, XlrConfig config, ReleasePredictionService releasePredictionService) {
        this.scheduler = scheduler;
        this.config = config;
        this.releasePredictionService = releasePredictionService;
        Logging.$init$((Logging)this);
    }
}

