/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.predictions.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.typesafe.config.Config;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.core.xml.WriteWithoutPasswordCiConverter;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.json.CiSerializerHelper$;
import com.xebialabs.xlrelease.plugins.predictions.service.ModelsMetadata;
import com.xebialabs.xlrelease.plugins.predictions.service.ReleasePrediction;
import com.xebialabs.xlrelease.plugins.predictions.service.ReleasePredictionServiceHolder$;
import com.xebialabs.xlrelease.plugins.predictions.service.package$;
import com.xebialabs.xlrelease.plugins.predictions.service.package$JavaDuration$;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@DependsOn(value={"serviceStarter"})
@Autowired
@ScalaSignature(bytes="\u0006\u0005\tmb\u0001\u0002\u0011\"\u00019B\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\u0006\u0007\u0002!\t\u0001\u0012\u0005\b\u0011\u0002\u0011\r\u0011\"\u0003J\u0011\u0019\u0011\u0006\u0001)A\u0005\u0015\"91\u000b\u0001b\u0001\n\u0013I\u0005B\u0002+\u0001A\u0003%!\nC\u0004V\u0001\t\u0007I\u0011B%\t\rY\u0003\u0001\u0015!\u0003K\u0011\u001d9\u0006A1A\u0005\n%Ca\u0001\u0017\u0001!\u0002\u0013Q\u0005bB-\u0001\u0005\u0004%IA\u0017\u0005\u0007K\u0002\u0001\u000b\u0011B.\t\r\u0019\u0004A1A\u0011h\u0011\u001dq\u0007A1A\u0005\n=Dq!!\u0007\u0001A\u0003%\u0001\u000fC\u0004\u0002\u001c\u0001!\t!!\b\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:!I\u0011q\r\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u000e\u0005\n\u0003{\u0002\u0011\u0013!C\u0001\u0003SBq!a \u0001\t\u0003\t\t\tC\u0004\u0002\u000e\u0002!\t!a$\t\u0013\u00055\u0006!%A\u0005\u0002\u0005=\u0006bBAZ\u0001\u0011\u0005\u0011Q\u0017\u0005\b\u0003s\u0003A\u0011AA^\u0011\u001d\t)\r\u0001C\u0005\u0003\u000fDq!!8\u0001\t\u0013\ty\u000eC\u0004\u0002f\u0002!I!a:\t\u000f\u0005=\b\u0001\"\u0003\u0002r\"9\u00111\u001f\u0001\u0005\n\u0005E\b\u0002CA{\u0001\u0011\u0005\u0011%a>\t\u000f\u0005m\b\u0001\"\u0003\u0002~\nA\"+\u001a7fCN,\u0007K]3eS\u000e$\u0018n\u001c8TKJ4\u0018nY3\u000b\u0005\t\u001a\u0013aB:feZL7-\u001a\u0006\u0003I\u0015\n1\u0002\u001d:fI&\u001cG/[8og*\u0011aeJ\u0001\ba2,x-\u001b8t\u0015\tA\u0013&A\u0005yYJ,G.Z1tK*\u0011!fK\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001L\u0001\u0004G>l7\u0001A\n\u0004\u0001=*\u0004C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$AB!osJ+g\r\u0005\u00027w5\tqG\u0003\u00029s\u0005)1\u000f\u001c45U*\t!(\u0001\u0005he&T(\u0010\\3e\u0013\tatGA\u0004M_\u001e<\u0017N\\4\u0002\r\r|gNZ5h!\ty\u0014)D\u0001A\u0015\tit%\u0003\u0002C\u0001\nI\u0001\f\u001c:D_:4\u0017nZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0015;\u0005C\u0001$\u0001\u001b\u0005\t\u0003\"B\u001f\u0003\u0001\u0004q\u0014!D'P\t\u0016cuLU#M\u000b\u0006\u001bV)F\u0001K!\tY\u0005+D\u0001M\u0015\tie*\u0001\u0003mC:<'\"A(\u0002\t)\fg/Y\u0005\u0003#2\u0013aa\u0015;sS:<\u0017AD'P\t\u0016cuLU#M\u000b\u0006\u001bV\tI\u0001\f\u001b>#U\tT0U\u0003N[5+\u0001\u0007N\u001f\u0012+Ej\u0018+B'.\u001b\u0006%\u0001\u0010S\u000bN\u0003vJT*F?B\u0013V\tR%D)&{ejX%T?\u0006\u0013uJ\u0015+F\t\u0006y\"+R*Q\u001f:\u001bVi\u0018)S\u000b\u0012K5\tV%P\u001d~K5kX!C\u001fJ#V\t\u0012\u0011\u00029I+5\u000bU(O'\u0016{\u0006KU#E\u0013\u000e#\u0016j\u0014(`\u0013N{&+S*L3\u0006i\"+R*Q\u001f:\u001bVi\u0018)S\u000b\u0012K5\tV%P\u001d~K5k\u0018*J'.K\u0006%\u0001\u0007pE*,7\r^'baB,'/F\u0001\\!\ta6-D\u0001^\u0015\tqv,\u0001\u0005eCR\f'-\u001b8e\u0015\t\u0001\u0017-A\u0004kC\u000e\\7o\u001c8\u000b\u0005\t\\\u0013!\u00034bgR,'\u000f_7m\u0013\t!WL\u0001\u0007PE*,7\r^'baB,'/A\u0007pE*,7\r^'baB,'\u000fI\u0001\u0011Kb,7-\u001e;j_:\u001cuN\u001c;fqR,\u0012\u0001\u001b\t\u0003S2l\u0011A\u001b\u0006\u0003WF\n!bY8oGV\u0014(/\u001a8u\u0013\ti'N\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0006i!/Z:u)\u0016l\u0007\u000f\\1uKN,\u0012\u0001\u001d\t\u0006cV<\u0018\u0011A\u0007\u0002e*\u00111n\u001d\u0006\u0003i:\u000bA!\u001e;jY&\u0011aO\u001d\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bc\u0001\u0019yu&\u0011\u00110\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005mtX\"\u0001?\u000b\u0005ut\u0015\u0001\u0002;j[\u0016L!a ?\u0003\u0011\u0011+(/\u0019;j_:\u0004B!a\u0001\u0002\u00165\u0011\u0011Q\u0001\u0006\u0005\u0003\u000f\tI!\u0001\u0004dY&,g\u000e\u001e\u0006\u0005\u0003\u0017\ti!A\u0002xK\nTA!a\u0004\u0002\u0012\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002\u0014\u0005\u0019qN]4\n\t\u0005]\u0011Q\u0001\u0002\r%\u0016\u001cH\u000fV3na2\fG/Z\u0001\u000fe\u0016\u001cH\u000fV3na2\fG/Z:!\u0003\u0011Ig.\u001b;\u0015\u0005\u0005}\u0001c\u0001\u0019\u0002\"%\u0019\u00111E\u0019\u0003\tUs\u0017\u000e\u001e\u0015\u0004!\u0005\u001d\u0002\u0003BA\u0015\u0003gi!!a\u000b\u000b\t\u00055\u0012qF\u0001\u000bC:tw\u000e^1uS>t'BAA\u0019\u0003\u0015Q\u0017M^1y\u0013\u0011\t)$a\u000b\u0003\u001bA{7\u000f^\"p]N$(/^2u\u0003\u0015!(/Y5o)\u0019\tY$!\u0017\u0002dA1\u0011QHA!\u0003\u000bj!!a\u0010\u000b\u0005Q\f\u0014\u0002BA\"\u0003\u007f\u00111\u0001\u0016:z!\u0011\t9%!\u0016\u000f\t\u0005%\u0013\u0011\u000b\t\u0004\u0003\u0017\nTBAA'\u0015\r\ty%L\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005M\u0013'\u0001\u0004Qe\u0016$WMZ\u0005\u0004#\u0006]#bAA*c!I\u00111L\t\u0011\u0002\u0003\u0007\u0011QL\u0001\tm\u0006d\u0017\u000eZ1uKB\u0019\u0001'a\u0018\n\u0007\u0005\u0005\u0014GA\u0004C_>dW-\u00198\t\u0013\u0005\u0015\u0014\u0003%AA\u0002\u0005u\u0013\u0001C8qi&l\u0017N_3\u0002\u001fQ\u0014\u0018-\u001b8%I\u00164\u0017-\u001e7uIE*\"!a\u001b+\t\u0005u\u0013QN\u0016\u0003\u0003_\u0002B!!\u001d\u0002z5\u0011\u00111\u000f\u0006\u0005\u0003k\n9(A\u0005v]\u000eDWmY6fI*\u0019\u0011QF\u0019\n\t\u0005m\u00141\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u0004;sC&tG\u0005Z3gCVdG\u000f\n\u001a\u0002)I,\u0017/^3ti6{G-\u001a7NKR\fG-\u0019;b)\t\t\u0019\t\u0005\u0004\u0002>\u0005\u0005\u0013Q\u0011\t\u0005aa\f9\tE\u0002G\u0003\u0013K1!a#\"\u00059iu\u000eZ3mg6+G/\u00193bi\u0006\fq\u0001\u001d:fI&\u001cG\u000f\u0006\u0004\u0002\u0012\u0006e\u0015\u0011\u0016\t\u0007\u0003{\t\t%a%\u0011\u0007\u0019\u000b)*C\u0002\u0002\u0018\u0006\u0012\u0011CU3mK\u0006\u001cX\r\u0015:fI&\u001cG/[8o\u0011\u001d\tY*\u0006a\u0001\u0003;\u000bqA]3mK\u0006\u001cX\r\u0005\u0003\u0002 \u0006\u0015VBAAQ\u0015\r\t\u0019kJ\u0001\u0007I>l\u0017-\u001b8\n\t\u0005\u001d\u0016\u0011\u0015\u0002\b%\u0016dW-Y:f\u0011!\tY+\u0006I\u0001\u0002\u00049\u0018a\u0002;j[\u0016|W\u000f^\u0001\u0012aJ,G-[2uI\u0011,g-Y;mi\u0012\u0012TCAAYU\r9\u0018QN\u0001\u000baJ,G-[2u%\u0006<H\u0003BA\u001e\u0003oCq!a'\u0018\u0001\u0004\ti*A\u000esKF,Xm\u001d;Qe\u0016$\u0017n\u0019;j_:\u001chI]8n\u001b>$W\r\u001c\u000b\t\u0003w\ti,a0\u0002D\"9\u00111\u0014\rA\u0002\u0005u\u0005bBAa1\u0001\u0007\u0011QI\u0001\n[>$W\r\u001c(b[\u0016Da!a+\u0019\u0001\u00049\u0018A\b9beN,'+\u001a7fCN,\u0007K]3eS\u000e$\u0018n\u001c8SKN\u0004xN\\:f)\u0019\t\u0019*!3\u0002\\\"9\u00111Z\rA\u0002\u00055\u0017a\u00049sK\u0012L7\r^5p]NT5o\u001c8\u0011\u0011\u0005=\u0017\u0011[A#\u0003+l\u0011a]\u0005\u0004\u0003'\u001c(aA'baB\u0019\u0001'a6\n\u0007\u0005e\u0017GA\u0002B]fDq!a'\u001a\u0001\u0004\ti*A\u0011qCJ\u001cXMU3mK\u0006\u001cX-T8eK2lU\r^1eCR\f'+Z:q_:\u001cX\r\u0006\u0003\u0002\b\u0006\u0005\bbBAr5\u0001\u0007\u0011QZ\u0001\t[\u0016$\u0018\rZ1uC\u0006!2\r[3dW\u000e{gN\\3di&|g.Q:z]\u000e$\"!!;\u0011\u000b%\fY/a\b\n\u0007\u00055(N\u0001\u0004GkR,(/Z\u0001\u0007O\u0016$XK\u001d7\u0016\u0005\u0005\u0015\u0013aE4fiR\u000b7o[:TG\",W.Y!t\u0007N4\u0018\u0001\u0004:fgR$V-\u001c9mCR,G\u0003BA\u0001\u0003sDa!a+\u001f\u0001\u00049\u0018A\u00059sKB\f'/\u001a*fY\u0016\f7/\u001a&t_:$B!!\u0012\u0002\u0000\"9\u00111T\u0010A\u0002\u0005u\u0005f\u0001\u0001\u0003\u0004A!!Q\u0001B\t\u001b\t\u00119A\u0003\u0003\u0002.\t%!\u0002\u0002B\u0006\u0005\u001b\tqAZ1di>\u0014\u0018P\u0003\u0003\u0003\u0010\u00055\u0011!\u00022fC:\u001c\u0018\u0002\u0002B\n\u0005\u000f\u0011\u0011\"Q;u_^L'/\u001a3)\u000f\u0001\u00119B!\n\u0003(A!!\u0011\u0004B\u0011\u001b\t\u0011YB\u0003\u0003\u0002.\tu!\u0002\u0002B\u0010\u0003\u001b\tqaY8oi\u0016DH/\u0003\u0003\u0003$\tm!!\u0003#fa\u0016tGm](o\u0003\u00151\u0018\r\\;fY\t\u0011I#\t\u0002\u0003,\u0005q1/\u001a:wS\u000e,7\u000b^1si\u0016\u0014\bf\u0001\u0001\u00030A!!\u0011\u0007B\u001c\u001b\t\u0011\u0019D\u0003\u0003\u00036\u00055\u0011AC:uKJ,w\u000e^=qK&!!\u0011\bB\u001a\u0005%\u0019u.\u001c9p]\u0016tG\u000f")
public class ReleasePredictionService
implements Logging {
    private final XlrConfig config;
    private final String MODEL_RELEASE;
    private final String MODEL_TASKS;
    private final String RESPONSE_PREDICTION_IS_ABORTED;
    private final String RESPONSE_PREDICTION_IS_RISKY;
    private final ObjectMapper objectMapper;
    private final ConcurrentHashMap<Option<java.time.Duration>, RestTemplate> restTemplates;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReleasePredictionService releasePredictionService = this;
        synchronized (releasePredictionService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private String MODEL_RELEASE() {
        return this.MODEL_RELEASE;
    }

    private String MODEL_TASKS() {
        return this.MODEL_TASKS;
    }

    private String RESPONSE_PREDICTION_IS_ABORTED() {
        return this.RESPONSE_PREDICTION_IS_ABORTED;
    }

    private String RESPONSE_PREDICTION_IS_RISKY() {
        return this.RESPONSE_PREDICTION_IS_RISKY;
    }

    private ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    public ExecutionContext executionContext() {
        return ExecutionContext$.MODULE$.global();
    }

    private ConcurrentHashMap<Option<java.time.Duration>, RestTemplate> restTemplates() {
        return this.restTemplates;
    }

    @PostConstruct
    public void init() {
        ReleasePredictionServiceHolder$.MODULE$.releasePredictionService().set(this);
        this.checkConnectionAsync();
    }

    public Try<String> train(boolean validate, boolean optimize) {
        Failure failure;
        long start = System.currentTimeMillis();
        String url = new StringBuilder(34).append(this.getUrl()).append("/api/train/all?validate=").append(validate).append("&optimize=").append(optimize).toString();
        Config db = this.config.getRootConfig().hasPath("xl.plugin.riskPredictions.db-connection.reporting") ? this.config.getRootConfig().getConfig("xl.plugin.riskPredictions.db-connection.reporting") : this.config.getRootConfig().getConfig("xl.reporting");
        java.util.Map body = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)new StringBuilder(20).append("Releases archive at ").append(ServerConfiguration.getInstance().getServerUrl()).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jdbc_url"), (Object)db.getString("db-url")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"username"), (Object)db.getString("db-username")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"password"), (Object)db.getString("db-password")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"driver_classname"), (Object)db.getString("db-driver-classname")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tasks_schema_csv_content"), (Object)this.getTasksSchemaAsCsv())}))).asJava();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        try {
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(56).append("Start building prediction models at ").append(this.getUrl()).append(" with DB connection ").append(db.getString("db-url")).toString());
            ResponseEntity response = this.restTemplate((Option<java.time.Duration>)None$.MODULE$).postForEntity(url, (Object)new HttpEntity((Object)body, (MultiValueMap)headers), String.class, new Object[0]);
            long duration = System.currentTimeMillis() - start;
            String trainResponseAsString = (String)response.getBody();
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(44).append("Finished building prediction models in ").append(duration).append(" ms: ").append(trainResponseAsString).toString());
            failure = new Success((Object)trainResponseAsString);
        }
        catch (HttpStatusCodeException e) {
            failure = new Failure((Throwable)new IllegalStateException(new StringBuilder(0).append(new StringBuilder(37).append("Failed to build prediction models: ").append(e.getStatusCode()).append(", ").toString()).append(String.valueOf(e.getResponseBodyAsString())).toString()));
        }
        return failure;
    }

    public boolean train$default$1() {
        return true;
    }

    public boolean train$default$2() {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public Try<Option<ModelsMetadata>> requestModelMetadata() {
        modelName = this.MODEL_RELEASE();
        this.logger().info((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$requestModelMetadata$1(java.lang.String ), ()Ljava/lang/String;)((String)modelName));
        start = System.currentTimeMillis();
        url = new StringBuilder(14).append(this.getUrl()).append("/api/metadata/").append(modelName).toString();
        try {
            response = this.restTemplate((Option<java.time.Duration>)None$.MODULE$).getForEntity(url, java.util.Map.class, new Object[0]);
            metadata = (java.util.Map)response.getBody();
            duration = System.currentTimeMillis() - start;
            this.logger().info((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$requestModelMetadata$2(java.lang.String long java.util.Map ), ()Ljava/lang/String;)((String)modelName, (long)duration, (java.util.Map)metadata));
            v0 = Try$.MODULE$.apply((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$requestModelMetadata$3(com.xebialabs.xlrelease.plugins.predictions.service.ReleasePredictionService java.util.Map ), ()Lcom/xebialabs/xlrelease/plugins/predictions/service/ModelsMetadata;)((ReleasePredictionService)this, (java.util.Map)metadata)).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$requestModelMetadata$4(com.xebialabs.xlrelease.plugins.predictions.service.ModelsMetadata ), (Lcom/xebialabs/xlrelease/plugins/predictions/service/ModelsMetadata;)Lscala/Option;)());
        }
        catch (Throwable var10_7) {
            var11_8 = false;
            var12_9 = null;
            var13_10 = var10_7;
            if (!(var13_10 instanceof HttpStatusCodeException)) ** GOTO lbl-1000
            var11_8 = true;
            var12_9 = (HttpStatusCodeException)var13_10;
            v1 = var12_9.getStatusCode();
            var14_11 = HttpStatus.NOT_FOUND;
            if (!(v1 != null ? v1.equals(var14_11) == false : var14_11 != null)) {
                var1_12 = Try$.MODULE$.apply((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$requestModelMetadata$5(), ()Lscala/None$;)());
            } else if (var11_8) {
                var1_12 = new Failure((Throwable)new IllegalStateException(new StringBuilder(0).append(new StringBuilder(63).append("Got unsuccessful response when requesting metadata for model ").append(modelName).append(": ").toString()).append(new StringBuilder(2).append(var12_9.getStatusCode()).append(", ").append(var12_9.getResponseBodyAsString()).toString()).toString(), var12_9));
            } else if (var13_10 != null) {
                var15_13 = var13_10;
                var1_12 = new Failure((Throwable)new IllegalStateException(new StringBuilder(0).append(new StringBuilder(60).append("Could not get response when requesting metadata for model ").append(modelName).append(": ").toString()).append(String.valueOf(var15_13.getMessage())).toString(), var15_13));
            } else {
                throw var10_7;
            }
            v0 = var1_12;
        }
        return v0;
    }

    public Try<ReleasePrediction> predict(Release release, Option<java.time.Duration> timeout) {
        return this.requestPredictionsFromModel(release, this.MODEL_RELEASE(), timeout).flatMap((Function1 & Serializable)predictionsData -> {
            java.util.Map predictions = (java.util.Map)this.objectMapper().readValue(predictionsData, java.util.Map.class);
            return Try$.MODULE$.apply((Function0 & Serializable)() -> this.parseReleasePredictionResponse(predictions, release));
        });
    }

    public Option<java.time.Duration> predict$default$2() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Try<String> predictRaw(Release release) {
        SeqOps seqOps;
        java.time.Duration awaitTimeout = this.config.getRootConfig().getDuration("xl.plugin.riskPredictions.timeouts.predictionsRequest");
        Seq seq = (Seq)Await$.MODULE$.result((Awaitable)Future$.MODULE$.sequence((IterableOnce)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Future[]{Future$.MODULE$.apply((Function0 & Serializable)() -> this.requestPredictionsFromModel(release, this.MODEL_RELEASE(), (Option<java.time.Duration>)Option$.MODULE$.apply((Object)awaitTimeout)), this.executionContext()), Future$.MODULE$.apply((Function0 & Serializable)() -> this.requestPredictionsFromModel(release, this.MODEL_TASKS(), (Option<java.time.Duration>)Option$.MODULE$.apply((Object)awaitTimeout)), this.executionContext())})), BuildFrom$.MODULE$.buildFromIterableOps(), this.executionContext()), (Duration)package$JavaDuration$.MODULE$.asScala$extension(package$.MODULE$.JavaDuration(awaitTimeout)));
        if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
            Try try_ = (Try)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            Try try_2 = (Try)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                String releaseResponse = (String)success.value();
                if (try_2 instanceof Success) {
                    Success success2 = (Success)try_2;
                    String tasksResponse = (String)success2.value();
                    String combinedJson = new StringBuilder(24).append("{\"release\": ").append(releaseResponse).append(", \"tasks\": ").append(tasksResponse).append("}").toString();
                    return new Success((Object)combinedJson);
                }
            }
        }
        if (seq == null) return (Try)seq.find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isFailure())).get();
        SeqOps seqOps2 = scala.package$.MODULE$.Seq().unapplySeq((SeqOps)seq);
        if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2)) return (Try)seq.find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isFailure())).get();
        if (new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) == null) return (Try)seq.find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isFailure())).get();
        if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 2) != 0) return (Try)seq.find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isFailure())).get();
        Try try_ = (Try)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
        Try try_3 = (Try)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1);
        if (!(try_ instanceof Failure)) return (Try)seq.find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isFailure())).get();
        if (!(try_3 instanceof Failure)) return (Try)seq.find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isFailure())).get();
        return new Failure((Throwable)new IllegalStateException(new StringBuilder(0).append("Both release and tasks prediction requests have failed for ").append(new StringBuilder(18).append("release ").append(release).append(". Errors: ").append(seq.mkString("; ")).toString()).toString()));
    }

    public Try<String> requestPredictionsFromModel(Release release, String modelName, Option<java.time.Duration> timeout) {
        Failure failure;
        this.logger().info((Function0 & Serializable)() -> new StringBuilder(43).append("Requesting predictions for model ").append(modelName).append(", release ").append(release).toString());
        long start = System.currentTimeMillis();
        String url = new StringBuilder(13).append(this.getUrl()).append("/api/predict/").append(modelName).toString();
        String releaseJson = this.prepareReleaseJson(release);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        try {
            ResponseEntity response = this.restTemplate(timeout).postForEntity(url, (Object)new HttpEntity((Object)releaseJson, (MultiValueMap)headers), String.class, new Object[0]);
            String predictionsData = (String)response.getBody();
            long duration = System.currentTimeMillis() - start;
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(43).append("Got predictions for model ").append(modelName).append(", release ").append(release).append(" in ").append(duration).append(" ms").toString());
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(43).append("Predictions response for model ").append(modelName).append(", release ").append(release).append(": ").append(predictionsData).toString());
            failure = new Success((Object)predictionsData);
        }
        catch (HttpStatusCodeException e) {
            failure = new Failure((Throwable)new IllegalStateException(new StringBuilder(0).append(new StringBuilder(47).append("Got unsuccessful response when predicting ").append(modelName).append(" for ").toString()).append(new StringBuilder(12).append("release ").append(release).append(": ").append(e.getStatusCode()).append(", ").append(e.getResponseBodyAsString()).toString()).toString(), e));
        }
        catch (Throwable e) {
            failure = new Failure((Throwable)new IllegalStateException(new StringBuilder(0).append(new StringBuilder(44).append("Could not get response when predicting ").append(modelName).append(" for ").toString()).append(new StringBuilder(10).append("release ").append(release).append(": ").append(e.getMessage()).toString()).toString(), e));
        }
        return failure;
    }

    private ReleasePrediction parseReleasePredictionResponse(java.util.Map<String, Object> predictionsJson, Release release) {
        scala.collection.mutable.Map predictions = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(predictionsJson).asScala();
        scala.collection.immutable.Map probabilities = ((IterableOnceOps)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.RESPONSE_PREDICTION_IS_ABORTED(), this.RESPONSE_PREDICTION_IS_RISKY()})).map((Function1 & Serializable)name -> {
            Option option = predictions.get(name);
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException(new StringBuilder(0).append(new StringBuilder(27).append("There was no prediction '").append((String)name).append("' ").toString()).append(new StringBuilder(45).append("for release ").append(release).append(" in the response from the model: ").append(predictions).toString()).toString());
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            Object prediction = some.value();
            Tuple2 tuple2 = new Tuple2(name, (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)prediction)));
            return tuple2;
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return new ReleasePrediction(BoxesRunTime.unboxToDouble((Object)probabilities.apply((Object)this.RESPONSE_PREDICTION_IS_ABORTED())), BoxesRunTime.unboxToDouble((Object)probabilities.apply((Object)this.RESPONSE_PREDICTION_IS_RISKY())));
    }

    private ModelsMetadata parseReleaseModelMetadataResponse(java.util.Map<String, Object> metadata) {
        return new ModelsMetadata((Option<Object>)ReleasePredictionService.ensureOptionalLong$1("first_train_ts", metadata), (Option<Object>)ReleasePredictionService.ensureOptionalLong$1("last_optimize_ts", metadata), metadata);
    }

    private Future<BoxedUnit> checkConnectionAsync() {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            try {
                ResponseEntity response = this.restTemplate((Option<java.time.Duration>)None$.MODULE$).getForEntity(this.getUrl(), java.util.Map.class, new Object[0]);
                scala.collection.mutable.Map data = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)response.getBody()).asScala();
                this.logger().info((Function0 & Serializable)() -> new StringBuilder(46).append("Connected to DevOpsML at ").append(this.getUrl()).append(": version ").append(data.apply((Object)"version")).append(", hostname ").append(data.apply((Object)"hostname")).toString());
            }
            catch (HttpStatusCodeException e) {
                this.logger().warn((Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(37).append("Could not connect to DevOpsML at ").append(this.getUrl()).append(": ").append(e.getStatusCode()).append(", ").toString()).append(String.valueOf(e.getResponseBodyAsString())).toString());
            }
        }, this.executionContext());
    }

    private String getUrl() {
        return this.config.getRootConfig().getString("xl.plugin.riskPredictions.xlDevopsMlUrl").replaceFirst("/$", "");
    }

    private String getTasksSchemaAsCsv() {
        Seq rows = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"category", (Object)"name", (Object)"task")})).$plus$plus((IterableOnce)((IterableOps)((IterableOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(DescriptorRegistry.getSubtypes((Type)Type.valueOf(PythonScript.class))).asScala()).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ReleasePredictionService.$anonfun$getTasksSchemaAsCsv$1(x$3)))).flatMap((Function1 & Serializable)t -> (Iterable)((IterableOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(t.getDescriptor().getPropertyDescriptors()).asScala()).map((Function1 & Serializable)prop -> new Tuple3((Object)prop.getCategory(), (Object)prop.getName(), (Object)t.toString()))));
        return ((IterableOnceOps)rows.map((Function1 & Serializable)r -> new StringBuilder(2).append(r._1()).append(",").append(r._2()).append(",").append(r._3()).toString())).mkString("\n");
    }

    public RestTemplate restTemplate(Option<java.time.Duration> timeout) {
        return this.restTemplates().computeIfAbsent(timeout, x0$1 -> {
            RestTemplate restTemplate;
            Some some;
            java.time.Duration duration;
            Option option = x0$1;
            if (option instanceof Some && (duration = (java.time.Duration)(some = (Some)option).value()) != null) {
                java.time.Duration duration2 = duration;
                HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
                factory.setConnectionRequestTimeout((int)duration2.toMillis());
                factory.setConnectTimeout((int)duration2.toMillis());
                factory.setReadTimeout((int)duration2.toMillis());
                restTemplate = new RestTemplate((ClientHttpRequestFactory)factory);
            } else {
                restTemplate = new RestTemplate();
            }
            return restTemplate;
        });
    }

    private String prepareReleaseJson(Release release) {
        return CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
    }

    public static final /* synthetic */ String $anonfun$requestModelMetadata$1(String modelName$1) {
        return new StringBuilder(30).append("Requesting metadata for model ").append(modelName$1).toString();
    }

    public static final /* synthetic */ String $anonfun$requestModelMetadata$2(String modelName$1, long duration$2, java.util.Map metadata$1) {
        return new StringBuilder(32).append("Got metadata for model ").append(modelName$1).append(" in ").append(duration$2).append(" ms: ").append(metadata$1).toString();
    }

    public static final /* synthetic */ ModelsMetadata $anonfun$requestModelMetadata$3(ReleasePredictionService $this, java.util.Map metadata$1) {
        return $this.parseReleaseModelMetadataResponse(metadata$1);
    }

    public static final /* synthetic */ Option $anonfun$requestModelMetadata$4(ModelsMetadata x$1) {
        return Option$.MODULE$.apply((Object)x$1);
    }

    public static final /* synthetic */ None$ $anonfun$requestModelMetadata$5() {
        return None$.MODULE$;
    }

    private static final Option ensureOptionalLong$1(String key, java.util.Map metadata$2) {
        None$ none$;
        if (!metadata$2.containsKey(key)) {
            throw new IllegalStateException(new StringBuilder(51).append("The '").append(key).append("' was not available in the metadata response: ").append(metadata$2).toString());
        }
        Object v = metadata$2.get(key);
        if (v == null) {
            none$ = None$.MODULE$;
        } else if (v instanceof Long) {
            long l = BoxesRunTime.unboxToLong(v);
            none$ = new Some((Object)BoxesRunTime.boxToLong((long)l));
        } else {
            throw new IllegalStateException(new StringBuilder(0).append(new StringBuilder(32).append("The '").append(key).append("' in metadata response was ").toString()).append(new StringBuilder(14).append("not a number: ").append(v).toString()).toString());
        }
        return none$;
    }

    public static final /* synthetic */ boolean $anonfun$getTasksSchemaAsCsv$1(Type x$3) {
        return !x$3.getDescriptor().isVirtual();
    }

    public ReleasePredictionService(XlrConfig config) {
        this.config = config;
        Logging.$init$((Logging)this);
        this.MODEL_RELEASE = "xlr_release_models";
        this.MODEL_TASKS = "xlr_task_models";
        this.RESPONSE_PREDICTION_IS_ABORTED = "prob_aborted";
        this.RESPONSE_PREDICTION_IS_RISKY = "prob_risk";
        this.objectMapper = new ObjectMapper();
        this.restTemplates = new ConcurrentHashMap();
    }
}

