/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.predictions.debug;

import com.xebialabs.deployit.core.xml.WriteWithoutPasswordCiConverter;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.api.v1.ReleaseApi;
import com.xebialabs.xlrelease.api.v1.TemplateApi;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.json.CiSerializerHelper$;
import com.xebialabs.xlrelease.plugins.predictions.debug.ArchiveRepository;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001\u0002\u0006\f\u0001aA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tY\u0001\u0011\t\u0011)A\u0005[!AQ\u0007\u0001B\u0001B\u0003%a\u0007C\u0003:\u0001\u0011\u0005!\bC\u0003O\u0001\u0011\u0005q\nC\u0003c\u0001\u0011\u00051\rC\u0003f\u0001\u0011\u0005a\rC\u0003i\u0001\u0011%\u0011\u000e\u0003\u0004\u0000\u0001\u0011%\u0011\u0011\u0001\u0002\u0012\u001b>$W\r\u001c#fEV<7+\u001a:wS\u000e,'B\u0001\u0007\u000e\u0003\u0015!WMY;h\u0015\tqq\"A\u0006qe\u0016$\u0017n\u0019;j_:\u001c(B\u0001\t\u0012\u0003\u001d\u0001H.^4j]NT!AE\n\u0002\u0013ad'/\u001a7fCN,'B\u0001\u000b\u0016\u0003%AXMY5bY\u0006\u00147OC\u0001\u0017\u0003\r\u0019w.\\\u0002\u0001'\r\u0001\u0011d\b\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0001*S\"A\u0011\u000b\u0005\t\u001a\u0013!B:mMRR'\"\u0001\u0013\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!AJ\u0011\u0003\u000f1{wmZ5oO\u0006Y\u0011M]2iSZ,'+\u001a9p!\tI#&D\u0001\f\u0013\tY3BA\tBe\u000eD\u0017N^3SKB|7/\u001b;pef\f!B]3mK\u0006\u001cX-\u00119j!\tq3'D\u00010\u0015\t\u0001\u0014'\u0001\u0002wc)\u0011!'E\u0001\u0004CBL\u0017B\u0001\u001b0\u0005)\u0011V\r\\3bg\u0016\f\u0005/[\u0001\fi\u0016l\u0007\u000f\\1uK\u0006\u0003\u0018\u000e\u0005\u0002/o%\u0011\u0001h\f\u0002\f)\u0016l\u0007\u000f\\1uK\u0006\u0003\u0018.\u0001\u0004=S:LGO\u0010\u000b\u0005wqjd\b\u0005\u0002*\u0001!)q\u0005\u0002a\u0001Q!)A\u0006\u0002a\u0001[!)Q\u0007\u0002a\u0001m!\u0012A\u0001\u0011\t\u0003\u00032k\u0011A\u0011\u0006\u0003\u0007\u0012\u000b!\"\u00198o_R\fG/[8o\u0015\t)e)A\u0004gC\u000e$xN]=\u000b\u0005\u001dC\u0015!\u00022fC:\u001c(BA%K\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A&\u0002\u0007=\u0014x-\u0003\u0002N\u0005\nI\u0011)\u001e;po&\u0014X\rZ\u0001\u0015IVl\u0007/\u0011:dQ&4X\r\u001a*fY\u0016\f7/Z:\u0015\u0007A[V\f\u0005\u0002R1:\u0011!K\u0016\t\u0003'ni\u0011\u0001\u0016\u0006\u0003+^\ta\u0001\u0010:p_Rt\u0014BA,\u001c\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011L\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005][\u0002\"\u0002/\u0006\u0001\u0004\u0001\u0016\u0001\u00029bi\"DQAX\u0003A\u0002}\u000bAb]6ja\u0016C\u0018n\u001d;j]\u001e\u0004\"A\u00071\n\u0005\u0005\\\"a\u0002\"p_2,\u0017M\\\u0001\u0013IVl\u0007/Q2uSZ,'+\u001a7fCN,7\u000f\u0006\u0002QI\")AL\u0002a\u0001!\u0006iA-^7q)\u0016l\u0007\u000f\\1uKN$\"\u0001U4\t\u000bq;\u0001\u0019\u0001)\u00021\u0011|wO\u001c7pC\u0012\u001cFO]3b[>3'+\u001a7fCN,7\u000fF\u0002k[z\u0004\"AG6\n\u00051\\\"\u0001B+oSRDQA\u001c\u0005A\u0002=\faB]3mK\u0006\u001cXm]*ue\u0016\fW\u000eE\u0002qkbt!!]:\u000f\u0005M\u0013\u0018\"\u0001\u000f\n\u0005Q\\\u0012a\u00029bG.\fw-Z\u0005\u0003m^\u0014aa\u0015;sK\u0006l'B\u0001;\u001c!\tIH0D\u0001{\u0015\tY\u0018#\u0001\u0004e_6\f\u0017N\\\u0005\u0003{j\u0014qAU3mK\u0006\u001cX\rC\u0003]\u0011\u0001\u0007\u0001+\u0001\u0005tCZ,g)\u001b7f)\u0015Q\u00171AA\u0004\u0011\u0019\t)!\u0003a\u0001!\u000691m\u001c8uK:$\bbBA\u0005\u0013\u0001\u0007\u00111B\u0001\u0005M&dW\r\u0005\u0003\u0002\u000e\u0005]QBAA\b\u0015\u0011\t\t\"a\u0005\u0002\u0005%|'BAA\u000b\u0003\u0011Q\u0017M^1\n\t\u0005e\u0011q\u0002\u0002\u0005\r&dW\rK\u0002\u0001\u0003;\u0001B!a\b\u0002&5\u0011\u0011\u0011\u0005\u0006\u0004\u0003GA\u0015AC:uKJ,w\u000e^=qK&!\u0011qEA\u0011\u0005%\u0019u.\u001c9p]\u0016tG\u000f")
public class ModelDebugService
implements Logging {
    private final ArchiveRepository archiveRepo;
    private final ReleaseApi releaseApi;
    private final TemplateApi templateApi;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ModelDebugService modelDebugService = this;
        synchronized (modelDebugService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public String dumpArchivedReleases(String path, boolean skipExisting) {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Start reading all archived releases into directory ").append(path).toString());
        Seq<String> releaseIds = this.archiveRepo.findAllReleaseIds();
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Found ").append(releaseIds.size()).append(" archived releases, start downloading them").toString());
        long start = System.currentTimeMillis();
        AtomicInteger progress = new AtomicInteger(0);
        releaseIds.foreach((Function1 & Serializable & scala.Serializable)releaseId -> {
            ModelDebugService.$anonfun$dumpArchivedReleases$3(this, path, skipExisting, progress, releaseIds, releaseId);
            return BoxedUnit.UNIT;
        });
        FiniteDuration duration = Duration$.MODULE$.apply((System.currentTimeMillis() - start) / 1000L, TimeUnit.SECONDS);
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Finished downloading ").append(releaseIds.size()).append(" releases to ").append(path).append(" in ").append(duration).toString());
        return new File(path).getAbsolutePath();
    }

    public String dumpActiveReleases(String path) {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Start downloading all releases from active database into directory ").append(path).toString());
        ReleasesFilters filters = new ReleasesFilters();
        filters.setPlanned(true);
        filters.setActive(true);
        filters.setInactive(true);
        AtomicInteger progress = new AtomicInteger(0);
        long start = System.currentTimeMillis();
        this.downloadStreamOfReleases((Stream<Release>)this.releasesStream$1(ModelDebugService.releasesStream$default$1$1(), filters, progress), path);
        FiniteDuration duration = Duration$.MODULE$.apply((System.currentTimeMillis() - start) / 1000L, TimeUnit.SECONDS);
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Finished downloading ").append(progress.get()).append(" releases to ").append(path).append(" in ").append(duration).toString());
        return new File(path).getAbsolutePath();
    }

    public String dumpTemplates(String path) {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Start downloading all templates into directory ").append(path).toString());
        AtomicInteger progress = new AtomicInteger(0);
        long start = System.currentTimeMillis();
        this.downloadStreamOfReleases((Stream<Release>)this.templatesStream$1(ModelDebugService.templatesStream$default$1$1(), progress), path);
        FiniteDuration duration = Duration$.MODULE$.apply((System.currentTimeMillis() - start) / 1000L, TimeUnit.SECONDS);
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Finished downloading ").append(progress.get()).append(" templates to ").append(path).append(" in ").append(duration).toString());
        return new File(path).getAbsolutePath();
    }

    private void downloadStreamOfReleases(Stream<Release> releasesStream, String path) {
        WriteWithoutPasswordCiConverter converter = new WriteWithoutPasswordCiConverter();
        releasesStream.foreach((Function1 & Serializable & scala.Serializable)release -> {
            ModelDebugService.$anonfun$downloadStreamOfReleases$1(this, converter, path, release);
            return BoxedUnit.UNIT;
        });
    }

    private void saveFile(String content, File file) {
        try (PrintWriter pw = null;){
            pw = new PrintWriter(file, "UTF-8");
            pw.write(content);
        }
    }

    public static final /* synthetic */ void $anonfun$dumpArchivedReleases$3(ModelDebugService $this, String path$1, boolean skipExisting$1, AtomicInteger progress$1, Seq releaseIds$1, String releaseId) {
        block6: {
            File file = new File(new StringBuilder(6).append(path$1).append("/").append(releaseId).append(".json").toString());
            if (skipExisting$1 && file.exists()) {
                $this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Skipping release as it already exists on disk: ").append(file).toString());
            } else {
                Try<String> try_ = $this.archiveRepo.readReleaseJson(releaseId);
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    String json = (String)success.value();
                    file.getParentFile().mkdirs();
                    $this.saveFile(json, file);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    $this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Could not read release ").append(releaseId).append(": ").append(e).toString(), (Function0 & Serializable & scala.Serializable)() -> e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError(try_);
                }
            }
            int nDone = progress$1.incrementAndGet();
            if (nDone % 1000 != 0) break block6;
            $this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("  downloaded ").append(nDone).append(" out of ").append(releaseIds$1.size()).append(" archived releases...").toString());
        }
    }

    private final Stream releasesStream$1(long page, ReleasesFilters filters$1, AtomicInteger progress$2) {
        Stream stream;
        List releases = this.releaseApi.searchReleases(filters$1, Predef$.MODULE$.long2Long(page), Predef$.MODULE$.long2Long(20L), false);
        if (releases.isEmpty()) {
            stream = package$.MODULE$.Stream().empty();
        } else {
            if (progress$2.get() / 1000 != (progress$2.get() + releases.size()) / 1000) {
                this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("  downloaded ").append(progress$2.get() + releases.size()).append(" active releases...").toString());
            }
            progress$2.set(progress$2.get() + releases.size());
            stream = (Stream)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(releases).asScala()).toStream().$plus$plus((GenTraversableOnce)this.releasesStream$1(page + 1L, filters$1, progress$2), Stream$.MODULE$.canBuildFrom());
        }
        return stream;
    }

    private static final long releasesStream$default$1$1() {
        return 0L;
    }

    private final Stream templatesStream$1(long page, AtomicInteger progress$3) {
        Stream stream;
        List templates = this.templateApi.getTemplates("", null, Predef$.MODULE$.long2Long(page), Predef$.MODULE$.long2Long(20L), Predef$.MODULE$.int2Integer(Integer.MAX_VALUE));
        if (templates.isEmpty()) {
            stream = package$.MODULE$.Stream().empty();
        } else {
            if (progress$3.get() / 1000 != (progress$3.get() + templates.size()) / 1000) {
                this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("  downloaded ").append(progress$3.get() + templates.size()).append(" templates...").toString());
            }
            progress$3.set(progress$3.get() + templates.size());
            stream = (Stream)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(templates).asScala()).toStream().$plus$plus((GenTraversableOnce)this.templatesStream$1(page + 1L, progress$3), Stream$.MODULE$.canBuildFrom());
        }
        return stream;
    }

    private static final long templatesStream$default$1$1() {
        return 0L;
    }

    public static final /* synthetic */ void $anonfun$downloadStreamOfReleases$1(ModelDebugService $this, WriteWithoutPasswordCiConverter converter$1, String path$4, Release release) {
        String json = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)converter$1);
        File file = new File(new StringBuilder(6).append(path$4).append("/").append(release.getId()).append(".json").toString());
        file.getParentFile().mkdirs();
        $this.saveFile(json, file);
    }

    @Autowired
    public ModelDebugService(ArchiveRepository archiveRepo, ReleaseApi releaseApi, TemplateApi templateApi) {
        this.archiveRepo = archiveRepo;
        this.releaseApi = releaseApi;
        this.templateApi = templateApi;
        Logging.$init$((Logging)this);
    }
}

