/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.predictions.risk;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plumbing.id.IdType;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.status.FlagStatus;
import com.xebialabs.xlrelease.plugins.predictions.service.ProbabilityThresholds;
import com.xebialabs.xlrelease.plugins.predictions.service.PythonServices;
import com.xebialabs.xlrelease.plugins.predictions.service.ReleasePrediction;
import com.xebialabs.xlrelease.plugins.predictions.service.ReleasePredictionService;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.riskassessors.RiskAssessor;
import java.time.Duration;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.util.Try;

@Metadata(label="ReleaseAbortionRiskAssessor", versioned=false)
public class ReleaseAbortionRiskAssessor
extends RiskAssessor {
    private static final Logger logger = LoggerFactory.getLogger(ReleaseAbortionRiskAssessor.class);
    private static final ProbabilityThresholds THRESHOLD_PROB_RELEASE_FAILED = new ProbabilityThresholds(0.4, 0.9);
    private static final ProbabilityThresholds THRESHOLD_PROB_RELEASE_ABORTED = new ProbabilityThresholds(0.5, 0.9);
    private ReleasePredictionService predictor = PythonServices.getReleasePredictionServiceInstance();
    private Boolean isXlr86Plus = null;

    public RiskAssessment execute(Release release, RiskProfile riskProfile) {
        RiskAssessment assessment = new RiskAssessment();
        assessment.setRiskAssessorId(this.getId());
        int scoreOfAbortionRisk = riskProfile.getValueFor(this.getType());
        if (scoreOfAbortionRisk <= 0) {
            logger.debug(String.format("ReleaseAbortionRiskAssessor was configured to contribute 0 to the risk, so skipping predictions request for %s", release));
            assessment.setScore(Integer.valueOf(0));
            assessment.setHeadline("Release is on track");
            return assessment;
        }
        Duration predictionTimeout = XlrConfig.getInstance().getRootConfig().getDuration("xl.plugin.riskPredictions.timeouts.riskAssessorPredictionsRequest");
        Try<ReleasePrediction> predictionTry = this.predictor.predict(release, (Option<Duration>)Option.apply((Object)predictionTimeout));
        if (predictionTry.isFailure()) {
            logger.error(String.format("Could not assess abortion risk of release %s: %s", release, predictionTry));
            assessment.setScore(Integer.valueOf(0));
            assessment.setHeadline("Release is on track");
        } else {
            FlagStatus maxRisk;
            ReleasePrediction prediction = (ReleasePrediction)predictionTry.get();
            FlagStatus riskFailed = THRESHOLD_PROB_RELEASE_FAILED.getLevel(prediction.probabilityIsRisky());
            FlagStatus riskAborted = THRESHOLD_PROB_RELEASE_ABORTED.getLevel(prediction.probabilityAborted());
            FlagStatus flagStatus = maxRisk = riskAborted.getRisk() > riskFailed.getRisk() ? riskAborted : riskFailed;
            if (maxRisk == FlagStatus.OK) {
                assessment.setScore(Integer.valueOf(0));
                assessment.setHeadline("Release is on track");
            } else {
                String level = maxRisk == FlagStatus.ATTENTION_NEEDED ? "medium" : "high";
                assessment.setHeadline(String.format("Release has %s predicted risk", level));
                assessment.setScore(Integer.valueOf(scoreOfAbortionRisk));
                String message = "Release ";
                if (riskFailed != FlagStatus.OK) {
                    message = message + "may have failures or delays " + this.getConfidenceMessage(prediction.probabilityIsRisky());
                }
                if (riskAborted != FlagStatus.OK) {
                    if (riskFailed != FlagStatus.OK) {
                        message = message + " and ";
                    }
                    message = message + "may be aborted " + this.getConfidenceMessage(prediction.probabilityAborted());
                }
                message = message + String.format(". See %s for more information.", this.getForecastPageMessage(release));
                assessment.setMessages(Collections.singletonList(message));
                if (this.getIsXlr86Plus()) {
                    assessment.setProperty("icon", (Object)"static/@project.version@/include/predictions/icons/radar.svg");
                }
            }
        }
        return assessment;
    }

    private String getConfidenceMessage(Double probability) {
        int percent = (int)Math.round(probability * 100.0);
        if (this.getIsXlr86Plus()) {
            return String.format("(_confidence %d%%_)", percent);
        }
        return String.format("(confidence %d%%)", percent);
    }

    private String getForecastPageMessage(Release release) {
        if (this.getIsXlr86Plus()) {
            String releaseUiId = IdType.DOMAIN.convertToViewId(release.getId());
            String url = String.format("#/releases/%s/forecast", releaseUiId);
            return String.format("[release forecast](%s)", url);
        }
        return "release page \"Forecast\"";
    }

    @VisibleForTesting
    void setPredictor(ReleasePredictionService predictor) {
        this.predictor = predictor;
    }

    private boolean getIsXlr86Plus() {
        if (this.isXlr86Plus == null) {
            this.isXlr86Plus = Type.valueOf(RiskAssessment.class).getDescriptor().getPropertyDescriptor("icon") != null;
        }
        return this.isXlr86Plus;
    }

    @VisibleForTesting
    void setIsXlr86Plus(boolean isXlr86Plus) {
        this.isXlr86Plus = isXlr86Plus;
    }
}

