/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.predictions.api;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.api.v1.ReleaseApi;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.plugins.predictions.service.ModelsMetadata;
import com.xebialabs.xlrelease.plugins.predictions.service.ReleasePredictionService;
import com.xebialabs.xlrelease.security.PermissionChecker;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.LambdaDeserialize;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Path(value="/api/predictions")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001B\u0001\u0003\u0001=\u0011a\u0002\u0015:fI&\u001cG/[8og\u0006\u0003\u0018N\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0005\u00151\u0011a\u00039sK\u0012L7\r^5p]NT!a\u0002\u0005\u0002\u000fAdWoZ5og*\u0011\u0011BC\u0001\nq2\u0014X\r\\3bg\u0016T!a\u0003\u0007\u0002\u0013a,'-[1mC\n\u001c(\"A\u0007\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\r\u0003\u0005\u0018\u0001\t\u0005\t\u0015!\u0003\u0019\u0003)\u0011X\r\\3bg\u0016\f\u0005/\u001b\t\u00033ui\u0011A\u0007\u0006\u00037q\t!A^\u0019\u000b\u0005\rA\u0011B\u0001\u0010\u001b\u0005)\u0011V\r\\3bg\u0016\f\u0005/\u001b\u0005\tA\u0001\u0011\t\u0011)A\u0005C\u0005A\"/\u001a7fCN,\u0007K]3eS\u000e$\u0018n\u001c8TKJ4\u0018nY3\u0011\u0005\t*S\"A\u0012\u000b\u0005\u0011\"\u0011aB:feZL7-Z\u0005\u0003M\r\u0012\u0001DU3mK\u0006\u001cX\r\u0015:fI&\u001cG/[8o'\u0016\u0014h/[2f\u0011!A\u0003A!A!\u0002\u0013I\u0013!\u00059fe6L7o]5p]\u000eCWmY6feB\u0011!&L\u0007\u0002W)\u0011A\u0006C\u0001\tg\u0016\u001cWO]5us&\u0011af\u000b\u0002\u0012!\u0016\u0014X.[:tS>t7\t[3dW\u0016\u0014\b\"\u0002\u0019\u0001\t\u0003\t\u0014A\u0002\u001fj]&$h\b\u0006\u00033iU2\u0004CA\u001a\u0001\u001b\u0005\u0011\u0001\"B\f0\u0001\u0004A\u0002\"\u0002\u00110\u0001\u0004\t\u0003\"\u0002\u00150\u0001\u0004I\u0003b\u0002\u001d\u0001\u0005\u0004%I!O\u0001\u0007Y><w-\u001a:\u0016\u0003i\u0002\"a\u000f!\u000e\u0003qR!!\u0010 \u0002\u000bMdg\r\u000e6\u000b\u0003}\n1a\u001c:h\u0013\t\tEH\u0001\u0004M_\u001e<WM\u001d\u0005\u0007\u0007\u0002\u0001\u000b\u0011\u0002\u001e\u0002\u000f1|wmZ3sA!)Q\t\u0001C\u0001\r\u0006)r-\u001a;SK2,\u0017m]3Qe\u0016$\u0017n\u0019;j_:\u001cHCA$T!\tA\u0015+D\u0001J\u0015\tQ5*\u0001\u0003d_J,'B\u0001'N\u0003\t\u00118O\u0003\u0002O\u001f\u0006\u0011qo\u001d\u0006\u0002!\u0006)!.\u0019<bq&\u0011!+\u0013\u0002\t%\u0016\u001c\bo\u001c8tK\")A\u000b\u0012a\u0001+\u0006I!/\u001a7fCN,\u0017\n\u001a\t\u0003-vs!aV.\u0011\u0005a\u0013R\"A-\u000b\u0005is\u0011A\u0002\u001fs_>$h(\u0003\u0002]%\u00051\u0001K]3eK\u001aL!AX0\u0003\rM#(/\u001b8h\u0015\ta&\u0003\u000b\u0003TC\u00164\u0007C\u00012d\u001b\u0005Y\u0015B\u00013L\u0005%\u0001\u0016\r\u001e5QCJ\fW.A\u0003wC2,X-I\u0001UQ\t!\u0005\u000e\u0005\u0002ja6\t!N\u0003\u0002lY\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u00055t\u0017aB7fiJL7m\u001d\u0006\u0003_2\t\u0001bY8eC\"\fG.Z\u0005\u0003c*\u0014Q\u0001V5nK\u0012DC\u0001R:fmB\u0011!\r^\u0005\u0003k.\u0013A\u0001U1uQ\u0006\nq/\u0001\r0e\u0016dW-Y:f_m\u0014X\r\\3bg\u0016LEM\u000f\u0018+\u007fuD#\u0001R=\u0011\u0005\tT\u0018BA>L\u0005\r9U\t\u0016\u0005\u0006{\u0002!\tA`\u0001\fiJ\f\u0017N\\'pI\u0016d7\u000f\u0006\u0003H\u007f\u00065\u0001BBA\u0001y\u0002\u0007Q+\u0001\u0005wC2LG-\u0019;fQ\u0019y\u0018QA3\u0002\fA\u0019!-a\u0002\n\u0007\u0005%1J\u0001\u0006Rk\u0016\u0014\u0018\u0010U1sC6\f#!!\u0001\t\r\u0005=A\u00101\u0001V\u0003!y\u0007\u000f^5nSj,\u0007fBA\u0007\u0003\u000b)\u00171C\u0011\u0003\u0003\u001fA#\u0001 5)\u000bq\u001cX-!\u0007\"\u0005\u0005m\u0011AB\u0018ue\u0006Lg\u000eK\u0002}\u0003?\u00012AYA\u0011\u0013\r\t\u0019c\u0013\u0002\u0005!>\u001bF\u000bC\u0004\u0002(\u0001!\t!!\u000b\u0002!\u001d,G/T8eK2lU\r^1eCR\fW#A$)\u0007\u0005\u0015\u0002\u000e\u000b\u0004\u0002&M,\u0017qF\u0011\u0003\u0003c\taaL7pI\u0016d\u0007fAA\u0013s\"9\u0011q\u0007\u0001\u0005\n\u0005e\u0012AC4fiJ+G.Z1tKR!\u00111HA*!\u0019\ti$a\u0011\u0002H5\u0011\u0011q\b\u0006\u0004\u0003\u0003\u0012\u0012\u0001B;uS2LA!!\u0012\u0002@\t\u0019AK]=\u0011\t\u0005%\u0013qJ\u0007\u0003\u0003\u0017R1!!\u0014\t\u0003\u0019!w.\\1j]&!\u0011\u0011KA&\u0005\u001d\u0011V\r\\3bg\u0016Da\u0001VA\u001b\u0001\u0004)\u0006f\u0001\u0001\u0002XA!\u0011\u0011LA2\u001b\t\tYF\u0003\u0003\u0002^\u0005}\u0013AC:uKJ,w\u000e^=qK*\u0019\u0011\u0011\r \u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.LA!!\u001a\u0002\\\tI1i\\7q_:,g\u000e\u001e\u0015\u0007\u0001\u0005%T-a\u001c\u0011\u0007\t\fY'C\u0002\u0002n-\u0013\u0001\u0002\u0015:pIV\u001cWm\u001d\u0017\u0003\u0003c\n#!a\u001d\u0002!\u0005\u0004\b\u000f\\5dCRLwN\\\u0018kg>t\u0007F\u0002\u0001\u0002x\u0015\fi\bE\u0002c\u0003sJ1!a\u001fL\u0005!\u0019uN\\:v[\u0016\u001cHFAA9Q\u0015\u00011/ZAAC\t\t\u0019)\u0001\t0CBLw\u0006\u001d:fI&\u001cG/[8og\u0002")
public class PredictionsApi {
    public final ReleaseApi com$xebialabs$xlrelease$plugins$predictions$api$PredictionsApi$$releaseApi;
    private final ReleasePredictionService releasePredictionService;
    private final PermissionChecker permissionChecker;
    private final Logger logger;

    private Logger logger() {
        return this.logger;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Path(value="/release/{releaseId:.*?}")
    @Timed
    public Response getReleasePredictions(@PathParam(value="releaseId") String releaseId) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = this.getRelease(releaseId).flatMap((Function1 & Serializable & scala.Serializable)release -> $this.releasePredictionService.predictRaw((Release)release).map((Function1 & Serializable & scala.Serializable)predictionsData -> predictionsData));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String data = (String)success.value();
            return Response.ok((Object)data).type("application/json").build();
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof NotFoundException) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find release by ID ", " in active or archived databases"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId}))).build();
            }
        }
        if (!bl) throw new MatchError((Object)try_);
        Throwable e = failure.exception();
        this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not get predictions for release ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId, e.getMessage()})), e);
        return Response.serverError().entity((Object)e.getMessage()).build();
    }

    @POST
    @Path(value="/train")
    @Timed
    public Response trainModels(@QueryParam(value="validate") String validate, @QueryParam(value="optimize") String optimize) {
        Response response;
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        Try<String> try_ = this.releasePredictionService.train(Predef$.MODULE$.Boolean2boolean(Boolean.valueOf(validate)), Predef$.MODULE$.Boolean2boolean(Boolean.valueOf(optimize)));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String data = (String)success.value();
            response = Response.ok((Object)data).type("application/json").build();
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not train models: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getMessage()})), e);
            response = Response.serverError().entity((Object)e.getMessage()).build();
        } else {
            throw new MatchError(try_);
        }
        return response;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Path(value="/model")
    @Timed
    public Response getModelMetadata() {
        Option option;
        this.permissionChecker.check(PlatformPermissions.ADMIN);
        boolean bl = false;
        Success success = null;
        Try<Option<ModelsMetadata>> try_ = this.releasePredictionService.requestModelMetadata();
        if (try_ instanceof Success) {
            bl = true;
            success = (Success)try_;
            Option option2 = (Option)success.value();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                ModelsMetadata metadata = (ModelsMetadata)some.value();
                return Response.ok(metadata.raw()).type("application/json").build();
            }
        }
        if (bl && None$.MODULE$.equals(option = (Option)success.value())) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Prediction models have not yet been trained"})).s((Seq)Nil$.MODULE$)).build();
        }
        if (!(try_ instanceof Failure)) throw new MatchError(try_);
        Failure failure = (Failure)try_;
        Throwable e = failure.exception();
        this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not get models metadata: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getMessage()})), e);
        return Response.serverError().entity((Object)e.getMessage()).build();
    }

    private Try<Release> getRelease(String releaseId) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> $this.com$xebialabs$xlrelease$plugins$predictions$api$PredictionsApi$$releaseApi.getRelease(releaseId)).recoverWith((PartialFunction)new scala.Serializable(this, releaseId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PredictionsApi $outer;
            private final String releaseId$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1 instanceof NotFoundException ? Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> $this.$outer.com$xebialabs$xlrelease$plugins$predictions$api$PredictionsApi$$releaseApi.getArchivedRelease($this.releaseId$1)) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof NotFoundException;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.releaseId$1 = releaseId$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.xebialabs.xlrelease.plugins.predictions.api.PredictionsApi$$anonfun$getRelease$2 )}, serializedLambda);
            }
        });
    }

    public PredictionsApi(ReleaseApi releaseApi, ReleasePredictionService releasePredictionService, PermissionChecker permissionChecker) {
        this.com$xebialabs$xlrelease$plugins$predictions$api$PredictionsApi$$releaseApi = releaseApi;
        this.releasePredictionService = releasePredictionService;
        this.permissionChecker = permissionChecker;
        this.logger = LoggerFactory.getLogger(PredictionsApi.class);
    }
}

