/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.predictions.debug;

import com.xebialabs.deployit.core.xml.WriteWithoutPasswordCiConverter;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.api.v1.ReleaseApi;
import com.xebialabs.xlrelease.api.v1.TemplateApi;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.json.CiSerializerHelper$;
import com.xebialabs.xlrelease.plugins.predictions.debug.ArchiveRepository;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\u0001\u0003\u0001=\u0011\u0011#T8eK2$UMY;h'\u0016\u0014h/[2f\u0015\t\u0019A!A\u0003eK\n,xM\u0003\u0002\u0006\r\u0005Y\u0001O]3eS\u000e$\u0018n\u001c8t\u0015\t9\u0001\"A\u0004qYV<\u0017N\\:\u000b\u0005%Q\u0011!\u0003=me\u0016dW-Y:f\u0015\tYA\"A\u0005yK\nL\u0017\r\\1cg*\tQ\"A\u0002d_6\u001c\u0001aE\u0002\u0001!Y\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007CA\f\u001d\u001b\u0005A\"BA\r\u001b\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005Y\u0012\u0001C4sSjTH.\u001a3\n\u0005uA\"a\u0002'pO\u001eLgn\u001a\u0005\t?\u0001\u0011\t\u0011)A\u0005A\u0005Y\u0011M]2iSZ,'+\u001a9p!\t\t#%D\u0001\u0003\u0013\t\u0019#AA\tBe\u000eD\u0017N^3SKB|7/\u001b;pefD\u0001\"\n\u0001\u0003\u0002\u0003\u0006IAJ\u0001\u000be\u0016dW-Y:f\u0003BL\u0007CA\u0014-\u001b\u0005A#BA\u0015+\u0003\t1\u0018G\u0003\u0002,\u0011\u0005\u0019\u0011\r]5\n\u00055B#A\u0003*fY\u0016\f7/Z!qS\"Aq\u0006\u0001B\u0001B\u0003%\u0001'A\u0006uK6\u0004H.\u0019;f\u0003BL\u0007CA\u00142\u0013\t\u0011\u0004FA\u0006UK6\u0004H.\u0019;f\u0003BL\u0007\"\u0002\u001b\u0001\t\u0003)\u0014A\u0002\u001fj]&$h\b\u0006\u00037oaJ\u0004CA\u0011\u0001\u0011\u0015y2\u00071\u0001!\u0011\u0015)3\u00071\u0001'\u0011\u0015y3\u00071\u00011Q\t\u00194\b\u0005\u0002=\u000f6\tQH\u0003\u0002?\u007f\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005\u0001\u000b\u0015a\u00024bGR|'/\u001f\u0006\u0003\u0005\u000e\u000bQAY3b]NT!\u0001R#\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011AR\u0001\u0004_J<\u0017B\u0001%>\u0005%\tU\u000f^8xSJ,G\rC\u0003K\u0001\u0011\u00051*\u0001\u000bek6\u0004\u0018I]2iSZ,GMU3mK\u0006\u001cXm\u001d\u000b\u0004\u0019^K\u0006CA'U\u001d\tq%\u000b\u0005\u0002P%5\t\u0001K\u0003\u0002R\u001d\u00051AH]8pizJ!a\u0015\n\u0002\rA\u0013X\rZ3g\u0013\t)fK\u0001\u0004TiJLgn\u001a\u0006\u0003'JAQ\u0001W%A\u00021\u000bA\u0001]1uQ\")!,\u0013a\u00017\u0006a1o[5q\u000bbL7\u000f^5oOB\u0011\u0011\u0003X\u0005\u0003;J\u0011qAQ8pY\u0016\fg\u000eC\u0003`\u0001\u0011\u0005\u0001-\u0001\nek6\u0004\u0018i\u0019;jm\u0016\u0014V\r\\3bg\u0016\u001cHC\u0001'b\u0011\u0015Af\f1\u0001M\u0011\u0015\u0019\u0007\u0001\"\u0001e\u00035!W/\u001c9UK6\u0004H.\u0019;fgR\u0011A*\u001a\u0005\u00061\n\u0004\r\u0001\u0014\u0005\u0006O\u0002!I\u0001[\u0001\u0019I><h\u000e\\8bIN#(/Z1n\u001f\u001a\u0014V\r\\3bg\u0016\u001cHcA5m{B\u0011\u0011C[\u0005\u0003WJ\u0011A!\u00168ji\")QN\u001aa\u0001]\u0006q!/\u001a7fCN,7o\u0015;sK\u0006l\u0007cA8uo:\u0011\u0001O\u001d\b\u0003\u001fFL\u0011aE\u0005\u0003gJ\tq\u0001]1dW\u0006<W-\u0003\u0002vm\n11\u000b\u001e:fC6T!a\u001d\n\u0011\u0005a\\X\"A=\u000b\u0005iD\u0011A\u00023p[\u0006Lg.\u0003\u0002}s\n9!+\u001a7fCN,\u0007\"\u0002-g\u0001\u0004a\u0005BB@\u0001\t\u0013\t\t!\u0001\u0005tCZ,g)\u001b7f)\u0015I\u00171AA\u0004\u0011\u0019\t)A a\u0001\u0019\u000691m\u001c8uK:$\bbBA\u0005}\u0002\u0007\u00111B\u0001\u0005M&dW\r\u0005\u0003\u0002\u000e\u0005]QBAA\b\u0015\u0011\t\t\"a\u0005\u0002\u0005%|'BAA\u000b\u0003\u0011Q\u0017M^1\n\t\u0005e\u0011q\u0002\u0002\u0005\r&dW\rK\u0002\u0001\u0003;\u0001B!a\b\u0002&5\u0011\u0011\u0011\u0005\u0006\u0004\u0003G\u0019\u0015AC:uKJ,w\u000e^=qK&!\u0011qEA\u0011\u0005%\u0019u.\u001c9p]\u0016tG\u000f")
public class ModelDebugService
implements Logging {
    private final ArchiveRepository archiveRepo;
    private final ReleaseApi releaseApi;
    private final TemplateApi templateApi;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ModelDebugService modelDebugService = this;
        synchronized (modelDebugService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public String dumpArchivedReleases(String path, boolean skipExisting) {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Start reading all archived releases into directory ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
        Seq<String> releaseIds = this.archiveRepo.findAllReleaseIds();
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " archived releases, start downloading them"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)releaseIds.size())})));
        long start = System.currentTimeMillis();
        AtomicInteger progress = new AtomicInteger(0);
        releaseIds.foreach((Function1 & Serializable & scala.Serializable)releaseId -> {
            ModelDebugService.$anonfun$dumpArchivedReleases$3(this, path, skipExisting, releaseIds, progress, releaseId);
            return BoxedUnit.UNIT;
        });
        FiniteDuration duration = Duration$.MODULE$.apply((System.currentTimeMillis() - start) / 1000L, TimeUnit.SECONDS);
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finished downloading ", " releases to ", " in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)releaseIds.size()), path, duration})));
        return new File(path).getAbsolutePath();
    }

    public String dumpActiveReleases(String path) {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Start downloading all releases from active database into directory ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
        ReleasesFilters filters = new ReleasesFilters();
        filters.setPlanned(true);
        filters.setActive(true);
        filters.setInactive(true);
        AtomicInteger progress = new AtomicInteger(0);
        long start = System.currentTimeMillis();
        this.downloadStreamOfReleases((Stream<Release>)this.releasesStream$1(ModelDebugService.releasesStream$default$1$1(), filters, progress), path);
        FiniteDuration duration = Duration$.MODULE$.apply((System.currentTimeMillis() - start) / 1000L, TimeUnit.SECONDS);
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finished downloading ", " releases to ", " in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)progress.get()), path, duration})));
        return new File(path).getAbsolutePath();
    }

    public String dumpTemplates(String path) {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Start downloading all templates into directory ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
        AtomicInteger progress = new AtomicInteger(0);
        long start = System.currentTimeMillis();
        this.downloadStreamOfReleases((Stream<Release>)this.templatesStream$1(ModelDebugService.templatesStream$default$1$1(), progress), path);
        FiniteDuration duration = Duration$.MODULE$.apply((System.currentTimeMillis() - start) / 1000L, TimeUnit.SECONDS);
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finished downloading ", " templates to ", " in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)progress.get()), path, duration})));
        return new File(path).getAbsolutePath();
    }

    private void downloadStreamOfReleases(Stream<Release> releasesStream, String path) {
        WriteWithoutPasswordCiConverter converter = new WriteWithoutPasswordCiConverter();
        releasesStream.foreach((Function1 & Serializable & scala.Serializable)release -> {
            ModelDebugService.$anonfun$downloadStreamOfReleases$1(this, path, converter, release);
            return BoxedUnit.UNIT;
        });
    }

    private void saveFile(String content, File file) {
        try (PrintWriter pw = null;){
            pw = new PrintWriter(file, "UTF-8");
            pw.write(content);
        }
    }

    public static final /* synthetic */ void $anonfun$dumpArchivedReleases$3(ModelDebugService $this, String path$1, boolean skipExisting$1, Seq releaseIds$1, AtomicInteger progress$1, String releaseId) {
        block6: {
            File file = new File(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ".json"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path$1, releaseId})));
            if (skipExisting$1 && file.exists()) {
                $this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Skipping release as it already exists on disk: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})));
            } else {
                Try<String> try_ = $this.archiveRepo.readReleaseJson(releaseId);
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    String json = (String)success.value();
                    file.getParentFile().mkdirs();
                    $this.saveFile(json, file);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    $this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not read release ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId, e})), (Function0 & Serializable & scala.Serializable)() -> e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError(try_);
                }
            }
            int nDone = progress$1.incrementAndGet();
            if (nDone % 1000 != 0) break block6;
            $this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  downloaded ", " out of ", " archived releases..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)nDone), BoxesRunTime.boxToInteger((int)releaseIds$1.size())})));
        }
    }

    private final Stream releasesStream$1(long page, ReleasesFilters filters$1, AtomicInteger progress$2) {
        Stream stream;
        List releases = this.releaseApi.searchReleases(filters$1, Predef$.MODULE$.long2Long(page), Predef$.MODULE$.long2Long(20L));
        if (releases.isEmpty()) {
            stream = package$.MODULE$.Stream().empty();
        } else {
            if (progress$2.get() / 1000 != progress$2.get() / 1000) {
                this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  downloaded ", " active releases..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(progress$2.get() + releases.size()))})));
            }
            progress$2.set(progress$2.get() + releases.size());
            stream = (Stream)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(releases).asScala()).toStream().$plus$plus((GenTraversableOnce)this.releasesStream$1(page + 1L, filters$1, progress$2), Stream$.MODULE$.canBuildFrom());
        }
        return stream;
    }

    private static final long releasesStream$default$1$1() {
        return 0L;
    }

    private final Stream templatesStream$1(long page, AtomicInteger progress$3) {
        Stream stream;
        List templates = this.templateApi.getTemplates("", null, Predef$.MODULE$.long2Long(page), Predef$.MODULE$.long2Long(20L), Predef$.MODULE$.int2Integer(Integer.MAX_VALUE));
        if (templates.isEmpty()) {
            stream = package$.MODULE$.Stream().empty();
        } else {
            if (progress$3.get() / 1000 != progress$3.get() / 1000) {
                this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  downloaded ", " templates..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(progress$3.get() + templates.size()))})));
            }
            progress$3.set(progress$3.get() + templates.size());
            stream = (Stream)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(templates).asScala()).toStream().$plus$plus((GenTraversableOnce)this.templatesStream$1(page + 1L, progress$3), Stream$.MODULE$.canBuildFrom());
        }
        return stream;
    }

    private static final long templatesStream$default$1$1() {
        return 0L;
    }

    public static final /* synthetic */ void $anonfun$downloadStreamOfReleases$1(ModelDebugService $this, String path$4, WriteWithoutPasswordCiConverter converter$1, Release release) {
        String json = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)converter$1);
        File file = new File(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ".json"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path$4, release.getId()})));
        file.getParentFile().mkdirs();
        $this.saveFile(json, file);
    }

    @Autowired
    public ModelDebugService(ArchiveRepository archiveRepo, ReleaseApi releaseApi, TemplateApi templateApi) {
        this.archiveRepo = archiveRepo;
        this.releaseApi = releaseApi;
        this.templateApi = templateApi;
        Logging.$init$((Logging)this);
    }
}

