/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.predictions.debug;

import com.xebialabs.xlrelease.plugins.predictions.debug.ArchiveRepository;
import com.xebialabs.xlrelease.plugins.predictions.service.PythonServices$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@Component
@ScalaSignature(bytes="\u0006\u0001E4A!\u0001\u0002\u0001\u001f\t\tRj\u001c3fY\u0012+'-^4TKJ4\u0018nY3\u000b\u0005\r!\u0011!\u00023fEV<'BA\u0003\u0007\u0003-\u0001(/\u001a3jGRLwN\\:\u000b\u0005\u001dA\u0011a\u00029mk\u001eLgn\u001d\u0006\u0003\u0013)\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005-a\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005i\u0011aA2p[\u000e\u00011c\u0001\u0001\u0011-A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"a\u0006\u000f\u000e\u0003aQ!!\u0007\u000e\u0002\u000bMdg\r\u000e6\u000b\u0003m\t\u0001b\u001a:jujdW\rZ\u0005\u0003;a\u0011q\u0001T8hO&tw\r\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u0003-\t'o\u00195jm\u0016\u0014V\r]8\u0011\u0005\u0005\u0012S\"\u0001\u0002\n\u0005\r\u0012!!E!sG\"Lg/\u001a*fa>\u001c\u0018\u000e^8ss\")Q\u0005\u0001C\u0001M\u00051A(\u001b8jiz\"\"a\n\u0015\u0011\u0005\u0005\u0002\u0001\"B\u0010%\u0001\u0004\u0001\u0003F\u0001\u0013+!\tYc'D\u0001-\u0015\tic&\u0001\u0006b]:|G/\u0019;j_:T!a\f\u0019\u0002\u000f\u0019\f7\r^8ss*\u0011\u0011GM\u0001\u0006E\u0016\fgn\u001d\u0006\u0003gQ\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002k\u0005\u0019qN]4\n\u0005]b#!C!vi><\u0018N]3e\u0011\u0015I\u0004\u0001\"\u0001;\u0003Q!W/\u001c9Be\u000eD\u0017N^3e%\u0016dW-Y:fgR\u00191H\u0012%\u0011\u0005q\u001aeBA\u001fB!\tq$#D\u0001@\u0015\t\u0001e\"\u0001\u0004=e>|GOP\u0005\u0003\u0005J\ta\u0001\u0015:fI\u00164\u0017B\u0001#F\u0005\u0019\u0019FO]5oO*\u0011!I\u0005\u0005\u0006\u000fb\u0002\raO\u0001\u0005a\u0006$\b\u000eC\u0003Jq\u0001\u0007!*\u0001\u0007tW&\u0004X\t_5ti&tw\r\u0005\u0002\u0012\u0017&\u0011AJ\u0005\u0002\b\u0005>|G.Z1o\u0011\u0015q\u0005\u0001\"\u0003P\u0003!\u0019\u0018M^3GS2,Gc\u0001)T+B\u0011\u0011#U\u0005\u0003%J\u0011A!\u00168ji\")A+\u0014a\u0001w\u000591m\u001c8uK:$\b\"\u0002,N\u0001\u00049\u0016\u0001\u00024jY\u0016\u0004\"\u0001W/\u000e\u0003eS!AW.\u0002\u0005%|'\"\u0001/\u0002\t)\fg/Y\u0005\u0003=f\u0013AAR5mK\")\u0001\r\u0001C\u0001C\u0006!\u0011N\\5u)\u0005\u0001\u0006FA0d!\t!\u0007.D\u0001f\u0015\ticMC\u0001h\u0003\u0015Q\u0017M^1y\u0013\tIWMA\u0007Q_N$8i\u001c8tiJ,8\r\u001e\u0015\u0003\u0001-\u0004\"\u0001\\8\u000e\u00035T!A\u001c\u001a\u0002\u0015M$XM]3pif\u0004X-\u0003\u0002q[\nI1i\\7q_:,g\u000e\u001e")
public class ModelDebugService
implements Logging {
    private final ArchiveRepository archiveRepo;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ModelDebugService modelDebugService = this;
        synchronized (modelDebugService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public String dumpArchivedReleases(String path, boolean skipExisting) {
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Start reading all archived releases into directory ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
        Seq<String> releaseIds = this.archiveRepo.findAllReleaseIds();
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " archived releases, start downloading them"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)releaseIds.size())})));
        long start = System.currentTimeMillis();
        AtomicInteger progress = new AtomicInteger(0);
        releaseIds.foreach((Function1 & Serializable & scala.Serializable)releaseId -> {
            ModelDebugService.$anonfun$dumpArchivedReleases$3(this, path, skipExisting, releaseIds, progress, releaseId);
            return BoxedUnit.UNIT;
        });
        FiniteDuration duration = Duration$.MODULE$.apply((System.currentTimeMillis() - start) / 1000L, TimeUnit.SECONDS);
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finished downloading ", " releases to ", " in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)releaseIds.size()), path, duration})));
        return new File(path).getAbsolutePath();
    }

    private void saveFile(String content, File file) {
        try (PrintWriter pw = null;){
            pw = new PrintWriter(file, "UTF-8");
            pw.write(content);
        }
    }

    @PostConstruct
    public void init() {
        PythonServices$.MODULE$.modelDebugService().set(this);
    }

    public static final /* synthetic */ void $anonfun$dumpArchivedReleases$3(ModelDebugService $this, String path$1, boolean skipExisting$1, Seq releaseIds$1, AtomicInteger progress$1, String releaseId) {
        block6: {
            File file = new File(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ".json"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path$1, releaseId})));
            if (skipExisting$1 && file.exists()) {
                $this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Skipping release as it already exists on disk: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})));
            } else {
                Try<String> try_ = $this.archiveRepo.readReleaseJson(releaseId);
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    String json = (String)success.value();
                    file.getParentFile().mkdirs();
                    $this.saveFile(json, file);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    $this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not read release ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId, e})), (Function0 & Serializable & scala.Serializable)() -> e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError(try_);
                }
            }
            int nDone = progress$1.incrementAndGet();
            if (nDone % 1000 != 0) break block6;
            $this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  downloaded ", " out of ", " archived releases..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)nDone), BoxesRunTime.boxToInteger((int)releaseIds$1.size())})));
        }
    }

    @Autowired
    public ModelDebugService(ArchiveRepository archiveRepo) {
        this.archiveRepo = archiveRepo;
        Logging.$init$((Logging)this);
    }
}

