/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.predictions.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.core.xml.WriteWithoutPasswordCiConverter;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.json.CiSerializerHelper$;
import com.xebialabs.xlrelease.plugins.predictions.service.PythonServices$;
import com.xebialabs.xlrelease.plugins.predictions.service.ReleasePrediction;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@DependsOn(value={"serviceStarter"})
@Autowired
@ScalaSignature(bytes="\u0006\u0001\t}b\u0001B\u0001\u0003\u0001=\u0011\u0001DU3mK\u0006\u001cX\r\u0015:fI&\u001cG/[8o'\u0016\u0014h/[2f\u0015\t\u0019A!A\u0004tKJ4\u0018nY3\u000b\u0005\u00151\u0011a\u00039sK\u0012L7\r^5p]NT!a\u0002\u0005\u0002\u000fAdWoZ5og*\u0011\u0011BC\u0001\nq2\u0014X\r\\3bg\u0016T!a\u0003\u0007\u0002\u0013a,'-[1mC\n\u001c(\"A\u0007\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001\u0001b\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0003/qi\u0011\u0001\u0007\u0006\u00033i\tQa\u001d7gi)T\u0011aG\u0001\tOJL'P\u001f7fI&\u0011Q\u0004\u0007\u0002\b\u0019><w-\u001b8h\u0011!y\u0002A!A!\u0002\u0013\u0001\u0013!C:dQ\u0016$W\u000f\\3s!\t\ts%D\u0001#\u0015\ty2E\u0003\u0002%K\u0005A\u0001\u000f\\;nE&twM\u0003\u0002'\u0015\u0005AA-\u001a9m_fLG/\u0003\u0002)E\tI1k\u00195fIVdWM\u001d\u0005\tU\u0001\u0011\t\u0011)A\u0005W\u000511m\u001c8gS\u001e\u0004\"\u0001\f\u0018\u000e\u00035R!A\u000b\u0005\n\u0005=j#!\u0003-me\u000e{gNZ5h\u0011\u0015\t\u0004\u0001\"\u00013\u0003\u0019a\u0014N\\5u}Q\u00191'\u000e\u001c\u0011\u0005Q\u0002Q\"\u0001\u0002\t\u000b}\u0001\u0004\u0019\u0001\u0011\t\u000b)\u0002\u0004\u0019A\u0016\t\u000fa\u0002!\u0019!C\u0005s\u0005iQj\u0014#F\u0019~\u0013V\tT#B'\u0016+\u0012A\u000f\t\u0003w\u0001k\u0011\u0001\u0010\u0006\u0003{y\nA\u0001\\1oO*\tq(\u0001\u0003kCZ\f\u0017BA!=\u0005\u0019\u0019FO]5oO\"11\t\u0001Q\u0001\ni\na\"T(E\u000b2{&+\u0012'F\u0003N+\u0005\u0005C\u0004F\u0001\t\u0007I\u0011B\u001d\u0002\u00175{E)\u0012'`)\u0006\u001b6j\u0015\u0005\u0007\u000f\u0002\u0001\u000b\u0011\u0002\u001e\u0002\u00195{E)\u0012'`)\u0006\u001b6j\u0015\u0011\t\u000f%\u0003!\u0019!C\u0005s\u0005q\"+R*Q\u001f:\u001bVi\u0018)S\u000b\u0012K5\tV%P\u001d~K5kX!C\u001fJ#V\t\u0012\u0005\u0007\u0017\u0002\u0001\u000b\u0011\u0002\u001e\u0002?I+5\u000bU(O'\u0016{\u0006KU#E\u0013\u000e#\u0016j\u0014(`\u0013N{\u0016IQ(S)\u0016#\u0005\u0005C\u0004N\u0001\t\u0007I\u0011B\u001d\u00029I+5\u000bU(O'\u0016{\u0006KU#E\u0013\u000e#\u0016j\u0014(`\u0013N{&+S*L3\"1q\n\u0001Q\u0001\ni\nQDU#T!>s5+R0Q%\u0016#\u0015j\u0011+J\u001f:{\u0016jU0S\u0013N[\u0015\f\t\u0005\b#\u0002\u0011\r\u0011\"\u0003S\u00031y'M[3di6\u000b\u0007\u000f]3s+\u0005\u0019\u0006C\u0001+\\\u001b\u0005)&B\u0001,X\u0003!!\u0017\r^1cS:$'B\u0001-Z\u0003\u001dQ\u0017mY6t_:T!A\u0017\u0007\u0002\u0013\u0019\f7\u000f^3sq6d\u0017B\u0001/V\u00051y%M[3di6\u000b\u0007\u000f]3s\u0011\u0019q\u0006\u0001)A\u0005'\u0006iqN\u00196fGRl\u0015\r\u001d9fe\u0002Ba\u0001\u0019\u0001\u0005\u0004\t\t\u0017\u0001E3yK\u000e,H/[8o\u0007>tG/\u001a=u+\u0005\u0011\u0007CA2g\u001b\u0005!'BA3\u0013\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003O\u0012\u0014\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\t\u000f%\u0004!\u0019!C\u0005U\u0006i!/Z:u)\u0016l\u0007\u000f\\1uKN,\u0012a\u001b\t\u0005YB\u001480D\u0001n\u0015\t)gN\u0003\u0002p}\u0005!Q\u000f^5m\u0013\t\tXNA\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCB\u00042!E:v\u0013\t!(C\u0001\u0004PaRLwN\u001c\t\u0003mfl\u0011a\u001e\u0006\u0003qz\nA\u0001^5nK&\u0011!p\u001e\u0002\t\tV\u0014\u0018\r^5p]B\u0019A0a\u0003\u000e\u0003uT!A`@\u0002\r\rd\u0017.\u001a8u\u0015\u0011\t\t!a\u0001\u0002\u0007],'M\u0003\u0003\u0002\u0006\u0005\u001d\u0011aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0005\u0005%\u0011aA8sO&\u0019\u0011QB?\u0003\u0019I+7\u000f\u001e+f[Bd\u0017\r^3\t\u000f\u0005E\u0001\u0001)A\u0005W\u0006q!/Z:u)\u0016l\u0007\u000f\\1uKN\u0004\u0003bBA\u000b\u0001\u0011\u0005\u0011qC\u0001\u0005S:LG\u000f\u0006\u0002\u0002\u001aA\u0019\u0011#a\u0007\n\u0007\u0005u!C\u0001\u0003V]&$\b\u0006BA\n\u0003C\u0001B!a\t\u0002.5\u0011\u0011Q\u0005\u0006\u0005\u0003O\tI#\u0001\u0006b]:|G/\u0019;j_:T!!a\u000b\u0002\u000b)\fg/\u0019=\n\t\u0005=\u0012Q\u0005\u0002\u000e!>\u001cHoQ8ogR\u0014Xo\u0019;\t\u000f\u0005M\u0002\u0001\"\u0001\u00026\u0005)AO]1j]R\u0011\u0011q\u0007\t\u0007\u0003s\ti$!\u0011\u000e\u0005\u0005m\"BA8\u0013\u0013\u0011\ty$a\u000f\u0003\u0007Q\u0013\u0018\u0010\u0005\u0003\u0002D\u0005Ec\u0002BA#\u0003\u001b\u00022!a\u0012\u0013\u001b\t\tIEC\u0002\u0002L9\ta\u0001\u0010:p_Rt\u0014bAA(%\u00051\u0001K]3eK\u001aL1!QA*\u0015\r\tyE\u0005\u0005\t\u0003/\u0002A\u0011\u0001\u0002\u0002Z\u0005a!/Z<sSR,GIY+sYR1\u0011\u0011IA.\u0003?B\u0001\"!\u0018\u0002V\u0001\u0007\u0011\u0011I\u0001\u0006I\n,&\u000f\u001c\u0005\t\u0003C\n)\u00061\u0001\u0002d\u0005a!/Z<sSR,'+\u001e7fgB!\u0011QMA7\u001b\t\t9GC\u0002+\u0003SR1!a\u001b\r\u0003!!\u0018\u0010]3tC\u001a,\u0017\u0002BA8\u0003O\u0012aaQ8oM&<\u0007bBA:\u0001\u0011%\u0011qC\u0001\u0012iJ\f\u0017N\\!oI2{w-\u0012:s_J\u001c\bbBA<\u0001\u0011\u0005\u0011\u0011P\u0001\baJ,G-[2u)\u0019\tY(a!\u0002\u0014B1\u0011\u0011HA\u001f\u0003{\u00022\u0001NA@\u0013\r\t\tI\u0001\u0002\u0012%\u0016dW-Y:f!J,G-[2uS>t\u0007\u0002CAC\u0003k\u0002\r!a\"\u0002\u000fI,G.Z1tKB!\u0011\u0011RAH\u001b\t\tYIC\u0002\u0002\u000e\"\ta\u0001Z8nC&t\u0017\u0002BAI\u0003\u0017\u0013qAU3mK\u0006\u001cX\rC\u0005\u0002\u0016\u0006U\u0004\u0013!a\u0001e\u00069A/[7f_V$\bbBAM\u0001\u0011\u0005\u00111T\u0001\u000baJ,G-[2u%\u0006<H\u0003BA\u001c\u0003;C\u0001\"!\"\u0002\u0018\u0002\u0007\u0011q\u0011\u0005\b\u0003C\u0003A\u0011AAR\u0003m\u0011X-];fgR\u0004&/\u001a3jGRLwN\\:Ge>lWj\u001c3fYRA\u0011qGAS\u0003O\u000bY\u000b\u0003\u0005\u0002\u0006\u0006}\u0005\u0019AAD\u0011!\tI+a(A\u0002\u0005\u0005\u0013!C7pI\u0016dg*Y7f\u0011\u001d\t)*a(A\u0002IDq!a,\u0001\t\u0013\t\t,\u0001\u0010qCJ\u001cXMU3mK\u0006\u001cX\r\u0015:fI&\u001cG/[8o%\u0016\u001c\bo\u001c8tKR1\u0011QPAZ\u0003\u000bD\u0001\"!.\u0002.\u0002\u0007\u0011qW\u0001\u0010aJ,G-[2uS>t7OS:p]BA\u0011\u0011XA^\u0003\u0003\ny,D\u0001o\u0013\r\tiL\u001c\u0002\u0004\u001b\u0006\u0004\bcA\t\u0002B&\u0019\u00111\u0019\n\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002\u0006\u00065\u0006\u0019AAD\u0011\u001d\tI\r\u0001C\u0005\u0003\u0017\fAc\u00195fG.\u001cuN\u001c8fGRLwN\\!ts:\u001cGCAAg!\u0015\u0019\u0017qZA\r\u0013\r\t\t\u000e\u001a\u0002\u0007\rV$XO]3\t\u000f\u0005U\u0007\u0001\"\u0003\u0002X\u00061q-\u001a;Ve2,\"!!\u0011\t\u000f\u0005m\u0007\u0001\"\u0003\u0002X\u0006\u0019r-\u001a;UCN\\7oU2iK6\f\u0017i]\"tm\"A\u0011q\u001c\u0001\u0005\u0002\t\t\t/\u0001\u0007sKN$H+Z7qY\u0006$X\rF\u0002|\u0003GDq!!&\u0002^\u0002\u0007!\u000fC\u0004\u0002h\u0002!I!!;\u0002%A\u0014X\r]1sKJ+G.Z1tK*\u001bxN\u001c\u000b\u0005\u0003\u0003\nY\u000f\u0003\u0005\u0002\u0006\u0006\u0015\b\u0019AAD\u0011%\ty\u000fAI\u0001\n\u0003\t\t0A\tqe\u0016$\u0017n\u0019;%I\u00164\u0017-\u001e7uII*\"!a=+\u0007I\f)p\u000b\u0002\u0002xB!\u0011\u0011 B\u0001\u001b\t\tYP\u0003\u0003\u0002~\u0006}\u0018!C;oG\",7m[3e\u0015\r\t9CE\u0005\u0005\u0005\u0007\tYPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D3\u0001\u0001B\u0004!\u0011\u0011IA!\u0006\u000e\u0005\t-!\u0002BA\u0014\u0005\u001bQAAa\u0004\u0003\u0012\u00059a-Y2u_JL(\u0002\u0002B\n\u0003\u0007\tQAY3b]NLAAa\u0006\u0003\f\tI\u0011)\u001e;po&\u0014X\r\u001a\u0015\b\u0001\tm!\u0011\u0006B\u0016!\u0011\u0011iB!\n\u000e\u0005\t}!\u0002BA\u0014\u0005CQAAa\t\u0002\u0004\u000591m\u001c8uKb$\u0018\u0002\u0002B\u0014\u0005?\u0011\u0011\u0002R3qK:$7o\u00148\u0002\u000bY\fG.^3-\u0005\t5\u0012E\u0001B\u0018\u00039\u0019XM\u001d<jG\u0016\u001cF/\u0019:uKJD3\u0001\u0001B\u001a!\u0011\u0011)Da\u000f\u000e\u0005\t]\"\u0002\u0002B\u001d\u0003\u0007\t!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\u0011iDa\u000e\u0003\u0013\r{W\u000e]8oK:$\b")
public class ReleasePredictionService
implements Logging {
    private final Scheduler scheduler;
    private final XlrConfig config;
    private final String MODEL_RELEASE;
    private final String MODEL_TASKS;
    private final String RESPONSE_PREDICTION_IS_ABORTED;
    private final String RESPONSE_PREDICTION_IS_RISKY;
    private final ObjectMapper objectMapper;
    private final ConcurrentHashMap<Option<java.time.Duration>, RestTemplate> restTemplates;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReleasePredictionService releasePredictionService = this;
        synchronized (releasePredictionService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private String MODEL_RELEASE() {
        return this.MODEL_RELEASE;
    }

    private String MODEL_TASKS() {
        return this.MODEL_TASKS;
    }

    private String RESPONSE_PREDICTION_IS_ABORTED() {
        return this.RESPONSE_PREDICTION_IS_ABORTED;
    }

    private String RESPONSE_PREDICTION_IS_RISKY() {
        return this.RESPONSE_PREDICTION_IS_RISKY;
    }

    private ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    public ExecutionContext executionContext() {
        return ExecutionContext$.MODULE$.global();
    }

    private ConcurrentHashMap<Option<java.time.Duration>, RestTemplate> restTemplates() {
        return this.restTemplates;
    }

    @PostConstruct
    public void init() {
        PythonServices$.MODULE$.releasePredictionService().set(this);
        this.checkConnectionAsync();
        Config pluginConfig = this.config.getRootConfig().getConfig("xl.plugin.riskPredictions");
        java.time.Duration buildModelEvery = pluginConfig.getDuration("modelBuildPeriod");
        java.time.Duration initialDelay = pluginConfig.getDuration("modelBuildInitialDelay");
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Will start building prediction models every ", " after ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{buildModelEvery, initialDelay})));
        this.scheduler.scheduleAtFixedRate(() -> this.trainAndLogErrors(), initialDelay.toMillis(), buildModelEvery.toMillis(), TimeUnit.MILLISECONDS);
    }

    public Try<String> train() {
        Failure failure;
        long start = System.currentTimeMillis();
        String url = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/api/train/all?validate=false"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getUrl()}));
        Config db = this.config.getRootConfig().hasPath("xl.plugin.riskPredictions.db-connection.reporting") ? this.config.getRootConfig().getConfig("xl.plugin.riskPredictions.db-connection.reporting") : this.config.getRootConfig().getConfig("xl.reporting");
        java.util.Map body = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Releases archive at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ServerConfiguration.getInstance().getServerUrl()}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jdbc_url"), (Object)db.getString("db-url")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"username"), (Object)db.getString("db-username")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"password"), (Object)db.getString("db-password")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"driver_classname"), (Object)db.getString("db-driver-classname")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tasks_schema_csv_content"), (Object)this.getTasksSchemaAsCsv())}))).asJava();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        try {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Start building prediction models at ", " with DB connection ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getUrl(), db.getString("db-url")})));
            ResponseEntity response = this.restTemplate((Option<java.time.Duration>)None$.MODULE$).postForEntity(url, (Object)new HttpEntity((Object)body, (MultiValueMap)headers), String.class, new Object[0]);
            long duration = System.currentTimeMillis() - start;
            String trainResponseAsString = (String)response.getBody();
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finished building prediction models in ", " ms: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)duration), trainResponseAsString})));
            failure = new Success((Object)trainResponseAsString);
        }
        catch (HttpStatusCodeException e) {
            failure = new Failure((Throwable)new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to build prediction models: ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getStatusCode()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getResponseBodyAsString()}))));
        }
        return failure;
    }

    public String rewriteDbUrl(String dbUrl, Config rewriteRules) {
        return (String)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(rewriteRules.entrySet()).asScala()).foldLeft((Object)dbUrl, (Function2 & Serializable & scala.Serializable)(rewritten, entry) -> {
            String patternInQuotes = (String)entry.getKey();
            String pattern = patternInQuotes.startsWith("\"") && patternInQuotes.endsWith("\"") ? patternInQuotes.substring(1, patternInQuotes.length() - 1) : patternInQuotes;
            ConfigValueType configValueType = ((ConfigValue)entry.getValue()).valueType();
            ConfigValueType configValueType2 = ConfigValueType.STRING;
            if (configValueType == null ? configValueType2 != null : !configValueType.equals(configValueType2)) {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Values of rewrite rules must be strings, got "})).s((Seq)Nil$.MODULE$) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " instead at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((ConfigValue)entry.getValue()).valueType(), pattern})));
            }
            String replacement = (String)((ConfigValue)entry.getValue()).unwrapped();
            return rewritten.replaceAll(pattern, replacement);
        });
    }

    private void trainAndLogErrors() {
        Try<String> try_ = this.train();
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().error((Function0 & Serializable & scala.Serializable)() -> e.getMessage());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Try<ReleasePrediction> predict(Release release, Option<java.time.Duration> timeout) {
        return this.requestPredictionsFromModel(release, this.MODEL_RELEASE(), timeout).flatMap((Function1 & Serializable & scala.Serializable)predictionsData -> {
            java.util.Map predictions = (java.util.Map)this.objectMapper().readValue(predictionsData, java.util.Map.class);
            return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.parseReleasePredictionResponse(predictions, release));
        });
    }

    public Option<java.time.Duration> predict$default$2() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Try<String> predictRaw(Release release) {
        Some some;
        java.time.Duration awaitTimeout = this.config.getRootConfig().getDuration("xl.plugin.riskPredictions.timeouts.predictionsRequest");
        Seq seq = (Seq)Await$.MODULE$.result((Awaitable)Future$.MODULE$.sequence((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Future[]{Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.requestPredictionsFromModel(release, this.MODEL_RELEASE(), (Option<java.time.Duration>)Option$.MODULE$.apply((Object)awaitTimeout)), this.executionContext()), Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.requestPredictionsFromModel(release, this.MODEL_TASKS(), (Option<java.time.Duration>)Option$.MODULE$.apply((Object)awaitTimeout)), this.executionContext())})), Seq$.MODULE$.canBuildFrom(), this.executionContext()), (Duration)Duration$.MODULE$.fromNanos(awaitTimeout.toNanos()));
        Some some2 = Seq$.MODULE$.unapplySeq(seq);
        if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(2) == 0) {
            Try try_ = (Try)((SeqLike)some2.get()).apply(0);
            Try try_2 = (Try)((SeqLike)some2.get()).apply(1);
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                String releaseResponse = (String)success.value();
                if (try_2 instanceof Success) {
                    Success success2 = (Success)try_2;
                    String tasksResponse = (String)success2.value();
                    String combinedJson = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"release\": ", ", \"tasks\": ", "}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseResponse, tasksResponse}));
                    return new Success((Object)combinedJson);
                }
            }
        }
        if ((some = Seq$.MODULE$.unapplySeq(seq)).isEmpty()) return (Try)seq.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isFailure())).get();
        if (some.get() == null) return (Try)seq.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isFailure())).get();
        if (((SeqLike)some.get()).lengthCompare(2) != 0) return (Try)seq.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isFailure())).get();
        Try try_ = (Try)((SeqLike)some.get()).apply(0);
        Try try_3 = (Try)((SeqLike)some.get()).apply(1);
        if (!(try_ instanceof Failure)) return (Try)seq.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isFailure())).get();
        if (!(try_3 instanceof Failure)) return (Try)seq.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isFailure())).get();
        return new Failure((Throwable)new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Both release and tasks prediction requests have failed for "})).s((Seq)Nil$.MODULE$) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"release ", ". Errors: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{release, seq.mkString("; ")}))));
    }

    public Try<String> requestPredictionsFromModel(Release release, String modelName, Option<java.time.Duration> timeout) {
        Failure failure;
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requesting predictions for model ", ", release ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modelName, release})));
        long start = System.currentTimeMillis();
        String url = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/api/predict/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getUrl(), modelName}));
        String releaseJson = this.prepareReleaseJson(release);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        try {
            ResponseEntity response = this.restTemplate(timeout).postForEntity(url, (Object)new HttpEntity((Object)releaseJson, (MultiValueMap)headers), String.class, new Object[0]);
            String predictionsData = (String)response.getBody();
            long duration = System.currentTimeMillis() - start;
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got predictions for model ", ", release ", " in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modelName, release, BoxesRunTime.boxToLong((long)duration)})));
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Predictions response for model ", ", release ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modelName, release, predictionsData})));
            failure = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> predictionsData);
        }
        catch (HttpStatusCodeException e) {
            failure = new Failure((Throwable)new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got unsuccessful response when predicting ", " for "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modelName})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"release ", ": ", ", ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{release, e.getStatusCode(), e.getResponseBodyAsString()})), e));
        }
        catch (Throwable e) {
            failure = new Failure((Throwable)new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not get response when predicting ", " for "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modelName})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"release ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{release, e.getMessage()})), e));
        }
        return failure;
    }

    private ReleasePrediction parseReleasePredictionResponse(java.util.Map<String, Object> predictionsJson, Release release) {
        scala.collection.mutable.Map predictions = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(predictionsJson).asScala();
        scala.collection.immutable.Map probabilities = ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.RESPONSE_PREDICTION_IS_ABORTED(), this.RESPONSE_PREDICTION_IS_RISKY()}))).map((Function1 & Serializable & scala.Serializable)name -> {
            Option option = predictions.get(name);
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There was no prediction '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for release ", " in the response from the model: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{release, predictions})));
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            Object prediction = some.value();
            Tuple2 tuple2 = new Tuple2(name, (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)prediction)));
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return new ReleasePrediction(BoxesRunTime.unboxToDouble((Object)probabilities.apply((Object)this.RESPONSE_PREDICTION_IS_ABORTED())), BoxesRunTime.unboxToDouble((Object)probabilities.apply((Object)this.RESPONSE_PREDICTION_IS_RISKY())));
    }

    private Future<BoxedUnit> checkConnectionAsync() {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                ResponseEntity response = this.restTemplate((Option<java.time.Duration>)None$.MODULE$).getForEntity(this.getUrl(), java.util.Map.class, new Object[0]);
                scala.collection.mutable.Map data = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)response.getBody()).asScala();
                this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connected to DevOpsML at ", ": version ", ", hostname ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getUrl(), data.apply((Object)"version"), data.apply((Object)"hostname")})));
            }
            catch (HttpStatusCodeException e) {
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not connect to DevOpsML at ", ": ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getUrl(), e.getStatusCode()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getResponseBodyAsString()})));
            }
        }, this.executionContext());
    }

    private String getUrl() {
        return this.config.getRootConfig().getString("xl.plugin.riskPredictions.xlDevopsMlUrl").replaceFirst("/$", "");
    }

    private String getTasksSchemaAsCsv() {
        Seq rows = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"category", (Object)"name", (Object)"task")}))).$plus$plus((GenTraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(DescriptorRegistry.getSubtypes((Type)Type.valueOf(PythonScript.class))).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReleasePredictionService.$anonfun$getTasksSchemaAsCsv$1(x$2)))).flatMap((Function1 & Serializable & scala.Serializable)t -> (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(t.getDescriptor().getPropertyDescriptors()).asScala()).map((Function1 & Serializable & scala.Serializable)prop -> new Tuple3((Object)prop.getCategory(), (Object)prop.getName(), (Object)t.toString()), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        return ((TraversableOnce)rows.map((Function1 & Serializable & scala.Serializable)r -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",", ",", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{r._1(), r._2(), r._3()})), Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    public RestTemplate restTemplate(Option<java.time.Duration> timeout) {
        return this.restTemplates().computeIfAbsent(timeout, x0$1 -> {
            RestTemplate restTemplate;
            Some some;
            java.time.Duration duration;
            Option option = x0$1;
            if (option instanceof Some && (duration = (java.time.Duration)(some = (Some)option).value()) != null) {
                java.time.Duration duration2 = duration;
                HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
                factory.setConnectionRequestTimeout((int)duration2.toMillis());
                factory.setConnectTimeout((int)duration2.toMillis());
                factory.setReadTimeout((int)duration2.toMillis());
                restTemplate = new RestTemplate((ClientHttpRequestFactory)factory);
            } else {
                restTemplate = new RestTemplate();
            }
            return restTemplate;
        });
    }

    private String prepareReleaseJson(Release release) {
        if (release.isTemplate()) {
            release.setOriginTemplateId(release.getId());
        }
        return CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
    }

    public static final /* synthetic */ boolean $anonfun$getTasksSchemaAsCsv$1(Type x$2) {
        return !x$2.getDescriptor().isVirtual();
    }

    public ReleasePredictionService(Scheduler scheduler, XlrConfig config) {
        this.scheduler = scheduler;
        this.config = config;
        Logging.$init$((Logging)this);
        this.MODEL_RELEASE = "xlr_release_models";
        this.MODEL_TASKS = "xlr_task_models";
        this.RESPONSE_PREDICTION_IS_ABORTED = "prob_aborted";
        this.RESPONSE_PREDICTION_IS_RISKY = "prob_risk";
        this.objectMapper = new ObjectMapper();
        this.restTemplates = new ConcurrentHashMap();
    }
}

