from com.xebialabs.xlrelease.plugins.predictions.service import PythonServices
from com.xebialabs.deployit.security import PermissionDeniedException

if 'path' not in request.query:
    response.statusCode = 400
    response.entity = "You must specify the 'path' parameter where the releases will be downloaded to"

else:
    path = request.query['path']
    skip_existing = request.query.get('skipExisting', 'false').lower() == 'true'

    modelDebugger = PythonServices.getModelDebugServiceInstance()

    try:
        modelDebugger.dumpArchivedReleases(path, skip_existing)

    except PermissionDeniedException as e:
        response.statusCode = 403
        response.entity = e.toString()
