import json
from com.xebialabs.xlrelease.plugins.predictions.service import PythonServices
from org.springframework.security.core.context import SecurityContextHolder


def is_current_user_admin():
    authentication = SecurityContextHolder.getContext().getAuthentication()
    authorities = authentication.getAuthorities() if authentication else []
    authority_names = map(lambda a: a.getAuthority(), authorities or [])
    return "ROLE_ADMIN" in authority_names


if not is_current_user_admin():
    response.statusCode = 403
    response.entity = "Only users with admin role can run this action"

else:
    predictor = PythonServices.getReleasePredictionServiceInstance()
    train_result_string = predictor.train().get()
    response.statusCode = 201
    response.entity = json.loads(train_result_string)
