/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.predictions.debug;

import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.xlrelease.plugins.predictions.debug.ArchiveRepository;
import com.xebialabs.xlrelease.plugins.predictions.service.PythonServices$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@Component
@ScalaSignature(bytes="\u0006\u0001q4A!\u0001\u0002\u0001\u001f\t\tRj\u001c3fY\u0012+'-^4TKJ4\u0018nY3\u000b\u0005\r!\u0011!\u00023fEV<'BA\u0003\u0007\u0003-\u0001(/\u001a3jGRLwN\\:\u000b\u0005\u001dA\u0011a\u00029mk\u001eLgn\u001d\u0006\u0003\u0013)\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005-a\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005i\u0011aA2p[\u000e\u00011c\u0001\u0001\u0011-A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"a\u0006\u000f\u000e\u0003aQ!!\u0007\u000e\u0002\u000bMdg\r\u000e6\u000b\u0003m\t\u0001b\u001a:jujdW\rZ\u0005\u0003;a\u0011q\u0001T8hO&tw\r\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u0003-\t'o\u00195jm\u0016\u0014V\r]8\u0011\u0005\u0005\u0012S\"\u0001\u0002\n\u0005\r\u0012!!E!sG\"Lg/\u001a*fa>\u001c\u0018\u000e^8ss\"AQ\u0005\u0001B\u0001B\u0003%a%\u0001\nqKJl\u0017n]:j_:,eNZ8sG\u0016\u0014\bCA\u0014-\u001b\u0005A#BA\u0015+\u0003!\u0019XmY;sSRL(BA\u0016\u000b\u0003!!W\r\u001d7ps&$\u0018BA\u0017)\u0005I\u0001VM]7jgNLwN\\#oM>\u00148-\u001a:\t\u000b=\u0002A\u0011\u0001\u0019\u0002\rqJg.\u001b;?)\r\t$g\r\t\u0003C\u0001AQa\b\u0018A\u0002\u0001BQ!\n\u0018A\u0002\u0019B#AL\u001b\u0011\u0005Y\nU\"A\u001c\u000b\u0005aJ\u0014AC1o]>$\u0018\r^5p]*\u0011!hO\u0001\bM\u0006\u001cGo\u001c:z\u0015\taT(A\u0003cK\u0006t7O\u0003\u0002?\u007f\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001A\u0003\ry'oZ\u0005\u0003\u0005^\u0012\u0011\"Q;u_^L'/\u001a3\t\u000b\u0011\u0003A\u0011A#\u0002)\u0011,X\u000e]!sG\"Lg/\u001a3SK2,\u0017m]3t)\r1\u0015J\u0016\t\u0003#\u001dK!\u0001\u0013\n\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0015\u000e\u0003\raS\u0001\u0005a\u0006$\b\u000e\u0005\u0002M':\u0011Q*\u0015\t\u0003\u001dJi\u0011a\u0014\u0006\u0003!:\ta\u0001\u0010:p_Rt\u0014B\u0001*\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011A+\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005I\u0013\u0002\"B,D\u0001\u0004A\u0016\u0001D:lSB,\u00050[:uS:<\u0007CA\tZ\u0013\tQ&CA\u0004C_>dW-\u00198\t\u000bq\u0003A\u0011B/\u0002\u0011M\fg/\u001a$jY\u0016$2A\u00120a\u0011\u0015y6\f1\u0001L\u0003\u001d\u0019wN\u001c;f]RDQ!Y.A\u0002\t\fAAZ5mKB\u00111\r[\u0007\u0002I*\u0011QMZ\u0001\u0003S>T\u0011aZ\u0001\u0005U\u00064\u0018-\u0003\u0002jI\n!a)\u001b7f\u0011\u0015Y\u0007\u0001\"\u0001m\u0003\u0011Ig.\u001b;\u0015\u0003\u0019C#A\u001b8\u0011\u0005=\u001cX\"\u00019\u000b\u0005a\n(\"\u0001:\u0002\u000b)\fg/\u0019=\n\u0005Q\u0004(!\u0004)pgR\u001cuN\\:ueV\u001cG\u000f\u000b\u0002\u0001mB\u0011qO_\u0007\u0002q*\u0011\u00110P\u0001\u000bgR,'/Z8usB,\u0017BA>y\u0005%\u0019u.\u001c9p]\u0016tG\u000f")
public class ModelDebugService
implements Logging {
    private final ArchiveRepository archiveRepo;
    private final PermissionEnforcer permissionEnforcer;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ModelDebugService modelDebugService = this;
        synchronized (modelDebugService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public void dumpArchivedReleases(String path, boolean skipExisting) {
        if (!this.permissionEnforcer.isCurrentUserAdmin()) {
            throw PermissionDeniedException.withMessage((String)"Only users with admin role can perform this operation");
        }
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Start reading all archived releases into directory ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
        Seq<String> releaseIds = this.archiveRepo.findAllReleaseIds();
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " archived releases, start downloading them"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)releaseIds.size())})));
        long start = System.currentTimeMillis();
        AtomicInteger progress = new AtomicInteger(0);
        releaseIds.foreach((Function1 & Serializable & scala.Serializable)releaseId -> {
            ModelDebugService.$anonfun$dumpArchivedReleases$3(this, path, skipExisting, releaseIds, progress, releaseId);
            return BoxedUnit.UNIT;
        });
        FiniteDuration duration = Duration$.MODULE$.apply((System.currentTimeMillis() - start) / 1000L, TimeUnit.SECONDS);
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finished downloading ", " releases to ", " in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)releaseIds.size()), path, duration})));
    }

    private void saveFile(String content, File file) {
        try (PrintWriter pw = null;){
            pw = new PrintWriter(file, "UTF-8");
            pw.write(content);
        }
    }

    @PostConstruct
    public void init() {
        PythonServices$.MODULE$.modelDebugService().set(this);
    }

    public static final /* synthetic */ void $anonfun$dumpArchivedReleases$3(ModelDebugService $this, String path$1, boolean skipExisting$1, Seq releaseIds$1, AtomicInteger progress$1, String releaseId) {
        block6: {
            File file = new File(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ".json"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path$1, releaseId})));
            if (skipExisting$1 && file.exists()) {
                $this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Skipping release as it already exists on disk: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})));
            } else {
                Try<String> try_ = $this.archiveRepo.readReleaseJson(releaseId);
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    String json = (String)success.value();
                    file.getParentFile().mkdirs();
                    $this.saveFile(json, file);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    $this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not read release ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId, e})), (Function0 & Serializable & scala.Serializable)() -> e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError(try_);
                }
            }
            int nDone = progress$1.incrementAndGet();
            if (nDone % 1000 != 0) break block6;
            $this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  downloaded ", " out of ", " archived releases..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)nDone), BoxesRunTime.boxToInteger((int)releaseIds$1.size())})));
        }
    }

    @Autowired
    public ModelDebugService(ArchiveRepository archiveRepo, PermissionEnforcer permissionEnforcer) {
        this.archiveRepo = archiveRepo;
        this.permissionEnforcer = permissionEnforcer;
        Logging.$init$((Logging)this);
    }
}

