/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.predictions.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.core.xml.WriteWithoutPasswordCiConverter;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.config.XlrConfig$reporting$;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.json.CiSerializerHelper$;
import com.xebialabs.xlrelease.plugins.predictions.service.PythonServices$;
import com.xebialabs.xlrelease.plugins.predictions.service.ReleasePrediction;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@DependsOn(value={"serviceStarter"})
@ScalaSignature(bytes="\u0006\u0001\u0005}h\u0001B\u0001\u0003\u0001=\u0011\u0001DU3mK\u0006\u001cX\r\u0015:fI&\u001cG/[8o'\u0016\u0014h/[2f\u0015\t\u0019A!A\u0004tKJ4\u0018nY3\u000b\u0005\u00151\u0011a\u00039sK\u0012L7\r^5p]NT!a\u0002\u0005\u0002\u000fAdWoZ5og*\u0011\u0011BC\u0001\nq2\u0014X\r\\3bg\u0016T!a\u0003\u0007\u0002\u0013a,'-[1mC\n\u001c(\"A\u0007\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001\u0001b\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0003/qi\u0011\u0001\u0007\u0006\u00033i\tQa\u001d7gi)T\u0011aG\u0001\tOJL'P\u001f7fI&\u0011Q\u0004\u0007\u0002\b\u0019><w-\u001b8h\u0011!y\u0002A!A!\u0002\u0013\u0001\u0013!C:dQ\u0016$W\u000f\\3s!\t\ts%D\u0001#\u0015\ty2E\u0003\u0002%K\u0005A\u0001\u000f\\;nE&twM\u0003\u0002'\u0015\u0005AA-\u001a9m_fLG/\u0003\u0002)E\tI1k\u00195fIVdWM\u001d\u0005\tU\u0001\u0011\t\u0011)A\u0005W\u000511m\u001c8gS\u001e\u0004\"\u0001\f\u0018\u000e\u00035R!A\u000b\u0005\n\u0005=j#!\u0003-me\u000e{gNZ5h\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0014\u0001\u0004:fgR$V-\u001c9mCR,\u0007CA\u001a=\u001b\u0005!$BA\u001b7\u0003\u0019\u0019G.[3oi*\u0011q\u0007O\u0001\u0004o\u0016\u0014'BA\u001d;\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A\u001e\u0002\u0007=\u0014x-\u0003\u0002>i\ta!+Z:u)\u0016l\u0007\u000f\\1uK\")q\b\u0001C\u0001\u0001\u00061A(\u001b8jiz\"B!Q\"E\u000bB\u0011!\tA\u0007\u0002\u0005!)qD\u0010a\u0001A!)!F\u0010a\u0001W!)\u0011G\u0010a\u0001e!9q\t\u0001b\u0001\n\u0013A\u0015!D'P\t\u0016cuLU#M\u000b\u0006\u001bV)F\u0001J!\tQu*D\u0001L\u0015\taU*\u0001\u0003mC:<'\"\u0001(\u0002\t)\fg/Y\u0005\u0003!.\u0013aa\u0015;sS:<\u0007B\u0002*\u0001A\u0003%\u0011*\u0001\bN\u001f\u0012+Ej\u0018*F\u0019\u0016\u000b5+\u0012\u0011\t\u000fQ\u0003!\u0019!C\u0005\u0011\u0006YQj\u0014#F\u0019~#\u0016iU&T\u0011\u00191\u0006\u0001)A\u0005\u0013\u0006aQj\u0014#F\u0019~#\u0016iU&TA!9\u0001\f\u0001b\u0001\n\u0013A\u0015A\b*F'B{ejU#`!J+E)S\"U\u0013>su,S*`\u0003\n{%\u000bV#E\u0011\u0019Q\u0006\u0001)A\u0005\u0013\u0006y\"+R*Q\u001f:\u001bVi\u0018)S\u000b\u0012K5\tV%P\u001d~K5kX!C\u001fJ#V\t\u0012\u0011\t\u000fq\u0003!\u0019!C\u0005\u0011\u0006a\"+R*Q\u001f:\u001bVi\u0018)S\u000b\u0012K5\tV%P\u001d~K5k\u0018*J'.K\u0006B\u00020\u0001A\u0003%\u0011*A\u000fS\u000bN\u0003vJT*F?B\u0013V\tR%D)&{ejX%T?JK5kS-!\u0011\u001d\u0001\u0007A1A\u0005\n\u0005\fAb\u001c2kK\u000e$X*\u00199qKJ,\u0012A\u0019\t\u0003G*l\u0011\u0001\u001a\u0006\u0003K\u001a\f\u0001\u0002Z1uC\nLg\u000e\u001a\u0006\u0003O\"\fqA[1dWN|gN\u0003\u0002j\u0019\u0005Ia-Y:uKJDX\u000e\\\u0005\u0003W\u0012\u0014Ab\u00142kK\u000e$X*\u00199qKJDa!\u001c\u0001!\u0002\u0013\u0011\u0017!D8cU\u0016\u001cG/T1qa\u0016\u0014\b\u0005C\u0003@\u0001\u0011\u0005q\u000eF\u0002BaFDQa\b8A\u0002\u0001BQA\u000b8A\u0002-B#A\\:\u0011\u0005Q\\X\"A;\u000b\u0005Y<\u0018AC1o]>$\u0018\r^5p]*\u0011\u00010_\u0001\bM\u0006\u001cGo\u001c:z\u0015\tQ\b(A\u0003cK\u0006t7/\u0003\u0002}k\nI\u0011)\u001e;po&\u0014X\r\u001a\u0005\u0007}\u0002!\u0019AA@\u0002!\u0015DXmY;uS>t7i\u001c8uKb$XCAA\u0001!\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u0004%\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005-\u0011Q\u0001\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRDq!a\u0004\u0001\t\u0003\t\t\"\u0001\u0003j]&$HCAA\n!\r\t\u0012QC\u0005\u0004\u0003/\u0011\"\u0001B+oSRDC!!\u0004\u0002\u001cA!\u0011QDA\u0013\u001b\t\tyBC\u0002w\u0003CQ!!a\t\u0002\u000b)\fg/\u0019=\n\t\u0005\u001d\u0012q\u0004\u0002\u000e!>\u001cHoQ8ogR\u0014Xo\u0019;\t\u000f\u0005-\u0002\u0001\"\u0001\u0002.\u0005)AO]1j]R\u0011\u0011q\u0006\t\u0007\u0003c\t9$a\u000f\u000e\u0005\u0005M\"bAA\u001b%\u0005!Q\u000f^5m\u0013\u0011\tI$a\r\u0003\u0007Q\u0013\u0018\u0010\u0005\u0003\u0002>\u0005-c\u0002BA \u0003\u000f\u00022!!\u0011\u0013\u001b\t\t\u0019EC\u0002\u0002F9\ta\u0001\u0010:p_Rt\u0014bAA%%\u00051\u0001K]3eK\u001aL1\u0001UA'\u0015\r\tIE\u0005\u0005\t\u0003#\u0002A\u0011\u0001\u0002\u0002T\u0005a!/Z<sSR,GIY+sYR1\u00111HA+\u00033B\u0001\"a\u0016\u0002P\u0001\u0007\u00111H\u0001\u0006I\n,&\u000f\u001c\u0005\t\u00037\ny\u00051\u0001\u0002^\u0005a!/Z<sSR,'+\u001e7fgB!\u0011qLA4\u001b\t\t\tGC\u0002+\u0003GR1!!\u001a\r\u0003!!\u0018\u0010]3tC\u001a,\u0017\u0002BA5\u0003C\u0012aaQ8oM&<\u0007bBA7\u0001\u0011%\u0011\u0011C\u0001\u0012iJ\f\u0017N\\!oI2{w-\u0012:s_J\u001c\bbBA9\u0001\u0011\u0005\u00111O\u0001\baJ,G-[2u)\u0011\t)(! \u0011\r\u0005E\u0012qGA<!\r\u0011\u0015\u0011P\u0005\u0004\u0003w\u0012!!\u0005*fY\u0016\f7/\u001a)sK\u0012L7\r^5p]\"A\u0011qPA8\u0001\u0004\t\t)A\u0004sK2,\u0017m]3\u0011\t\u0005\r\u0015\u0011R\u0007\u0003\u0003\u000bS1!a\"\t\u0003\u0019!w.\\1j]&!\u00111RAC\u0005\u001d\u0011V\r\\3bg\u0016Dq!a$\u0001\t\u0003\t\t*\u0001\u0006qe\u0016$\u0017n\u0019;SC^$B!a\f\u0002\u0014\"A\u0011qPAG\u0001\u0004\t\t\tC\u0004\u0002\u0018\u0002!\t!!'\u00027I,\u0017/^3tiB\u0013X\rZ5di&|gn\u001d$s_6lu\u000eZ3m)\u0019\ty#a'\u0002\u001e\"A\u0011qPAK\u0001\u0004\t\t\t\u0003\u0005\u0002 \u0006U\u0005\u0019AA\u001e\u0003%iw\u000eZ3m\u001d\u0006lW\rC\u0004\u0002$\u0002!I!!*\u0002=A\f'o]3SK2,\u0017m]3Qe\u0016$\u0017n\u0019;j_:\u0014Vm\u001d9p]N,GCBA<\u0003O\u000b\t\r\u0003\u0005\u0002*\u0006\u0005\u0006\u0019AAV\u0003=\u0001(/\u001a3jGRLwN\\:Kg>t\u0007CBAW\u0003c\u000b),\u0004\u0002\u00020*\u0019\u0011QG'\n\t\u0005M\u0016q\u0016\u0002\u0005\u0019&\u001cH\u000f\u0005\u0005\u0002.\u0006]\u00161HA^\u0013\u0011\tI,a,\u0003\u00075\u000b\u0007\u000fE\u0002\u0012\u0003{K1!a0\u0013\u0005\r\te.\u001f\u0005\t\u0003\u007f\n\t\u000b1\u0001\u0002\u0002\"9\u0011Q\u0019\u0001\u0005\n\u0005\u001d\u0017\u0001F2iK\u000e\\7i\u001c8oK\u000e$\u0018n\u001c8Bgft7\r\u0006\u0002\u0002JB1\u00111AAf\u0003'IA!!4\u0002\u0006\t1a)\u001e;ve\u0016Dq!!5\u0001\t\u0013\t\u0019.\u0001\u0004hKR,&\u000f\\\u000b\u0003\u0003wAq!a6\u0001\t\u0013\t\u0019.A\nhKR$\u0016m]6t'\u000eDW-\\1Bg\u000e\u001bh\u000fK\u0004\u0001\u00037\fI/a;\u0011\t\u0005u\u0017Q]\u0007\u0003\u0003?T1A^Aq\u0015\r\t\u0019\u000fO\u0001\bG>tG/\u001a=u\u0013\u0011\t9/a8\u0003\u0013\u0011+\u0007/\u001a8eg>s\u0017!\u0002<bYV,GFAAwC\t\ty/\u0001\btKJ4\u0018nY3Ti\u0006\u0014H/\u001a:)\u0007\u0001\t\u0019\u0010\u0005\u0003\u0002v\u0006mXBAA|\u0015\r\tI\u0010O\u0001\u000bgR,'/Z8usB,\u0017\u0002BA\u007f\u0003o\u0014\u0011bQ8na>tWM\u001c;")
public class ReleasePredictionService
implements Logging {
    private final Scheduler scheduler;
    private final XlrConfig config;
    private final RestTemplate restTemplate;
    private final String MODEL_RELEASE;
    private final String MODEL_TASKS;
    private final String RESPONSE_PREDICTION_IS_ABORTED;
    private final String RESPONSE_PREDICTION_IS_RISKY;
    private final ObjectMapper objectMapper;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReleasePredictionService releasePredictionService = this;
        synchronized (releasePredictionService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private String MODEL_RELEASE() {
        return this.MODEL_RELEASE;
    }

    private String MODEL_TASKS() {
        return this.MODEL_TASKS;
    }

    private String RESPONSE_PREDICTION_IS_ABORTED() {
        return this.RESPONSE_PREDICTION_IS_ABORTED;
    }

    private String RESPONSE_PREDICTION_IS_RISKY() {
        return this.RESPONSE_PREDICTION_IS_RISKY;
    }

    private ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    public ExecutionContext executionContext() {
        return ExecutionContext$.MODULE$.global();
    }

    @PostConstruct
    public void init() {
        PythonServices$.MODULE$.releasePredictionService().set(this);
        this.checkConnectionAsync();
        java.time.Duration buildModelEvery = this.config.getRootConfig().getDuration("xl.plugin.riskPredictions.modelBuildPeriod");
        java.time.Duration initialDelay = this.config.getRootConfig().getDuration("xl.plugin.riskPredictions.modelBuildInitialDelay");
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Will start building prediction models every ", " after ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{buildModelEvery, initialDelay})));
        this.scheduler.scheduleAtFixedRate(() -> this.trainAndLogErrors(), initialDelay.toMillis(), buildModelEvery.toMillis(), TimeUnit.MILLISECONDS);
    }

    public Try<String> train() {
        Failure failure;
        long start = System.currentTimeMillis();
        String url = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/api/train/all?validate=false"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getUrl()}));
        XlrConfig$reporting$ db = this.config.reporting();
        String dbUrl = this.rewriteDbUrl(db.dbUrl(), this.config.getRootConfig().getConfig("xl.plugin.riskPredictions.dbUrlRewriteRules"));
        java.util.Map body = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Releases archive at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ServerConfiguration.getInstance().getServerUrl()}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jdbc_url"), (Object)dbUrl), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"username"), (Object)db.dbUsername()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"password"), (Object)db.dbPassword()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"driver_classname"), (Object)db.dbDriverClassname()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tasks_schema_csv_content"), (Object)this.getTasksSchemaAsCsv())}))).asJava();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        try {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Start building prediction models at ", " with DB connection ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getUrl(), db.dbUrl()})));
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)new HttpEntity((Object)body, (MultiValueMap)headers), String.class, new Object[0]);
            long duration = System.currentTimeMillis() - start;
            String trainResponseAsString = (String)response.getBody();
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finished building prediction models in ", " ms: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)duration), trainResponseAsString})));
            failure = new Success((Object)trainResponseAsString);
        }
        catch (HttpStatusCodeException e) {
            failure = new Failure((Throwable)new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to build prediction models: ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getStatusCode()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getResponseBodyAsString()}))));
        }
        return failure;
    }

    public String rewriteDbUrl(String dbUrl, Config rewriteRules) {
        return (String)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(rewriteRules.entrySet()).asScala()).foldLeft((Object)dbUrl, (Function2 & Serializable & scala.Serializable)(rewritten, entry) -> {
            String patternInQuotes = (String)entry.getKey();
            String pattern = patternInQuotes.startsWith("\"") && patternInQuotes.endsWith("\"") ? patternInQuotes.substring(1, patternInQuotes.length() - 1) : patternInQuotes;
            ConfigValueType configValueType = ((ConfigValue)entry.getValue()).valueType();
            ConfigValueType configValueType2 = ConfigValueType.STRING;
            if (configValueType == null ? configValueType2 != null : !configValueType.equals(configValueType2)) {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Values of rewrite rules must be strings, got "})).s((Seq)Nil$.MODULE$) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " instead at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((ConfigValue)entry.getValue()).valueType(), pattern})));
            }
            String replacement = (String)((ConfigValue)entry.getValue()).unwrapped();
            return rewritten.replaceAll(pattern, replacement);
        });
    }

    private void trainAndLogErrors() {
        Try<String> try_ = this.train();
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().error((Function0 & Serializable & scala.Serializable)() -> e.getMessage());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Try<ReleasePrediction> predict(Release release) {
        return this.requestPredictionsFromModel(release, this.MODEL_RELEASE()).flatMap((Function1 & Serializable & scala.Serializable)predictionsData -> {
            List predictions = (List)this.objectMapper().readValue(predictionsData, List.class);
            return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.parseReleasePredictionResponse(predictions, release));
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Try<String> predictRaw(Release release) {
        Some some;
        java.time.Duration awaitTimeout = this.config.getRootConfig().getDuration("xl.plugin.riskPredictions.timeouts.predictionsRequest");
        Seq seq = (Seq)Await$.MODULE$.result((Awaitable)Future$.MODULE$.sequence((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Future[]{Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.requestPredictionsFromModel(release, this.MODEL_RELEASE()), this.executionContext()), Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.requestPredictionsFromModel(release, this.MODEL_TASKS()), this.executionContext())})), Seq$.MODULE$.canBuildFrom(), this.executionContext()), (Duration)Duration$.MODULE$.fromNanos(awaitTimeout.toNanos()));
        Some some2 = Seq$.MODULE$.unapplySeq(seq);
        if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(2) == 0) {
            Try try_ = (Try)((SeqLike)some2.get()).apply(0);
            Try try_2 = (Try)((SeqLike)some2.get()).apply(1);
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                String releaseResponse = (String)success.value();
                if (try_2 instanceof Success) {
                    Success success2 = (Success)try_2;
                    String tasksResponse = (String)success2.value();
                    String combinedJson = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"release\": ", ", \"tasks\": ", "}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseResponse, tasksResponse}));
                    return new Success((Object)combinedJson);
                }
            }
        }
        if ((some = Seq$.MODULE$.unapplySeq(seq)).isEmpty()) return (Try)seq.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isFailure())).get();
        if (some.get() == null) return (Try)seq.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isFailure())).get();
        if (((SeqLike)some.get()).lengthCompare(2) != 0) return (Try)seq.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isFailure())).get();
        Try try_ = (Try)((SeqLike)some.get()).apply(0);
        Try try_3 = (Try)((SeqLike)some.get()).apply(1);
        if (!(try_ instanceof Failure)) return (Try)seq.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isFailure())).get();
        if (!(try_3 instanceof Failure)) return (Try)seq.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isFailure())).get();
        return new Failure((Throwable)new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Both release and tasks prediction requests have failed for "})).s((Seq)Nil$.MODULE$) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"release ", ". Errors: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{release, seq.mkString("; ")}))));
    }

    public Try<String> requestPredictionsFromModel(Release release, String modelName) {
        Failure failure;
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requesting predictions for model ", ", release ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modelName, release})));
        long start = System.currentTimeMillis();
        String url = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/api/predict/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getUrl(), modelName}));
        String releaseJson = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        try {
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)new HttpEntity((Object)releaseJson, (MultiValueMap)headers), String.class, new Object[0]);
            String predictionsData = (String)response.getBody();
            long duration = System.currentTimeMillis() - start;
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got predictions for model ", ", release ", " in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modelName, release, BoxesRunTime.boxToLong((long)duration)})));
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Predictions response for model ", ", release ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modelName, release, predictionsData})));
            failure = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> predictionsData);
        }
        catch (HttpStatusCodeException e) {
            failure = new Failure((Throwable)new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got unsuccessful response when predicting ", " for "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modelName})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"release ", ": ", ", ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{release, e.getStatusCode(), e.getResponseBodyAsString()}))));
        }
        return failure;
    }

    private ReleasePrediction parseReleasePredictionResponse(List<java.util.Map<String, Object>> predictionsJson, Release release) {
        Buffer predictions = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(predictionsJson).asScala();
        scala.collection.immutable.Map probabilities = ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.RESPONSE_PREDICTION_IS_ABORTED(), this.RESPONSE_PREDICTION_IS_RISKY()}))).map((Function1 & Serializable & scala.Serializable)name -> {
            Option option = predictions.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReleasePredictionService.$anonfun$parseReleasePredictionResponse$2(name, x$2)));
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There was no prediction '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for release ", " in the response from the model: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{release, predictions})));
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            java.util.Map prediction = (java.util.Map)some.value();
            Tuple2 tuple2 = new Tuple2(name, (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble(prediction.get("probability"))));
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return new ReleasePrediction(BoxesRunTime.unboxToDouble((Object)probabilities.apply((Object)this.RESPONSE_PREDICTION_IS_ABORTED())), BoxesRunTime.unboxToDouble((Object)probabilities.apply((Object)this.RESPONSE_PREDICTION_IS_RISKY())));
    }

    private Future<BoxedUnit> checkConnectionAsync() {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                ResponseEntity response = $this.restTemplate.getForEntity(this.getUrl(), java.util.Map.class, new Object[0]);
                scala.collection.mutable.Map data = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)response.getBody()).asScala();
                this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connected to DevOpsML at ", ": version ", ", hostname ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getUrl(), data.apply((Object)"version"), data.apply((Object)"hostname")})));
            }
            catch (HttpStatusCodeException e) {
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not connect to DevOpsML at ", ": ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getUrl(), e.getStatusCode()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getResponseBodyAsString()})));
            }
        }, this.executionContext());
    }

    private String getUrl() {
        return this.config.getRootConfig().getString("xl.plugin.riskPredictions.xlDevopsMlUrl").replaceFirst("/$", "");
    }

    private String getTasksSchemaAsCsv() {
        Seq rows = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"category", (Object)"name", (Object)"task")}))).$plus$plus((GenTraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(DescriptorRegistry.getSubtypes((Type)Type.valueOf(PythonScript.class))).asScala()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ReleasePredictionService.$anonfun$getTasksSchemaAsCsv$1(x$3)))).flatMap((Function1 & Serializable & scala.Serializable)t -> (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(t.getDescriptor().getPropertyDescriptors()).asScala()).map((Function1 & Serializable & scala.Serializable)prop -> new Tuple3((Object)prop.getCategory(), (Object)prop.getName(), (Object)t.toString()), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        return ((TraversableOnce)rows.map((Function1 & Serializable & scala.Serializable)r -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",", ",", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{r._1(), r._2(), r._3()})), Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    public static final /* synthetic */ boolean $anonfun$parseReleasePredictionResponse$2(String name$1, java.util.Map x$2) {
        Object v = x$2.get("name");
        String string = name$1;
        return !(v != null ? !v.equals(string) : string != null);
    }

    public static final /* synthetic */ boolean $anonfun$getTasksSchemaAsCsv$1(Type x$3) {
        return !x$3.getDescriptor().isVirtual();
    }

    public ReleasePredictionService(Scheduler scheduler, XlrConfig config, RestTemplate restTemplate) {
        this.scheduler = scheduler;
        this.config = config;
        this.restTemplate = restTemplate;
        Logging.$init$((Logging)this);
        this.MODEL_RELEASE = "xlr_release_models";
        this.MODEL_TASKS = "xlr_task_models";
        this.RESPONSE_PREDICTION_IS_ABORTED = "is_aborted";
        this.RESPONSE_PREDICTION_IS_RISKY = "is_risky";
        this.objectMapper = new ObjectMapper();
    }

    @Autowired
    public ReleasePredictionService(Scheduler scheduler, XlrConfig config) {
        this(scheduler, config, new RestTemplate());
    }
}

