/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.predictions.risk;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.status.FlagStatus;
import com.xebialabs.xlrelease.plugins.predictions.service.ProbabilityThresholds;
import com.xebialabs.xlrelease.plugins.predictions.service.PythonServices;
import com.xebialabs.xlrelease.plugins.predictions.service.ReleasePrediction;
import com.xebialabs.xlrelease.plugins.predictions.service.ReleasePredictionService;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.riskassessors.RiskAssessor;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.util.Try;

@Metadata(label="ReleaseAbortionRiskAssessor", versioned=false)
public class ReleaseAbortionRiskAssessor
extends RiskAssessor {
    private static final Logger logger = LoggerFactory.getLogger(ReleaseAbortionRiskAssessor.class);
    private static final ProbabilityThresholds THRESHOLD_PROB_RELEASE_FAILED = new ProbabilityThresholds(0.5, 0.9);
    private static final ProbabilityThresholds THRESHOLD_PROB_RELEASE_ABORTED = new ProbabilityThresholds(0.5, 0.9);
    private ReleasePredictionService predictor = PythonServices.getReleasePredictionServiceInstance();

    public RiskAssessment execute(Release release, RiskProfile riskProfile) {
        RiskAssessment assessment = new RiskAssessment();
        assessment.setRiskAssessorId(this.getId());
        Try<ReleasePrediction> predictionTry = this.predictor.predict(release);
        if (predictionTry.isFailure()) {
            logger.error(String.format("Could not assess abortion risk of release %s: %s", release, predictionTry));
            assessment.setScore(Integer.valueOf(0));
            assessment.setHeadline("Release is on track");
        } else {
            FlagStatus maxRisk;
            ReleasePrediction prediction = (ReleasePrediction)predictionTry.get();
            FlagStatus riskFailed = THRESHOLD_PROB_RELEASE_FAILED.getLevel(prediction.probabilityIsRisky());
            FlagStatus riskAborted = THRESHOLD_PROB_RELEASE_ABORTED.getLevel(prediction.probabilityAborted());
            FlagStatus flagStatus = maxRisk = riskAborted.getRisk() > riskFailed.getRisk() ? riskAborted : riskFailed;
            if (maxRisk == FlagStatus.OK) {
                assessment.setScore(Integer.valueOf(0));
                assessment.setHeadline("Release is on track");
            } else {
                String level = maxRisk == FlagStatus.ATTENTION_NEEDED ? "medium" : "high";
                assessment.setHeadline(String.format("Release has %s predicted risk", level));
                assessment.setScore(Integer.valueOf(riskProfile.getValueFor(this.getType())));
                String message = "Release ";
                if (riskFailed != FlagStatus.OK) {
                    message = message + String.format("may have failures (%d%%)", (int)Math.round(prediction.probabilityIsRisky() * 100.0));
                }
                if (riskAborted != FlagStatus.OK) {
                    if (riskFailed != FlagStatus.OK) {
                        message = message + " and ";
                    }
                    message = message + String.format("may be aborted (%d%%)", (int)Math.round(prediction.probabilityAborted() * 100.0));
                }
                message = message + ". See release page \"Forecast\" for more details";
                assessment.setMessages(Collections.singletonList(message));
            }
        }
        return assessment;
    }

    @VisibleForTesting
    void setPredictor(ReleasePredictionService predictor) {
        this.predictor = predictor;
    }
}

