/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.predictions;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.core.xml.WriteWithoutPasswordCiConverter;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.config.XlrConfig$reporting$;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.json.CiSerializerHelper$;
import com.xebialabs.xlrelease.plugins.predictions.DevOpsMlRestApi;
import com.xebialabs.xlrelease.plugins.predictions.PythonServices$;
import com.xebialabs.xlrelease.plugins.predictions.ReleasePrediction;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Marker;
import org.springframework.context.annotation.DependsOn;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@DependsOn(value={"serviceStarter"})
@ScalaSignature(bytes="\u0006\u0001\u0005ee\u0001B\u0001\u0003\u00015\u0011\u0001DU3mK\u0006\u001cX-\u00112peRLwN\u001c)sK\u0012L7\r^8s\u0015\t\u0019A!A\u0006qe\u0016$\u0017n\u0019;j_:\u001c(BA\u0003\u0007\u0003\u001d\u0001H.^4j]NT!a\u0002\u0005\u0002\u0013ad'/\u001a7fCN,'BA\u0005\u000b\u0003%AXMY5bY\u0006\u00147OC\u0001\f\u0003\r\u0019w.\\\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005UQR\"\u0001\f\u000b\u0005]A\u0012!B:mMRR'\"A\r\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\u0007\f\u0003\u000f1{wmZ5oO\"AQ\u0004\u0001B\u0001B\u0003%a$A\u0005tG\",G-\u001e7feB\u0011q$J\u0007\u0002A)\u0011Q$\t\u0006\u0003E\r\n\u0001\u0002\u001d7v[\nLgn\u001a\u0006\u0003I!\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003M\u0001\u0012\u0011bU2iK\u0012,H.\u001a:\t\u0011!\u0002!\u0011!Q\u0001\n%\naaY8oM&<\u0007C\u0001\u0016-\u001b\u0005Y#B\u0001\u0015\u0007\u0013\ti3FA\u0005YYJ\u001cuN\u001c4jO\")q\u0006\u0001C\u0001a\u00051A(\u001b8jiz\"2!M\u001a5!\t\u0011\u0004!D\u0001\u0003\u0011\u0015ib\u00061\u0001\u001f\u0011\u0015Ac\u00061\u0001*\u0011\u001d1\u0004A1A\u0005\n]\naDU#T!>s5+R0Q%\u0016#\u0015j\u0011+J\u001f:{\u0016jU0B\u0005>\u0013F+\u0012#\u0016\u0003a\u0002\"!\u000f \u000e\u0003iR!a\u000f\u001f\u0002\t1\fgn\u001a\u0006\u0002{\u0005!!.\u0019<b\u0013\ty$H\u0001\u0004TiJLgn\u001a\u0005\u0007\u0003\u0002\u0001\u000b\u0011\u0002\u001d\u0002?I+5\u000bU(O'\u0016{\u0006KU#E\u0013\u000e#\u0016j\u0014(`\u0013N{\u0016IQ(S)\u0016#\u0005\u0005C\u0004D\u0001\t\u0007I\u0011B\u001c\u00029I+5\u000bU(O'\u0016{\u0006KU#E\u0013\u000e#\u0016j\u0014(`\u0013N{&+S*L3\"1Q\t\u0001Q\u0001\na\nQDU#T!>s5+R0Q%\u0016#\u0015j\u0011+J\u001f:{\u0016jU0S\u0013N[\u0015\f\t\u0005\b\u000f\u0002\u0011\r\u0011\"\u0003I\u0003\u0011\u0011Xm\u001d;\u0016\u0003%\u0003\"AS*\u000e\u0003-S!\u0001T'\u0002\r\rd\u0017.\u001a8u\u0015\tqu*A\u0002xK\nT!\u0001U)\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011AU\u0001\u0004_J<\u0017B\u0001+L\u00051\u0011Vm\u001d;UK6\u0004H.\u0019;f\u0011\u00191\u0006\u0001)A\u0005\u0013\u0006)!/Z:uA!9\u0001\f\u0001b\u0001\n\u0017I\u0016\u0001E3yK\u000e,H/[8o\u0007>tG/\u001a=u+\u0005Q\u0006CA._\u001b\u0005a&BA/\u0011\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003?r\u0013\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\t\r\u0005\u0004\u0001\u0015!\u0003[\u0003E)\u00070Z2vi&|gnQ8oi\u0016DH\u000f\t\u0005\u0006G\u0002!\t\u0001Z\u0001\u0005S:LG\u000fF\u0001f!\tya-\u0003\u0002h!\t!QK\\5uQ\t\u0011\u0017\u000e\u0005\u0002k_6\t1N\u0003\u0002m[\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u00039\fQA[1wCbL!\u0001]6\u0003\u001bA{7\u000f^\"p]N$(/^2u\u0011\u0015\u0011\b\u0001\"\u0001t\u0003\u0015!(/Y5o)\u0005!\bcA;yu6\taO\u0003\u0002x!\u0005!Q\u000f^5m\u0013\tIhOA\u0002Uef\u00042a_A\u0003\u001d\ra\u0018\u0011\u0001\t\u0003{Bi\u0011A \u0006\u0003\u007f2\ta\u0001\u0010:p_Rt\u0014bAA\u0002!\u00051\u0001K]3eK\u001aL1aPA\u0004\u0015\r\t\u0019\u0001\u0005\u0005\u0007\u0003\u0017\u0001A\u0011\u00023\u0002\u001dQ\u0014\u0018-\u001b8M_\u001e,%O]8sg\"9\u0011q\u0002\u0001\u0005\u0002\u0005E\u0011a\u00029sK\u0012L7\r\u001e\u000b\u0005\u0003'\tY\u0002\u0005\u0003vq\u0006U\u0001c\u0001\u001a\u0002\u0018%\u0019\u0011\u0011\u0004\u0002\u0003#I+G.Z1tKB\u0013X\rZ5di&|g\u000e\u0003\u0005\u0002\u001e\u00055\u0001\u0019AA\u0010\u0003\u001d\u0011X\r\\3bg\u0016\u0004B!!\t\u0002(5\u0011\u00111\u0005\u0006\u0004\u0003K1\u0011A\u00023p[\u0006Lg.\u0003\u0003\u0002*\u0005\r\"a\u0002*fY\u0016\f7/\u001a\u0005\b\u0003[\u0001A\u0011BA\u0018\u0003y\u0001\u0018M]:f%\u0016dW-Y:f!J,G-[2uS>t'+Z:q_:\u001cX\r\u0006\u0004\u0002\u0016\u0005E\u00121\f\u0005\b\u0007\u0005-\u0002\u0019AA\u001a!\u0015y\u0011QGA\u001d\u0013\r\t9\u0004\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003w\t)F\u0004\u0003\u0002>\u0005Ec\u0002BA \u0003\u001frA!!\u0011\u0002N9!\u00111IA&\u001d\u0011\t)%!\u0013\u000f\u0007u\f9%C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0007\u0011I1!a\u0015\u0003\u0003=!UM^(qg6c'+Z:u\u0003BL\u0017\u0002BA,\u00033\u0012!\u0003\u0015:fI&\u001cG/[8o%\u0016\u001c\bo\u001c8tK*\u0019\u00111\u000b\u0002\t\u0011\u0005u\u00111\u0006a\u0001\u0003?Aq!a\u0018\u0001\t\u0013\t\t'\u0001\u000bdQ\u0016\u001c7nQ8o]\u0016\u001cG/[8o\u0003NLhn\u0019\u000b\u0003\u0003G\u0002BaWA3K&\u0019\u0011q\r/\u0003\r\u0019+H/\u001e:f\u0011\u001d\tY\u0007\u0001C\u0005\u0003[\naaZ3u+JdW#\u0001>\t\u000f\u0005E\u0004\u0001\"\u0003\u0002n\u0005\u0019r-\u001a;UCN\\7oU2iK6\f\u0017i]\"tm\":\u0001!!\u001e\u0002\u0004\u0006\u0015\u0005\u0003BA<\u0003\u007fj!!!\u001f\u000b\u00071\fYHC\u0002\u0002~=\u000bqaY8oi\u0016DH/\u0003\u0003\u0002\u0002\u0006e$!\u0003#fa\u0016tGm](o\u0003\u00151\u0018\r\\;fY\t\t9)\t\u0002\u0002\n\u0006q1/\u001a:wS\u000e,7\u000b^1si\u0016\u0014\bf\u0001\u0001\u0002\u000eB!\u0011qRAK\u001b\t\t\tJC\u0002\u0002\u0014>\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\t9*!%\u0003\u0013\r{W\u000e]8oK:$\b")
public class ReleaseAbortionPredictor
implements Logging {
    private final Scheduler scheduler;
    private final XlrConfig config;
    private final String RESPONSE_PREDICTION_IS_ABORTED;
    private final String RESPONSE_PREDICTION_IS_RISKY;
    private final RestTemplate rest;
    private final ExecutionContext executionContext;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReleaseAbortionPredictor releaseAbortionPredictor = this;
        synchronized (releaseAbortionPredictor) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private String RESPONSE_PREDICTION_IS_ABORTED() {
        return this.RESPONSE_PREDICTION_IS_ABORTED;
    }

    private String RESPONSE_PREDICTION_IS_RISKY() {
        return this.RESPONSE_PREDICTION_IS_RISKY;
    }

    private RestTemplate rest() {
        return this.rest;
    }

    private ExecutionContext executionContext() {
        return this.executionContext;
    }

    @PostConstruct
    public void init() {
        PythonServices$.MODULE$.releaseAbortionPredictor().set(this);
        this.checkConnectionAsync();
        Duration buildModelEvery = this.config.getRootConfig().getDuration("xl.plugin.riskPredictions.modelBuildPeriod");
        Duration initialDelay = this.config.getRootConfig().getDuration("xl.plugin.riskPredictions.modelBuildInitialDelay");
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Will start building prediction models every ", " after ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{buildModelEvery, initialDelay})));
        this.scheduler.scheduleAtFixedRate(() -> this.trainLogErrors(), initialDelay.toMillis(), buildModelEvery.toMillis(), TimeUnit.MILLISECONDS);
    }

    public Try<String> train() {
        Failure failure;
        long start = System.currentTimeMillis();
        String url = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/api/train/all?validate=true"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getUrl()}));
        XlrConfig$reporting$ db = this.config.reporting();
        java.util.Map body = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Releases archive at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ServerConfiguration.getInstance().getServerUrl()}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"jdbc_url"), (Object)db.dbUrl()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"username"), (Object)db.dbUsername()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"password"), (Object)db.dbPassword()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"driver_classname"), (Object)db.dbDriverClassname()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tasks_schema_csv_content"), (Object)this.getTasksSchemaAsCsv())}))).asJava();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        try {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Start building prediction models at ", " with DB connection ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getUrl(), db.dbUrl()})));
            ResponseEntity response = this.rest().postForEntity(url, (Object)new HttpEntity((Object)body, (MultiValueMap)headers), String.class, new Object[0]);
            long duration = System.currentTimeMillis() - start;
            String trainResponseAsString = (String)response.getBody();
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finished building prediction models in ", " ms: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)duration), trainResponseAsString})));
            failure = new Success((Object)trainResponseAsString);
        }
        catch (HttpClientErrorException e) {
            failure = new Failure((Throwable)new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to build prediction models: ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getStatusCode()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getResponseBodyAsString()}))));
        }
        return failure;
    }

    private void trainLogErrors() {
        Try<String> try_ = this.train();
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().error((Function0 & Serializable & scala.Serializable)() -> e.getMessage());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Try<ReleasePrediction> predict(Release release) {
        Failure failure;
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requesting predictions for release ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{release})));
        long start = System.currentTimeMillis();
        String url = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/api/predict/xlr_release_models"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getUrl()}));
        String releaseJson = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        try {
            ResponseEntity response = this.rest().postForEntity(url, (Object)new HttpEntity((Object)releaseJson, (MultiValueMap)headers), DevOpsMlRestApi.PredictionResponse[].class, new Object[0]);
            DevOpsMlRestApi.PredictionResponse[] predictions = (DevOpsMlRestApi.PredictionResponse[])response.getBody();
            long duration = System.currentTimeMillis() - start;
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got predictions for release ", " in ", " ms: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{release, BoxesRunTime.boxToLong((long)duration), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predictions)).toSeq()})));
            failure = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.parseReleasePredictionResponse(predictions, release));
        }
        catch (HttpClientErrorException e) {
            failure = new Failure((Throwable)new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got unsuccessful response when predicting for release ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{release})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getStatusCode(), e.getResponseBodyAsString()}))));
        }
        return failure;
    }

    private ReleasePrediction parseReleasePredictionResponse(DevOpsMlRestApi.PredictionResponse[] predictions, Release release) {
        scala.collection.immutable.Map probabilities = ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.RESPONSE_PREDICTION_IS_ABORTED(), this.RESPONSE_PREDICTION_IS_RISKY()}))).map((Function1 & Serializable & scala.Serializable)name -> {
            Option option = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predictions)).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ReleaseAbortionPredictor.$anonfun$parseReleasePredictionResponse$2(name, x$1)));
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There was no prediction '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for release ", " in the response from the model: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{release, predictions})));
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            DevOpsMlRestApi.PredictionResponse prediction = (DevOpsMlRestApi.PredictionResponse)some.value();
            Tuple2 tuple2 = new Tuple2(name, (Object)BoxesRunTime.boxToDouble((double)prediction.probability()));
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return new ReleasePrediction(BoxesRunTime.unboxToDouble((Object)probabilities.apply((Object)this.RESPONSE_PREDICTION_IS_ABORTED())), BoxesRunTime.unboxToDouble((Object)probabilities.apply((Object)this.RESPONSE_PREDICTION_IS_RISKY())));
    }

    private Future<BoxedUnit> checkConnectionAsync() {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                ResponseEntity response = this.rest().getForEntity(this.getUrl(), java.util.Map.class, new Object[0]);
                scala.collection.mutable.Map data = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)response.getBody()).asScala();
                this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connected to DevOpsML at ", ": version ", ", hostname ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getUrl(), data.apply((Object)"version"), data.apply((Object)"hostname")})));
            }
            catch (HttpClientErrorException e) {
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not connect to DevOpsML at ", ": ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getUrl(), e.getStatusCode()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getResponseBodyAsString()})));
            }
        }, this.executionContext());
    }

    private String getUrl() {
        return this.config.getRootConfig().getString("xl.plugin.riskPredictions.xlDevopsMlUrl").replaceFirst("/$", "");
    }

    private String getTasksSchemaAsCsv() {
        Seq rows = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"category", (Object)"name", (Object)"task")}))).$plus$plus((GenTraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(DescriptorRegistry.getSubtypes((Type)Type.valueOf(PythonScript.class))).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReleaseAbortionPredictor.$anonfun$getTasksSchemaAsCsv$1(x$2)))).flatMap((Function1 & Serializable & scala.Serializable)t -> (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(t.getDescriptor().getPropertyDescriptors()).asScala()).map((Function1 & Serializable & scala.Serializable)prop -> new Tuple3((Object)prop.getCategory(), (Object)prop.getName(), (Object)t.toString()), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        return ((TraversableOnce)rows.map((Function1 & Serializable & scala.Serializable)r -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ",", ",", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{r._1(), r._2(), r._3()})), Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    public static final /* synthetic */ boolean $anonfun$parseReleasePredictionResponse$2(String name$1, DevOpsMlRestApi.PredictionResponse x$1) {
        String string = x$1.name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getTasksSchemaAsCsv$1(Type x$2) {
        return !x$2.getDescriptor().isVirtual();
    }

    public ReleaseAbortionPredictor(Scheduler scheduler, XlrConfig config) {
        this.scheduler = scheduler;
        this.config = config;
        Logging.$init$((Logging)this);
        this.RESPONSE_PREDICTION_IS_ABORTED = "is_aborted";
        this.RESPONSE_PREDICTION_IS_RISKY = "is_risky";
        this.rest = new RestTemplate();
        this.executionContext = ExecutionContext$.MODULE$.global();
    }
}

