from com.xebialabs.xlrelease.plugins.predictions import PythonServices
from com.xebialabs.deployit.exception import NotFoundException

if 'releaseId' not in request.query:
    raise Exception('Please specify the releaseId query parameter in the request')

releaseId = request.query['releaseId']

try:
    release = releaseApi.getRelease(releaseId)
except NotFoundException:
    release = releaseApi.getArchivedRelease(releaseId)

predictor = PythonServices.getReleaseAbortionPredictorInstance()
prediction = predictor.predict(release).get()

response.entity = {
    'proba_aborted': prediction.probabilityAborted(),
    'proba_is_risky': prediction.probabilityIsRisky(),
    'current_status': release.getStatus().toString()
}
