/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.predictions.risk;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.plugins.predictions.PythonServices;
import com.xebialabs.xlrelease.plugins.predictions.ReleaseAbortionPredictor;
import com.xebialabs.xlrelease.plugins.predictions.ReleasePrediction;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.riskassessors.RiskAssessor;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.util.Try;

@Metadata(label="ReleaseAbortionRiskAssessor", versioned=false)
public class ReleaseAbortionRiskAssessor
extends RiskAssessor {
    private static final Logger logger = LoggerFactory.getLogger(ReleaseAbortionRiskAssessor.class);
    private ReleaseAbortionPredictor predictor = PythonServices.getReleaseAbortionPredictorInstance();

    public RiskAssessment execute(Release release, RiskProfile riskProfile) {
        RiskAssessment assessment = new RiskAssessment();
        assessment.setRiskAssessorId(this.getId());
        Try<ReleasePrediction> predictionTry = this.predictor.predict(release);
        if (predictionTry.isFailure()) {
            logger.error(String.format("Could not assess abortion risk of release %s: %s", release, predictionTry));
            assessment.setScore(Integer.valueOf(0));
            assessment.setHeadline("Release is on track");
        } else {
            ReleasePrediction prediction = (ReleasePrediction)predictionTry.get();
            if (prediction.probabilityAborted() < 0.5 && prediction.probabilityIsRisky() < 0.5) {
                assessment.setScore(Integer.valueOf(0));
                assessment.setHeadline("Release is on track");
            } else {
                assessment.setHeadline("This release might fail");
                assessment.setScore(Integer.valueOf(riskProfile.getValueFor(this.getType())));
                String messageIsRisky = String.format("This release will have failures or delays with probability %d%%", (int)Math.round(prediction.probabilityIsRisky() * 100.0));
                String messageAborted = String.format("This release will be aborted with probability %d%%", (int)Math.round(prediction.probabilityAborted() * 100.0));
                assessment.setMessages(Arrays.asList(messageIsRisky, messageAborted));
            }
        }
        return assessment;
    }

    @VisibleForTesting
    void setPredictor(ReleaseAbortionPredictor predictor) {
        this.predictor = predictor;
    }
}

