/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.overthere;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.Overthere;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.util.CapturingOverthereExecutionOutputHandler;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;

abstract class RemoteScript {
    private static final String SCRIPT_NAME = "uploaded-script";
    private final ConnectionOptions options = new ConnectionOptions();
    private final String protocol;
    private final String remotePath;
    private final String script;
    private final String extension;
    private final CapturingOverthereExecutionOutputHandler stdout = CapturingOverthereExecutionOutputHandler.capturingHandler();
    private final CapturingOverthereExecutionOutputHandler stderr = CapturingOverthereExecutionOutputHandler.capturingHandler();

    protected RemoteScript(OperatingSystemFamily osFamily, String protocol, String username, String password, String address, String remotePath, String script) {
        this.options.set("username", (Object)username);
        this.options.set("password", (Object)password);
        this.options.set("address", (Object)address);
        this.options.set("os", (Object)osFamily);
        this.protocol = protocol;
        this.remotePath = remotePath;
        this.script = script;
        this.extension = osFamily.getScriptExtension();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int execute() {
        this.customize(this.options);
        try (OverthereConnection connection = Overthere.getConnection((String)this.protocol, (ConnectionOptions)this.options);){
            connection.setWorkingDirectory(connection.getFile(this.remotePath));
            OverthereFile targetFile = connection.getTempFile(SCRIPT_NAME, this.extension);
            OverthereUtils.write((byte[])this.script.getBytes(StandardCharsets.UTF_8), (OverthereFile)targetFile);
            targetFile.setExecutable(true);
            CmdLine scriptCommand = CmdLine.build((String[])new String[]{targetFile.getPath()});
            int n = connection.execute((OverthereExecutionOutputHandler)this.stdout, (OverthereExecutionOutputHandler)this.stderr, scriptCommand);
            return n;
        }
        catch (Exception e) {
            StringWriter stacktrace = new StringWriter();
            PrintWriter writer = new PrintWriter((Writer)stacktrace, true);
            e.printStackTrace(writer);
            this.stderr.handleLine(stacktrace.toString());
            return 1;
        }
    }

    public String getStdout() {
        return this.stdout.getOutput();
    }

    public List<String> getStdoutLines() {
        return this.stdout.getOutputLines();
    }

    public String getStderr() {
        return this.stderr.getOutput();
    }

    public List<String> getStderrLines() {
        return this.stderr.getOutputLines();
    }

    protected abstract void customize(ConnectionOptions var1);
}

