package com.xebialabs.xlrelease.plugin.overthere;

import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.cifs.CifsConnectionBuilder;
import com.xebialabs.overthere.cifs.CifsConnectionType;

public class WinrmRemoteScript extends RemoteScript {
    private final String timeout;

    public WinrmRemoteScript(String username, String password, String address, String remotePath, String script, String timeout) {
        super(OperatingSystemFamily.WINDOWS, CifsConnectionBuilder.CIFS_PROTOCOL, username, password, address, remotePath, script);
        this.timeout = timeout;
    }

    @Override
    protected void customize(ConnectionOptions options) {
        options.set(CifsConnectionBuilder.CONNECTION_TYPE, CifsConnectionType.WINRM_INTERNAL);
        options.set(CifsConnectionBuilder.WINRM_KERBEROS_USE_HTTP_SPN, Boolean.TRUE);
        options.set(CifsConnectionBuilder.WINRM_TIMEMOUT, timeout);
    }
}
