package com.xebialabs.xlrelease.plugin.overthere;

import java.io.PrintWriter;
import java.io.StringWriter;

import com.xebialabs.overthere.*;
import com.xebialabs.overthere.util.CapturingOverthereExecutionOutputHandler;
import com.xebialabs.overthere.util.OverthereUtils;

abstract class RemoteScript {
    private static final String SCRIPT_NAME = "uploaded-script";

    private final ConnectionOptions options = new ConnectionOptions();
    private final String protocol;
    private final String remotePath;
    private final String script;
    private final String scriptFile;

    private final CapturingOverthereExecutionOutputHandler stdout = CapturingOverthereExecutionOutputHandler.capturingHandler();
    private final CapturingOverthereExecutionOutputHandler stderr = CapturingOverthereExecutionOutputHandler.capturingHandler();

    protected RemoteScript(OperatingSystemFamily osFamily, String protocol,
                           String username, String password, String address, String remotePath, String script) {
        this.options.set(ConnectionOptions.USERNAME, username);
        this.options.set(ConnectionOptions.PASSWORD, password);
        this.options.set(ConnectionOptions.ADDRESS, address);
        this.options.set(ConnectionOptions.OPERATING_SYSTEM, osFamily);

        this.protocol = protocol;
        this.remotePath = remotePath;
        this.script = script;
        this.scriptFile = SCRIPT_NAME + osFamily.getScriptExtension();
    }

    public int execute() {
        customize(options);

        try (OverthereConnection connection = Overthere.getConnection(protocol, options)) {

            // Upload and execute the script
            OverthereFile targetFile = connection.getFile(remotePath).getFile(scriptFile);
            OverthereUtils.write(script.getBytes(), targetFile);
            targetFile.setExecutable(true);

            CmdLine scriptCommand = CmdLine.build(targetFile.getPath());

            return connection.execute(stdout, stderr, scriptCommand);
        } catch (Exception e) {
            StringWriter stacktrace = new StringWriter();
            PrintWriter writer = new PrintWriter(stacktrace, true);
            e.printStackTrace(writer);
            stderr.handleLine(stacktrace.toString());

            return 1;
        }
    }

    public String getStdout() {
        return stdout.getOutput();
    }

    public String getStderr() {
        return stderr.getOutput();
    }

    /**
     * Customize the connection options for the specific implementation.
     */
    protected abstract void customize(ConnectionOptions options);
}
