package com.xebialabs.xlrelease.plugin.overthere;

class PasswordMaskingOutputHandler extends AbstractOutputHandler {
    private final PasswordMasker masker;

    public PasswordMaskingOutputHandler(OutputHandler outputHandler, PasswordMasker passwordMasker) {
        super(outputHandler);
        this.masker = passwordMasker;
    }

    @Override
    public void handleChar(final char c) {
        // no op
    }

    @Override
    public void handleLine(final String lineWithoutEnding) {
        if (this.outputHandler != null) {
            String masked = masker.maskPassword(lineWithoutEnding);
            this.outputHandler.handleLine(masked);
        }
    }

}
