package com.xebialabs.xlrelease.plugin.overthere;

import java.io.IOException;

abstract class AbstractOutputHandler implements OutputHandler {
    protected final OutputHandler outputHandler;

    public AbstractOutputHandler(OutputHandler outputHandler) {
        this.outputHandler = outputHandler;
    }

    @Override
    public void close() throws IOException {
        if (outputHandler != null) {
            outputHandler.close();
        }
    }

    @Override
    public String getStringContent() throws IOException {
        if (outputHandler != null) {
            return outputHandler.getStringContent();
        } else {
            throw new IOException("OutputHandler is not defined");
        }
    }
}