package com.xebialabs.xlrelease.plugin.overthere;

import java.io.IOException;

import com.xebialabs.xlrelease.script.RingWriter;

public class RingWriterOutputHandler implements OutputHandler {

    private final RingWriter ringWriter;

    RingWriterOutputHandler(int size) {
        this.ringWriter = new RingWriter(size);
    }

    @Override
    public void handleChar(final char c) {
        // no-op
    }

    @Override
    public void handleLine(final String line) {
        try {
            ringWriter.write(line);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getStringContent() throws IOException {
        return ringWriter.toString();
    }

    @Override
    public void close() throws IOException {
        ringWriter.close();
    }
}
