package com.xebialabs.xlrelease.plugin.overthere;

import java.io.OutputStream;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionLogService;
import com.xebialabs.xlrelease.storage.domain.LogEntry;

import scala.Option;

class TaskExecutionLogOutputStream extends OutputStream {
    private final TaskExecutionLogService taskExecutionLogService;
    private final AtomicInteger chunk = new AtomicInteger(0);
    private final String taskId;
    private final String executionId;
    private final int failuresCount;

    TaskExecutionLogOutputStream(TaskExecutionLogService taskExecutionLogService, String taskId, String executionId, int failuresCount) {
        this.taskExecutionLogService = taskExecutionLogService;
        this.taskId = taskId;
        this.executionId = executionId;
        this.failuresCount = failuresCount;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (len > 0) {
            LogEntry entry = new LogEntry(
                    taskId,
                    executionId,
                    failuresCount, // job id == failures count
                    chunk.incrementAndGet(),
                    DateTimeFormatter.ISO_INSTANT.format(Instant.now()),
                    Arrays.copyOf(b, len),
                    Option.empty()
            );

            taskExecutionLogService.log(entry);
        }
    }

    @Override
    public void write(int i) {
        throw new UnsupportedOperationException("Should not write a line with byte by byte when handling log files");
    }
}
