package com.xebialabs.xlrelease.plugin.overthere;

class NewlineAwareOutputHandler extends AbstractOutputHandler {
    private boolean wasLastCharacterNewline = false;

    public NewlineAwareOutputHandler(OutputHandler outputHandler) {
        super(outputHandler);
    }

    @Override
    public void handleChar(final char c) {
        wasLastCharacterNewline = c == '\n';
    }

    @Override
    public void handleLine(final String lineWithoutEnding) {
        String line = wasLastCharacterNewline ? lineWithoutEnding + NL : lineWithoutEnding;
        outputHandler.handleLine(line);
    }

}
