/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.overthere;

import com.xebialabs.xlrelease.plugin.overthere.OutputHandler;
import com.xebialabs.xlrelease.plugin.overthere.TaskExecutionLogHelper;
import java.io.IOException;

class TaskExecutionLogOutputHandler
implements OutputHandler {
    private final OutputHandler outputHandler;
    private final TaskExecutionLogHelper logHelper;

    public TaskExecutionLogOutputHandler(OutputHandler outputHandler, TaskExecutionLogHelper logHelper) {
        this.outputHandler = outputHandler;
        this.logHelper = logHelper;
    }

    public void handleChar(char c) {
    }

    public void handleLine(String line) {
        boolean savedInTaskExecutionLogs = this.logHelper.log(line);
        if (savedInTaskExecutionLogs && this.outputHandler != null) {
            this.outputHandler.handleLine(line);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.logHelper.close();
        }
        finally {
            if (null != this.outputHandler) {
                this.outputHandler.close();
            }
        }
    }

    @Override
    public String getStringContent() throws IOException {
        if (null != this.outputHandler) {
            return this.outputHandler.getStringContent();
        }
        throw new IOException("OutputHandler is not defined");
    }
}

