package com.xebialabs.xlrelease.plugin.overthere;

import java.io.IOException;
import java.io.Writer;

class NonClosingWriterOutputHandler implements OutputHandler {

    private final OutputHandler outputHandler;
    private final Writer writer;

    public NonClosingWriterOutputHandler(OutputHandler outputHandler, Writer output) {
        this.outputHandler = outputHandler;
        this.writer = output;
    }

    @Override
    public void close() throws IOException {
        writer.flush();
    }

    @Override
    public String getStringContent() throws IOException {
        return outputHandler != null ? outputHandler.getStringContent() : "";
    }

    @Override
    public void handleChar(final char c) {
        // do nothing
    }

    @Override
    public void handleLine(final String line) {
        try {
            writer.write(line);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (outputHandler != null) {
            outputHandler.handleLine(line);
        }
    }
}
